/* $Id$
 * hash.c: hashing functions for images
 * Copyright (c) 1995, Joe Traister
 *
 * $Log$
 *
 */
#include <malloc.h>
#include <string.h>
#include <errno.h>
#include "vimage.h"
#include "hash.h"

void freehash(COLORHISTLIST *cht)
{
  int i;
  COLORHISTLIST *chl, *chtmp;

  for (i=0; i < HASH_SIZE; i++) {
    chl=cht[i].next;
    while (chl) {
      chtmp = chl->next;
      free(chl);
      chl = chtmp;
    }
  }
  free(cht);
}

int addtohash(int r, int g, int b, int value, COLORHISTLIST *hashtable)
{
  int i=hash(r, g, b);
  COLORHISTLIST *chl=&hashtable[i];

  if (chl->count < 0) {
    chl->r = r;
    chl->g = g;
    chl->b = b;
    chl->count = value;
  } else {
    while (chl && (chl->r != r || chl->g != g || chl->b != b))
      chl = chl->next;
    if (!chl) {
      if (!(chl = (COLORHISTLIST*)malloc(sizeof(COLORHISTLIST)))) {
	strcpy(errmsg, strerror(errno));
	return -1;
      }
      chl->r = r;
      chl->g = g;
      chl->b = b;
      chl->count = value;
      chl->next = hashtable[i].next;
      hashtable[i].next = chl;
    }
  }
  return 0;
}

int lookuphash(int r, int g, int b, COLORHISTLIST *hashtable)
{
  int i=hash(r, g, b);
  COLORHISTLIST *chl=&hashtable[i];

  if (hashtable[i].count < 0)
    return -1;
  while (chl && (chl->r != r || chl->g != g || chl->b != b))
    chl = chl->next;
  if (chl)
    return chl->count;
  else
    return -1;
}
