/*  **************************************************************************
 * 
 * --- File: pcx2ps.c
 * 
 * --- Purpose: this program translates a monochrome .pcx file into a
 *              PostScript file.
 * 
 * --- Developed with: Pentium PC, Linux 2.0.27, gcc 2.7.2.1
 * 
 * --- Copyright: Guido Gonzato, guido@ibogfs.cineca.it
 * 
 * --- Last updated: October 10, 1997
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * ************************************************************************ */


#include <stdio.h>
#include <stdlib.h>
#include "vscrn.h"

#define  ME "pcx2ps"

/* ----- */

void ps_save(int x1, int y1, int x2, int y2, char *title)
{

/* This function saves a screen portion as a PostScript file, centered on a
   A4 sheet of paper, 144 dpi. */

  FILE *f;
  int cx, cy, x, y, b, i;
  int vet[4] = { 8, 4, 2, 1 };
  char hexa[] = "0123456789abcdef";

  cx = 297;  /* screen center in 1/72 inch */
  cy = 420;
  x = x2 - x1 + 1;
  y = y2 - y1 + 1;
  
  f = fopen(title, "w");
  fprintf(f, "%%!PS-Adobe-2.0 EPSF-2.0\n");
  fprintf(f, "%%%%Creator: pcx2ps\n");
  fprintf(f, "%%%%Title: %s\n", title);
  fprintf(f, "%%%%Pages: 1\n");
  fprintf(f, "%%%%BoundingBox: %d %d %d %d\n", cx - x / 4, cy - y / 4,
                                               cx + x / 4, cy + y / 4);
  fprintf(f, "%%%%EndComments\n");
  fprintf(f, "%%%%EndProlog\n");
  fprintf(f, "%%%%Page: 1 1\n");
  fprintf(f, "/origstate save def\n");
  fprintf(f, "20 dict begin\n");
  fprintf(f, "/pix %d string def\n", x / 8);
  fprintf(f, "%d %d translate\n", cx - x / 4, cy - y / 4);
  fprintf(f, "%d %d scale\n", x / 2, y / 2);
  fprintf(f, "%d %d 1\n", x, y);
  fprintf(f, "[ %d 0 0 -%d 0 %d ]\n", x, y, y);
  fprintf(f, "{currentfile pix readhexstring pop}\n");
  fprintf(f, "image\n");

  /* pixels */
  
  for (y = y1; y <= y2; y++)
    for (x = x1; x <= x2; x += 4) {
      
      b = 15; /* all white */
      
      for (i = 0; i < 4; i++)
        if (vgetpixel(x + i, y))
          b -= vet[i];
      
      fputc(hexa[b], f);

    }
  
  fprintf(f, "\n\n\n");
  fprintf(f, "showpage\n");
  fprintf(f, "end\n");
  fprintf(f, "origstate restore\n");
  fprintf(f, "%%%%Trailer\n");
  
  fclose(f);

} /* ps_save() */

/* ----- */

void main(int argc, char *argv[])
{

  char name[30];
  int  i, len, x1, y1, x2, y2;
  
  if (argc == 1) {
    fprintf(stderr, "usage: %s <file.pcx> [file.pcx ...]\n", ME);
    exit(1);
  }

  initvpcx();

  for (i = 1; i < argc; i++) {
  
    strcpy(name, argv[i]);
    len = strlen(name);
    vcleardevice();
    vpcxload(0, 0, name);
    vpcxdim(&x1, &y1, &x2, &y2);
    name[len - 2] = 's';    
    name[len - 1] = '\0';
    ps_save(x1, y1, x2, y2, name);
  
  } /* for */

  exit(0);

}

/* --- End of file pcx2ps.c --- */
