/*  **************************************************************************
 * 
 * --- File: uxcrt.h
 * 
 * --- Purpose: header file for uxcrt.c
 * 
 * --- Developed with: Pentium PC, Linux 2.0.27, gcc 2.7.2.1
 * 
 * --- Copyright: Guido Gonzato, guido@ibogfs.cineca.it
 * 
 * --- Last updated: October 10, 1997
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * ************************************************************************ */


#define   UXCRT

#define   UNS          unsigned int
#define   ULONG        unsigned long int
#define   MAX_LEN      256
#define   STRING       char[MAX_LEN]
#ifndef   TRUE
#  define TRUE 1
#  define FALSE 0
#endif

char *strings(char *, int, int);
char *toleft(char *, int);

/* functions for the input of strings, numbers, and dates */

char *strdel(char *, int, int);
char *strmid(char *, int, int);
char *scpymid(char *, char *, int, int);
char *chrcat(char *, int);
char *chrins(char *, int, int);
int  chrinstr(int, char *);
int  chrpos(int, char *);
char *strins(char *, char *, int);
void comma2num(char *, double *, int *);
char *num2comma(double, char *, int);
char *num2str(double, char *);
int leap(int);
int dateless(char *, char *);
int datelesseq(char *, char *);
int dateincluded(char *, char *, char *);
int dayofyear(char *);
long daydiff(char *, char *);

/* utilities */

char *word2exa(UNS, char *);
char *long2exa(ULONG, char *);


/* --- End of file uxcrt.h --- */
