/*
   fofx: function grapher for ASCII terminals
   Copyright (C) 1997 Tom Stepleton

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
   amerrors.h: A perhaps anal-retentive error-handling system
*/

#define FATAL_ERROR -1
#define NO_ERROR 0
#define CALC_ERROR 1
#define COLS_ERROR 2
#define TLX_ERROR 3
#define TLY_ERROR 4
#define BRX_ERROR 5
#define BRY_ERROR 6
#define IV_ERROR 7
#define NO_DATA_ERROR 8
#define COLS_BAD_ERROR 9
#define IV_BAD_ERROR 10
#define RANGE_ERROR 11
#define PREPARSE_ERROR 12
#define ALL_LCASE_ERROR 13
#define EQN_ERROR 14
#define NO_EQN_ERROR 15
#define ALIEN_ERROR 16
#define BAD_TOKEN_ERROR 17
#define LONG_CONSTANT_ERROR 18
#define MEMORY_ERROR 19
#define HELP_MESSAGE 20
#define VERSION_MESSAGE 21

static char *error_messages[] = {
"No error",
"Calculation error",
"-cols error:",
"-tlx error:",
"-tly error:",
"-brx error:",
"-bry error:",
"-iv error:",
"An input constant is required: (-option <constant>)",
"Input must be a positive integer",
"Input must be a positive double",
"Input is out of range",
"preparse() had an error",
"all_lcase(), a preparser routine, had an error",
"Equation error",
"No equation entered",
"Unrecognized equation component",
"Bad token! You should not see this error",
"An equation constant is too long",
"Out of memory error",
"Usage: fofx [-axes] [-cols columns] [-tlx,-tly,-brx,-bry constant] [-iv interval] equation",
"This is fofx version 0.5 (beta!)"
};
