/*************************************************************************
** funct-3.1      (command interpreter - funct)                          **
** names.c :    names of functions corresponding to commands             **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include "mconf.h"
#include "funct.h"

int wait_cmd(int argc, char *argv[]);
int sleep_cmd(int argc, char *argv[]);


/*-------------------------------------------------------------------------
---------------------------------------------------------------------------
    Functions defined in the CEPHES library
---------------------------------------------------------------------------
-------------------------------------------------------------------------*/
extern double bdtrc ( int k, int n, double p );
extern double bdtr ( int k, int n, double p );
extern double bdtri ( int k, int n, double y );
extern double beta ( double a, double b );
extern double lbeta ( double a, double b );
extern double chdtrc ( double df, double x );
extern double chdtr ( double df, double x );
extern double chdtri ( double df, double y );
extern double hypot ( double x, double y );
extern double dawsn ( double xx );
extern double ellie ( double phi, double m );
extern double ellik ( double phi, double m );
extern double ellpe ( double x );
extern double ellpk ( double x );
extern double fdtrc ( int ia, int ib, double x );
extern double fdtr ( int ia, int ib, double x );
extern double fdtri ( int ia, int ib, double y );
extern double gamma ( double x );
extern double lgam ( double x );
extern double gdtr ( double a, double b, double x );
extern double gdtrc ( double a, double b, double x );
extern double hyperg ( double a, double b, double x );
extern double i0 ( double x );
extern double i0e ( double x );
extern double i1 ( double x );
extern double i1e ( double x );
extern double igamc ( double a, double x );
extern double igam ( double a, double x );
extern double igami ( double a, double y0 );
extern double incbet ( double aa, double bb, double xx );
extern double incbi ( double aa, double bb, double yy0 );
extern double iv ( double v, double x );
extern double j0 ( double x );
extern double y0 ( double x );
extern double j1 ( double x );
extern double y1 ( double x );
extern double jn ( int n, double x );
extern double jv ( double n, double x );
extern double k0 ( double x );
extern double k0e ( double x );
extern double k1 ( double x );
extern double k1e ( double x );
extern double kn ( int nn, double x );
extern double nbdtrc ( int k, int n, double p );
extern double nbdtr ( int k, int n, double p );
extern double nbdtri ( int k, int n, double p );
extern double ndtr ( double a );
extern double erfc ( double a );
extern double erf ( double x );
extern double ndtri ( double y0 );
extern double pdtrc ( int k, double m );
extern double pdtr ( int k, double m );
extern double pdtri ( int k, double y );
extern double psi ( double x );
extern double rgamma ( double x );
extern double spence ( double x );
extern double stdtr ( int k, double t );
extern double stdtri ( int k, double p );
extern double struve ( double v, double x );
extern double yn ( int n, double x );
extern double zeta ( double x, double q );
extern double zetac ( double x );
/*-----------------------------------------------------------------------*/





/*-------------------------------------------------------------------------
---------------------------------------------------------------------------
    Functions corresponding to commands
---------------------------------------------------------------------------
-------------------------------------------------------------------------*/
pfi             proc_func[] =
{
    add_func,
    comp_func,
    const_func,
    convol_func,
    copy_func,
    def_bessel_param,
    def_funct_f,
    def_funct_d,
    def_funct_C,
    def_funct_dC,
    def_xrange_f,
    def_xrange_d,
    def_four_prec,
    desc_func,
    diff_func,
    div_func,
    FFT_func,
    fill_func,
    fix_func_R,
    fix_func_C,
    fix_xrange_f,
    fix_xrange_d,
    reel_imag_Cfunc,
    reel_imag_fix_func,
    integ_func,
    inv_func_cmd,
    load_create_f,
    load_create_d,
    load_create_C,
    load_create_dC,
    load_funct,
    Max_funct_cmd,
    Min_funct_cmd,
    mul_func,
    reel_imag_Cfunc,
    reel_imag_fix_func,
    Rmul_func,
    sauve_func,
    sleep_cmd,
    sub_func,
    trans_bessel,
    trans_four_prec,
    val_func,
    wait_cmd,
};
/*-----------------------------------------------------------------------*/





/*-----------------------------------------------------------------------*/
double
_Funct_sin(double *x)
{
    return sin(*x);
}

double
_Funct_cos(double *x)
{
    return cos(*x);
}

double
_Funct_tan(double *x)
{
    return tan(*x);
}

double
_Funct_asin(double *x)
{
    return asin(*x);
}

double
_Funct_acos(double *x)
{
    return acos(*x);
}

double
_Funct_atan(double *x)
{
    return atan(*x);
}

double
_Funct_sinh(double *x)
{
    return sinh(*x);
}

double
_Funct_cosh(double *x)
{
    return cosh(*x);
}

double
_Funct_tanh(double *x)
{
    return tanh(*x);
}

double
_Funct_exp(double *x)
{
    return exp(*x);
}

double
_Funct_log(double *x)
{
    return log(*x);
}

double
_Funct_log10(double *x)
{
    return log10(*x);
}

double
_Funct_sqrt(double *x)
{
    return sqrt(*x);
}

double
_Funct_floor(double *x)
{
    return floor(*x);
}

double
_Funct_ceil(double *x)
{
    return ceil(*x);
}

double
_Funct_fabs(double *x)
{
    return fabs(*x);
}

double
_Funct_hypot(double *x)
{
    return hypot(x[0], x[1]);
}

double
_Funct_acosh(double *x)
{
    return acosh(*x);
}

double
_Funct_asinh(double *x)
{
    return asinh(*x);
}

double
_Funct_atanh(double *x)
{
    return atanh(*x);
}

double
_Funct_beta(double *x)
{
    return beta(x[0], x[1]);
}

double
_Funct_lbeta(double *x)
{
    return lbeta(x[0], x[1]);
}

double
_Funct_deg(double *x)
{
    return deg(*x);
}

double
_Funct_rad(double *x)
{
    return rad(*x);
}

double
_Funct_chdtrc(double *x)
{
    return chdtrc(x[0], x[1]);
}

double
_Funct_chdtr(double *x)
{
    return chdtr(x[0], x[1]);
}

double
_Funct_chdtri(double *x)
{
    return chdtri(x[0], x[1]);
}

double
_Funct_dawsn(double *x)
{
    return dawsn(*x);
}

double
_Funct_ellie(double *x)
{
    return ellie(x[0], x[1]);
}

double
_Funct_ellik(double *x)
{
    return ellik(x[0], x[1]);
}

double
_Funct_ellpe(double *x)
{
    return ellpe(*x);
}

double
_Funct_ellpk(double *x)
{
    return ellpk(*x);
}

double
_Funct_gamma(double *x)
{
    return gamma(*x);
}

double
_Funct_lgam(double *x)
{
    return lgam(*x);
}

double
_Funct_gdtr(double *x)
{
    return gdtr(x[0], x[1], x[2]);
}

double
_Funct_gdtrc(double *x)
{
    return gdtrc(x[0], x[1], x[2]);
}

double
_Funct_hyperg(double *x)
{
    return hyperg(x[0], x[1], x[2]);
}

double
_Funct_i0(double *x)
{
    return i0(*x);
}

double
_Funct_i0e(double *x)
{
    return i0e(*x);
}

double
_Funct_igamc(double *x)
{
    return igamc(x[0], x[1]);
}

double
_Funct_igam(double *x)
{
    return igam(x[0], x[1]);
}

double
_Funct_igami(double *x)
{
    return igami(x[0], x[1]);
}

double
_Funct_incbet(double *x)
{
    return incbet(x[0], x[1], x[2]);
}

double
_Funct_incbi(double *x)
{
    return incbi(x[0], x[1], x[2]);
}

double
_Funct_iv(double *x)
{
    return iv(x[0], x[1]);
}

double
_Funct_j0(double *x)
{
    return j0(*x);
}

double
_Funct_y0(double *x)
{
    return y0(*x);
}

double
_Funct_j1(double *x)
{
    return j1(*x);
}

double
_Funct_y1(double *x)
{
    return y1(*x);
}

double
_Funct_jv(double *x)
{
    return jv(x[0], x[1]);
}

double
_Funct_k0(double *x)
{
    return k0(*x);
}

double
_Funct_k0e(double *x)
{
    return k0e(*x);
}

double
_Funct_k1(double *x)
{
    return k1(*x);
}

double
_Funct_k1e(double *x)
{
    return k1e(*x);
}

double
_Funct_ndtr(double *x)
{
    return ndtr(*x);
}

double
_Funct_ndtri(double *x)
{
    return ndtri(*x);
}

double
_Funct_erf(double *x)
{
    return erf(*x);
}

double
_Funct_erfc(double *x)
{
    return erfc(*x);
}

double
_Funct_psi(double *x)
{
    return psi(*x);
}

double
_Funct_rgamma(double *x)
{
    return rgamma(*x);
}

double
_Funct_spence(double *x)
{
    return spence(*x);
}

double
_Funct_struve(double *x)
{
    return struve(x[0], x[1]);
}

double
_Funct_zeta(double *x)
{
    return zeta(x[0], x[1]);
}

double
_Funct_zetac(double *x)
{
    return zetac(*x);
}

double
_Funct_bdtr(double *x)
{
    return bdtr(x[0], x[1], x[2]);
}

double
_Funct_bdtri(double *x)
{
    return bdtri(x[0], x[1], x[2]);
}

double
_Funct_bdtrc(double *x)
{
    return bdtrc(x[0], x[1], x[2]);
}

double
_Funct_fdtr(double *x)
{
    return fdtr(x[0], x[1], x[2]);
}

double
_Funct_fdtri(double *x)
{
    return fdtri(x[0], x[1], x[2]);
}

double
_Funct_fdtrc(double *x)
{
    return fdtrc(x[0], x[1], x[2]);
}

double
_Funct_jn(double *x)
{
    return jn(x[0], x[1]);
}

double
_Funct_kn(double *x)
{
    return kn(x[0], x[1]);
}

double
_Funct_nbdtr(double *x)
{
    return nbdtr(x[0], x[1], x[2]);
}

double
_Funct_nbdtri(double *x)
{
    return nbdtri(x[0], x[1], x[2]);
}

double
_Funct_nbdtrc(double *x)
{
    return nbdtrc(x[0], x[1], x[2]);
}

double
_Funct_pdtr(double *x)
{
    return pdtr(x[0], x[1]);
}

double
_Funct_pdtri(double *x)
{
    return pdtri(x[0], x[1]);
}

double
_Funct_pdtrc(double *x)
{
    return pdtrc(x[0], x[1]);
}

double
_Funct_yn(double *x)
{
    return yn(x[0], x[1]);
}

double
_Funct_stdtri(double *x)
{
    return stdtri(x[0], x[1]);
}

double
_Funct_stdtr(double *x)
{
    return stdtr(x[0], x[1]);
}


FUNCTION Funcs_func[] =
{
   /* name, function to call */
   { "sin",     1,    _Funct_sin },            /* 0    */
   { "cos",     1,    _Funct_cos },            /* 1    */
   { "tan",     1,    _Funct_tan },            /* 2    */
   { "asin",    1,    _Funct_asin },           /* 3    */
   { "acos",    1,    _Funct_acos },           /* 4    */
   { "atan",    1,    _Funct_atan },           /* 5    */
   { "sinh",    1,    _Funct_sinh },           /* 6    */
   { "cosh",    1,    _Funct_cosh },           /* 7    */
   { "tanh",    1,    _Funct_tanh },           /* 8    */
   { "exp",     1,    _Funct_exp },            /* 9    */
   { "log",     1,    _Funct_log },            /* 10   */
   { "log10",   1,    _Funct_log10 },          /* 11   */
   { "sqrt",    1,    _Funct_sqrt },           /* 12   */
   { "floor",   1,    _Funct_floor },          /* 13   */
   { "ceil",    1,    _Funct_ceil },           /* 14   */
   { "abs",     1,    _Funct_fabs },           /* 15   */
   { "hypot",   2,    _Funct_hypot },          /* 16   */
   { "acosh",   1,    _Funct_acosh },          /* 17   */
   { "asinh",   1,    _Funct_asinh },          /* 18   */
   { "atanh",   1,    _Funct_atanh },          /* 19   */
   { "beta",    2,    _Funct_beta },           /* 20   */
   { "lbeta",   2,    _Funct_lbeta },          /* 21   */
   { "deg",     1,    _Funct_deg },            /* 22   */
   { "rad",     1,    _Funct_rad },            /* 23   */
   { "chdtrc",  2,    _Funct_chdtrc },         /* 24   */
   { "chdtr",   2,    _Funct_chdtr },          /* 25   */
   { "chdtri",  2,    _Funct_chdtri },         /* 26   */
   { "dawsn",   1,    _Funct_dawsn },          /* 27   */
   { "ellie",   2,    _Funct_ellie },          /* 28   */
   { "ellik",   2,    _Funct_ellik },          /* 29   */
   { "ellpe",   1,    _Funct_ellpe },          /* 30   */
   { "ellpk",   1,    _Funct_ellpk },          /* 31   */
   { "gamma",   1,    _Funct_gamma },          /* 32   */
   { "lgam",    1,    _Funct_lgam },           /* 33   */
   { "gdtr",    3,    _Funct_gdtr },           /* 34   */
   { "gdtrc",   3,    _Funct_gdtrc },          /* 35   */
   { "hyperg",  3,    _Funct_hyperg },         /* 36   */
   { "i0",      1,    _Funct_i0 },             /* 37   */
   { "i0e",     1,    _Funct_i0e },            /* 38   */
   { "igamc",   2,    _Funct_igamc },          /* 39   */
   { "igam",    2,    _Funct_igam },           /* 40   */
   { "igami",   2,    _Funct_igami },          /* 41   */
   { "incbet",  3,    _Funct_incbet },         /* 42   */
   { "incbi",   3,    _Funct_incbi },          /* 43   */
   { "iv",      2,    _Funct_iv },             /* 44   */
   { "j0",      1,    _Funct_j0 },             /* 45   */
   { "y0",      1,    _Funct_y0 },             /* 46   */
   { "j1",      1,    _Funct_j1 },             /* 47   */
   { "y1",      1,    _Funct_y1 },             /* 48   */
   { "jv",      2,    _Funct_jv },             /* 49   */
   { "k0",      1,    _Funct_k0 },             /* 50   */
   { "k0e",     1,    _Funct_k0e },            /* 51   */
   { "k1",      1,    _Funct_k1 },             /* 52   */
   { "k1e",     1,    _Funct_k1e },            /* 53   */
   { "ndtr",    1,    _Funct_ndtr },           /* 54   */
   { "ndtri",   1,    _Funct_ndtri },          /* 55   */
   { "erf",     1,    _Funct_erf },            /* 56   */
   { "erfc",    1,    _Funct_erfc },           /* 57   */
   { "psi",     1,    _Funct_psi },            /* 58   */
   { "rgamma",  1,    _Funct_rgamma },         /* 59   */
   { "spence",  1,    _Funct_spence },         /* 60   */
   { "struve",  2,    _Funct_struve },         /* 61   */
   { "zeta",    2,    _Funct_zeta },           /* 62   */
   { "zetac",   1,    _Funct_zetac },          /* 63   */
   { "bdtr",    3,    _Funct_bdtr },           /* 64   */
   { "bdtri",   3,    _Funct_bdtri },          /* 65   */
   { "bdtrc",   3,    _Funct_bdtrc },          /* 66   */
   { "fdtr",    3,    _Funct_fdtr },           /* 67   */
   { "fdtri",   3,    _Funct_fdtri },          /* 68   */
   { "fdtrc",   3,    _Funct_fdtrc },          /* 69   */
   { "jn",      2,    _Funct_jn },             /* 70   */
   { "kn",      2,    _Funct_kn },             /* 71   */
   { "nbdtr",   2,    _Funct_nbdtr },          /* 72   */
   { "nbdtri",  2,    _Funct_nbdtri },         /* 73   */
   { "nbdtrc",  2,    _Funct_nbdtrc },         /* 74   */
   { "pdtr",    2,    _Funct_pdtr },           /* 75   */
   { "pdtri",   2,    _Funct_pdtri },          /* 76   */
   { "pdtrc",   2,    _Funct_pdtrc },          /* 77   */
   { "yn",      2,    _Funct_yn },             /* 78   */
   { "stdtri",  2,    _Funct_stdtri },         /* 79   */
   { "stdtr",   2,    _Funct_stdtr },          /* 80   */

   { 0 }                                       /* 81   */
};


int    _NBFONC_FUNC=81;
