/*************************************************************************
** funct-3.1      (command interpreter - funct)                          **
** geom_draw.c : graphic functions                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
**************************************************************************/

#include "geom.h"
#include "graph.h"
int           I0;


/*--------------------------------------------------------------------
    Function called by Draw_All_Cmd to draw points
--------------------------------------------------------------------*/
int
Draw_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    iw,
                    iw1;
    float          *xx,
                   *Ix,
                    ax,
                    bx,
                    ay,
                    by;
    char          **e;
    Point          *p;
    flow_data      *flow_interp;
    funct_clip     *f_clip;

    flow_interp = (flow_data *) argv[-1];
    e = (char **) Obj[_GEOM_POINT - 1][I0].adresse;
    p = (Point *) e[0];
    f_clip = (funct_clip *) flow_interp->extra[2];
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw1 = xx[2];
#else
        iw1 = -1;
#endif
    }
    else {
        iw1 = sketch_obj_restr(argv[2], &i1, _GRAPH_PS, flow_interp);
        if (iw1 != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw1 - 1][i1].adresse;
    }
    iw = sketch_obj_restr(argv[3], &i0, _GRAPH_FRAM, flow_interp);
    if (iw != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 3);
        return 1;
    }
    Ix = (float *) Obj[iw - 1][i0].adresse;
    ax = (Ix[1] - Ix[0]) / (f_clip->xsup_clip - f_clip->xinf_clip) / xx[0];
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    ay = (Ix[3] - Ix[2]) / (f_clip->ysup_clip - f_clip->yinf_clip) / xx[1];
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;
    xx[3] = (p->x - bx) / ax;
    xx[4] = (p->y - by) / ay;
    if (xx[3] < f_clip->xsup_clip * xx[0] && xx[3] > f_clip->xinf_clip * xx[0]
        && xx[4] < f_clip->ysup_clip * xx[1] &&
        xx[4] > f_clip->yinf_clip * xx[1])
        _FUNCT_PLOT(iw1, xx[2], (double)xx[3], (double)xx[4], xx);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function called by Draw_All_Cmd to draw lines
--------------------------------------------------------------------*/
int
Draw_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    iw,
                    iw1;
    float          *xx,
                   *Ix,
                    x,
                    y,
                    ax,
                    bx,
                    ay,
                    by,
                    bx2,
                    by2,
                    u,
                    v,
                    xp,
                    yp,
                    xj,
                    yj,
                    x0,
                    y0,
                    x1,
                    y1,
                    X[2],
                    Y[2];
    char          **e;
    Line           *lin;
    flow_data      *flow_interp;
    funct_clip     *f_clip;

    flow_interp = (flow_data *) argv[-1];
    e = (char **) Obj[_GEOM_LINE - 1][I0].adresse;
    lin = (Line *) e[0];
    f_clip = (funct_clip *) flow_interp->extra[2];
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw1 = xx[2];
#else
        iw1 = -1;
#endif
    }
    else {
        iw1 = sketch_obj_restr(argv[2], &i1, _GRAPH_PS, flow_interp);
        if (iw1 != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw1 - 1][i1].adresse;
    }
    iw = sketch_obj_restr(argv[3], &i0, _GRAPH_FRAM, flow_interp);
    if (iw != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 3);
        return 1;
    }
    Ix = (float *) Obj[iw - 1][i0].adresse;
    u = (f_clip->xsup_clip - f_clip->xinf_clip) * xx[0];
    v = (f_clip->ysup_clip - f_clip->yinf_clip) * xx[1];
    ax = (Ix[1] - Ix[0]) / u;
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    ay = (Ix[3] - Ix[2]) / v;
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;
    bx2 = - f_clip->xinf_clip * xx[0] / u;
    by2 = - f_clip->yinf_clip * xx[1] / v;
    if (fabs(lin->U.x) > fabs(lin->U.y)) {
        x = Ix[0];
        y = lin->A.y + lin->U.y * (x - lin->A.x) / lin->U.x;
        xj = (x - bx) / ax;
        yj = (y - by) / ay;
        x1 = xj / u + bx2;
        y1 = yj / v + by2;
        x = Ix[1];
        y = lin->A.y + lin->U.y * (x - lin->A.x) / lin->U.x;
        xp = (x - bx) / ax;
        yp = (y - by) / ay;
        x0 = xp / u + bx2;
        y0 = yp / v + by2;
        if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
            _FUNCT_PLOT(iw1, xx[2], (double) ((X[0] - bx2) * u),
                (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
            _FUNCT_SET_LINE_WIDTH(iw1, xx[2], 1., xx);
#endif
            _FUNCT_LINE_TO(iw1, xx[2], (double)((X[1] - bx2) * u),
                (double)((Y[1] - by2) * v), xx);
        }
    }
    else {
        y = Ix[2];
        x = lin->A.x + lin->U.x * (y - lin->A.y) / lin->U.y;
        xj = (x - bx) / ax;
        yj = (y - by) / ay;
        x1 = xj / u + bx2;
        y1 = yj / v + by2;
        y = Ix[3];
        x = lin->A.x + lin->U.x * (y - lin->A.y) / lin->U.y;
        xp = (x - bx) / ax;
        yp = (y - by) / ay;
        x0 = xp / u + bx2;
        y0 = yp / v + by2;
        if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
            _FUNCT_PLOT(iw1, xx[2], (double) ((X[0] - bx2) * u),
                (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
            _FUNCT_SET_LINE_WIDTH(iw1, xx[2], 1., xx);
#endif
           _FUNCT_LINE_TO(iw1, xx[2], (double)((X[1] - bx2) * u),
                (double)((Y[1] - by2) * v), xx);
        }
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function called by Draw_All_Cmd to draw circles
--------------------------------------------------------------------*/
int
Draw_Circle_Cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    i1,
                    iw,
                    iw1;
    float          *xx,
                   *Ix,
                    ax,
                    bx,
                    ay,
                    by,
                    bx2,
                    by2,
                    u,
                    v,
                    x0,
                    y0,
                    x1,
                    y1,
                    X[2],
                    Y[2];
    char          **e;
    Circle         *circ;
    Point           P;
    flow_data      *flow_interp;
    funct_clip     *f_clip;

    flow_interp = (flow_data *) argv[-1];
    e = (char **) Obj[_GEOM_CIRC - 1][I0].adresse;
    circ = (Circle *) e[0];
    P = circ->O;
    f_clip = (funct_clip *) flow_interp->extra[2];
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw1 = xx[2];
#else
        iw1 = -1;
#endif
    }
    else {
        iw1 = sketch_obj_restr(argv[2], &i1, _GRAPH_PS, flow_interp);
        if (iw1 != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw1 - 1][i1].adresse;
    }
    iw = sketch_obj_restr(argv[3], &i0, _GRAPH_FRAM, flow_interp);
    if (iw != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 3);
        return 1;
    }
    Ix = (float *) Obj[iw - 1][i0].adresse;
    u = (f_clip->xsup_clip - f_clip->xinf_clip) * xx[0];
    v = (f_clip->ysup_clip - f_clip->yinf_clip) * xx[1];
    ax = (Ix[1] - Ix[0]) / u;
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    ay = (Ix[3] - Ix[2]) / v;
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;
    bx2 = - f_clip->xinf_clip * xx[0] / u;
    by2 = - f_clip->yinf_clip * xx[1] / v;

    x0 = (P.x + circ->R - bx) / ax;
    y0 = (P.y - by) / ay;
    x0 = x0 / u + bx2;
    y0 = y0 / v + by2;

    for (i = 1; i <= _nang_circ; i++) {
        x1 = (P.x + circ->R * cos_circ[i] - bx) / ax;
        y1 = (P.y + circ->R * sin_circ[i] - by) / ay;
        x1 = x1 / u + bx2;
        y1 = y1 / v + by2;
        if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
            _FUNCT_PLOT(iw1, xx[2], (double) ((X[0] - bx2) * u),
                (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
            _FUNCT_SET_LINE_WIDTH(iw1, xx[2], 1., xx);
#endif
            _FUNCT_LINE_TO(iw1, xx[2], (double)((X[1] - bx2) * u),
                (double)((Y[1] - by2) * v), xx);
        }
        x0 = x1;
        y0 = y1;
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function called by Draw_All_Cmd to draw polygons
--------------------------------------------------------------------*/
int
Draw_Polygon_Cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    i1,
                    imin,
                    imax,
                    iw,
                    iw1;
    float          *xx,
                   *Ix,
                    x,
                    y,
                    ax,
                    bx,
                    ay,
                    by,
                    bx2,
                    by2,
                    u,
                    v,
                    xp,
                    yp,
                    x0,
                    y0,
                    x1,
                    y1,
                    X[2],
                    Y[2];
    Polygon        *p;
    char          **e;
    funct_clip     *f_clip;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    e = (char **) Obj[_GEOM_POLYG - 1][I0].adresse;
    p = (Polygon *) e[0];
    if (p->nb < 2) {
        error_mess(flow_interp, _GEOM_MESS + 8);
        return 1;
    }
    f_clip = (funct_clip *) flow_interp->extra[2];
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw1 = xx[2];
#else
        iw1 = -1;
#endif
    }
    else {
        iw1 = sketch_obj_restr(argv[2], &i1, _GRAPH_PS, flow_interp);
        if (iw1 != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw1 - 1][i1].adresse;
    }
    iw = sketch_obj_restr(argv[3], &i0, _GRAPH_FRAM, flow_interp);
    if (iw != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 3);
        return 1;
    }
    imin = 1;
    imax = p->nb;
    if (argc >= 6) {
        imin = convert_int(argv[4], flow_interp);
        imax = convert_int(argv[5], flow_interp);
        if (imin < 1)
            imin = 1;
        if (imax > p->nb)
            imax = p->nb;
    }
    Ix = (float *) Obj[iw - 1][i0].adresse;
    u = (f_clip->xsup_clip - f_clip->xinf_clip) * xx[0];
    v = (f_clip->ysup_clip - f_clip->yinf_clip) * xx[1];
    ax = (Ix[1] - Ix[0]) / u;
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    ay = (Ix[3] - Ix[2]) / v;
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;
    bx2 = - f_clip->xinf_clip * xx[0] / u;
    by2 = - f_clip->yinf_clip * xx[1] / v;
    xx[3] = (p->vertex[imin - 1].x - bx) / ax;
    xx[4] = (p->vertex[imin - 1].y - by) / ay;

    for (i = imin; i < imax; i++) {
        x = p->vertex[i].x;
        y = p->vertex[i].y;
        xp = (x - bx) / ax;
        yp = (y - by) / ay;
        x0 = xp / u + bx2;
        y0 = yp / v + by2;
        x1 = xx[3] / u + bx2;
        y1 = xx[4] / v + by2;
        xx[3] = xp;
        xx[4] = yp;
        if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
            _FUNCT_PLOT(iw1, xx[2], (double) ((X[0] - bx2) * u),
                (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
            _FUNCT_SET_LINE_WIDTH(iw1, xx[2], 1., xx);
#endif
            _FUNCT_LINE_TO(iw1, xx[2], (double)((X[1] - bx2) * u),
                (double)((Y[1] - by2) * v), xx);
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'draw_to'
--------------------------------------------------------------------*/
int
Draw_LineTo_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw,
                    i00,
                    iw0;
    char          **e;
    Point          *p;
    float          *xx,
                   *Ix,
                    x,
                    y,
                    ax,
                    bx,
                    ay,
                    by,
                    bx2,
                    by2,
                    u,
                    v,
                    xp,
                    yp,
                    x0,
                    y0,
                    x1,
                    y1,
                    X[2],
                    Y[2];
    funct_clip     *f_clip;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    f_clip = (funct_clip *) flow_interp->extra[2];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw = xx[2];
#else
        iw = -1;
#endif
    }
    else {
        iw = sketch_obj_restr(argv[2], &i0, _GRAPH_PS, flow_interp);
        if (iw != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw - 1][i0].adresse;
    }
    iw0 = sketch_obj_restr(argv[3], &i00, _GRAPH_FRAM, flow_interp);
    if (iw0 != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 2);
        return 1;
    }
    Ix = (float *) Obj[iw0 - 1][i00].adresse;
    u = (f_clip->xsup_clip - f_clip->xinf_clip) * xx[0]; /* length of the
                                                            drawing area
                                                            (in pixels)   */
    v = (f_clip->ysup_clip - f_clip->yinf_clip) * xx[1]; /* height of the
                                                            drawing area
                                                            (in pixels)   */

    ax = (Ix[1] - Ix[0]) / u;    /* 1/(number of points for a length of 1) */
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;  /* the value of x
                             corresponding to the left limit of the window */
    ay = (Ix[3] - Ix[2]) / v;    /* 1/(number of points for a height of 1) */
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;  /* the value of y
                           corresponding to the bottom limit of the window */

    bx2 = - f_clip->xinf_clip * xx[0] / u;  /* -distance from the left
                      border of the window to the bottom of the graphic (if
                      the width of the drawing area is 1 */

    by2 = - f_clip->yinf_clip * xx[1] / v;  /* -distance from the bottom
                      border of the window to the bottom of the graphic (if
                      the height of the drawing area is 1 */

    x = p->x;
    y = p->y;
    xp = (x - bx) / ax;   /* 1st coordinate of the point in pixels */
    yp = (y - by) / ay;   /* 2nd coordinate of the point in pixels */
    x0 = xp / u + bx2;    /* 1st coordinate of the point in the 1x1 area */
    y0 = yp / v + by2;    /* 2nd coordinate of the point in the 1x1 area */
    x1 = xx[3] / u + bx2;
    y1 = xx[4] / v + by2;
    xx[3] = xp;
    xx[4] = yp;
    if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
        _FUNCT_PLOT(iw, xx[2], (double) ((X[0] - bx2) * u),
            (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
        _FUNCT_SET_LINE_WIDTH(iw, xx[2], 0.5, xx);
#endif
        _FUNCT_LINE_TO(iw, xx[2], (double)((X[1] - bx2) * u),
            (double)((Y[1] - by2) * v), xx);
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function called by Draw_All_Cmd to draw vectors
--------------------------------------------------------------------*/
int
Draw_Vect_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw,
                    i00,
                    iw0;
    char          **e;
    Vector         *vv;
    float          *xx,
                   *Ix,
                    len,
                    x,
                    y,
                    ax,
                    bx,
                    ay,
                    by,
                    bx2,
                    by2,
                    u,
                    v,
                    ux,
                    uy,
                    xp,
                    yp,
                    x0,
                    y0,
                    x1,
                    y1,
                    X[2],
                    Y[2];
    funct_clip     *f_clip;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    f_clip = (funct_clip *) flow_interp->extra[2];
    e = (char **) Obj[_GEOM_VECTOR - 1][I0].adresse;
    vv = (Vector *) e[0];
    len = Length_Vector(*vv);
    if (len < _geom_eps2) {
        error_mess(flow_interp, _GEOM_MESS +19);
        return 1;
    }
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw = xx[2];
#else
        iw = -1;
#endif
    }
    else {
        iw = sketch_obj_restr(argv[2], &i0, _GRAPH_PS, flow_interp);
        if (iw != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw - 1][i0].adresse;
    }
    iw0 = sketch_obj_restr(argv[3], &i00, _GRAPH_FRAM, flow_interp);
    if (iw0 != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 2);
        return 1;
    }
    Ix = (float *) Obj[iw0 - 1][i00].adresse;
    u = (f_clip->xsup_clip - f_clip->xinf_clip) * xx[0];
    v = (f_clip->ysup_clip - f_clip->yinf_clip) * xx[1];
    ax = (Ix[1] - Ix[0]) / u;
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    ay = (Ix[3] - Ix[2]) / v;
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;
    bx2 = - f_clip->xinf_clip * xx[0] / u;
    by2 = - f_clip->yinf_clip * xx[1] / v;
    xp = xx[3] + vv->x / ax;
    yp = xx[4] + vv->y / ay;
    x0 = xp / u + bx2;
    y0 = yp / v + by2;
    x1 = xx[3] / u + bx2;
    y1 = xx[4] / v + by2;
    if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
        _FUNCT_PLOT(iw, xx[2], (double) ((X[0] - bx2) * u),
            (double)((Y[0] - by2) * v), xx);
        _FUNCT_SET_LINE_WIDTH(iw, xx[2], 1., xx);
        _FUNCT_LINE_TO(iw, xx[2], (double)((X[1] - bx2) * u),
            (double)((Y[1] - by2) * v), xx);
    }
    ux = xp - xx[3];
    uy = yp - xx[4];
    len = sqrt(ux * ux + uy * uy) / 10.;
    ux /= len;
    uy /= len;
    x = xp - ux + 0.75 * uy;
    y = yp - uy - 0.75 * ux;
    x1 = x / u + bx2;
    y1 = y / v + by2;
    if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
        _FUNCT_PLOT(iw, xx[2], (double) ((X[0] - bx2) * u),
            (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
        _FUNCT_SET_LINE_WIDTH(iw, xx[2], 1., xx);
#endif
        _FUNCT_LINE_TO(iw, xx[2], (double)((X[1] - bx2) * u),
            (double)((Y[1] - by2) * v), xx);
    }
    x = xp - ux - 0.75 * uy;
    y = yp - uy + 0.75 * ux;
    x1 = x / u + bx2;
    y1 = y / v + by2;
    if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
        _FUNCT_PLOT(iw, xx[2], (double) ((X[0] - bx2) * u),
            (double)((Y[0] - by2) * v), xx);
#ifndef __PLOTLIB_X11
        _FUNCT_SET_LINE_WIDTH(iw, xx[2], 1., xx);
#endif
        _FUNCT_LINE_TO(iw, xx[2], (double)((X[1] - bx2) * u),
            (double)((Y[1] - by2) * v), xx);
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'draw'
--------------------------------------------------------------------*/
int
Draw_All_Cmd(int argc, char *argv[])
{
    int             Iw;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    Iw = sketch_obj_restr(argv[1], &I0, _GEOM_POINT, flow_interp);
    if (Iw != _GEOM_POINT) {
        Iw = sketch_obj_restr(argv[1], &I0, _GEOM_LINE, flow_interp);
        if (Iw != _GEOM_LINE) {
            Iw = sketch_obj_restr(argv[1], &I0, _GEOM_VECTOR, flow_interp);
            if (Iw != _GEOM_VECTOR) {
                Iw = sketch_obj_restr(argv[1], &I0, _GEOM_CIRC, flow_interp);
                if (Iw != _GEOM_CIRC) {
                    Iw = sketch_obj_restr(argv[1], &I0, _GEOM_POLYG,
                        flow_interp);
                    if (Iw != _GEOM_POLYG) {
                        error_mess(flow_interp, _GEOM_MESS + 26);
                        return 1;
                    }
                }
            }
        }
    }
    if (Iw == _GEOM_VECTOR)
        return Draw_Vect_Cmd(argc, argv);
    if (Iw == _GEOM_POINT)
        return Draw_Point_Cmd(argc, argv);
    if (Iw == _GEOM_CIRC)
        return Draw_Circle_Cmd(argc, argv);
    if (Iw == _GEOM_LINE)
        return Draw_Line_Cmd(argc, argv);
    return Draw_Polygon_Cmd(argc, argv);
}
/*------------------------------------------------------------------*/



































