############################################################################
#** funct-3.1                                                             **
#** General makefile for funct 		                                  **
#**                                                                       **
#** Copyright (C) 2003  Jean-Marc Drezet                                  **
#**                                                                       **
#**  This library is free software; you can redistribute it and/or        **
#**  modify it under the terms of the GNU Library General Public          **
#**  License as published by the Free Software Foundation; either         **
#**  version 2 of the License, or (at your option) any later version.     **
#**									  **
#**  This library is distributed in the hope that it will be useful,      **
#**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
#**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
#**  Library General Public License for more details. 			  **
#**									  **
#**  You should have received a copy of the GNU Library General Public    **
#**  License along with this library; if not, write to the Free		  **
#**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
#**                                                                       **
#** Please mail any bug reports/fixes/enhancements to me at:              **
#**      drezet@math.jussieu.fr                                           **
#** or                                                                    **
#**      Jean-Marc Drezet                                                 **
#**      Institut de Mathematiques                                        **
#**      UMR 7586 du CNRS                                                 **
#**      173, rue du Chevaleret                                           **
#**      75013 Paris                                                      **
#**      France			 					  **
#**                                                                       **
############################################################################


#-----------------------------------------------------------------------------
#to use GGI for X11
export CFLAGS= $(OPTIM) -Wall -D__PLOTLIB_X11 -D__PLOTG2LIB_X11
LIBS= -lplot -lXaw -lXmu -lXt -lSM -lICE -lXext -lX11 -lpng -lz -lm
#-----------------------------------------------------------------------------

all : funct_plot

clean: 
	rm -f *bck *% *~ funct_ini*
	cd functions; $(MAKE) clean
	cd graphics; $(MAKE) -f makefile.allegro clean
	cd mix; $(MAKE) -f makefile.allegro clean
	cd geom; $(MAKE) -f makefile.allegro clean

funct_plot : funct_ini_.o functions/bessel_.o functions/names_.o \
mix/funct_graphcmd_p.o functions/fourier_.o graphics/graph_p.o mix/main_p.o \
functions/funct_.o graphics/graphcmd_p.o mix/names_p.o functions/functcmd_.o \
graphics/names_p.o geom/geom_p.o geom/geom_cmd_p.o geom/names_p.o \
geom/geom_draw_p.o
	$(CC) $(LDFLAGS) *.o */*_.o */*_p.o $(INTERPCOM) $(LIBS) -L/usr/X11R6/lib $(LINE_ED_LIB) $(GSL) -lm -lpthread $(CEPHES) -lpng -lz -o funct_plot
	mv funct_plot ../bin

funct_ini_.o : funct_ini.c
	$(CC) -c $(CFLAGS) -D_REENTRANT funct_ini.c -o funct_ini_.o

funct_ini.c : funct.ini
	$(CONVERT) funct.ini funct_ini.c int_txt int_nb

functions/bessel_.o :functions/bessel.c
	cd functions; make

functions/names_.o : functions/names.c
	cd functions; make

mix/funct_graphcmd_p.o : mix/funct_graphcmd.c
	cd mix; make -f makefile.plot

functions/fourier_.o : functions/fourier.c
	cd functions; make

graphics/graph_p.o : graphics/graph.c
	cd graphics; make -f makefile.plot

mix/main_p.o : mix/main.c
	cd mix; make -f makefile.plot

functions/funct_.o : functions/funct.c
	cd functions; make

graphics/graphcmd_p.o : graphics/graphcmd.c
	cd graphics; make -f makefile.plot

mix/names_p.o : mix/names.c
	cd mix; make -f makefile.plot

functions/functcmd_.o : functions/functcmd.c
	cd functions; make

graphics/names_p.o : graphics/names.c
	cd graphics; make -f makefile.plot

geom/geom_p.o : geom/geom.c
	cd geom; make -f makefile.plot

geom/geom_cmd_p.o : geom/geom_cmd.c
	cd geom; make -f makefile.plot
	
geom/names_p.o : geom/names.c
	cd geom; make -f makefile.plot
	
geom/vector_p.o : geom/vector.c
	cd geom; make -f makefile.plot
	
geom/geom_draw_p.o : geom/geom_draw.c
	cd geom; make -f makefile.plot
