#define DF_GLOBAL
#include "alldf.h"
#include "datafile.h"

//datafile2D returns the value of the function at x described by
//the data file.  The function is constructed as follows:
//
//          {  0     x<xdatamin
// f(x) =   {  g(X)  xdatamin<x<xdatamax
//          {  0     x>datamax
// g(x) = value resulting from linear interpolation between
//        data points
//
// TODO:
//   Better interpolation scheme(s) (as options)

#include <stdio.h>

extern KAllDF *g_kadf;

double datafile2D (double x, double dataset)
{
  int i = (int)dataset;
  unsigned long  j0=g_kadf->extra (i), j;
  double oxx,xx;

  if (g_kadf->load (i)==FALSE)
    return 0;

  oxx = g_kadf->getx (i,j0);

  for (j=j0+1;j<g_kadf->maxn (i);j++)
    {
      xx = g_kadf->getx (i,j);
      if (x>=oxx && x<xx)
	{
	  g_kadf->setExtra (i,j-1);
	  return g_kadf->gety (i,j-1)+(x-oxx)*
	    (g_kadf->gety (i,j)-g_kadf->gety (i,j-1))/(xx-oxx);
	}
      oxx=xx;
    }

  for (j=0;j<j0;j++)
    {
      xx = g_kadf->getx (i,j);
      if (x>=oxx && x<xx)
	{
	  g_kadf->setExtra (i,j-1);
	  return g_kadf->gety (i,j-1)+(x-oxx)*
	    (g_kadf->gety (i,j)-g_kadf->gety (i,j-1))/(xx-oxx);

	}
      oxx=xx;

    }
  g_kadf->setExtra (i,j);
  return 0;

} 
  
