#include "expression.h"

RCSTAG( "$Id: expression.cpp,v 3.9 1998/02/05 16:52:27 kde Exp $" );

#include <qpainter.h>
#include <qpdevmet.h>
#include <qregexp.h>
#include <kapp.h>
#include <kmsgbox.h>

#include <ctype.h>

#include "alldf.h"

#include "differentiate.cpp"
#include "simplify.cpp"

//#define __DEBUG

QDict<double>*   dictConstants;
//QDict<funcCall>* dictFunctions;
QStrList *lstfunctions;
KPDict *dictFunctions;

extern KAllDF *g_kadf;

int
parse( QString expression, QStrList* slist, KNode*& exp )
{

#ifdef __DEBUG
  debug( "expression now: %s", static_cast<const char*>( expression ) );
#endif

  if ( !expression.length() ) return err_expressionEmpty;

  exp = static_cast<KNode*>( NULL );
  KNode* expLeft, * expRight;
  QString sLeft, sRight;
  int nError;

  // remove spaces
  //  expression = expression.stripWhiteSpace();
  // remove _all_ spaces, except those in between quotes
  // so "sin (x)" is the same as "sin(x)", but filenames are ok
  //
  // change <<datafile2D (x,"filename",opts)>> to
  // datafile2D (x,n)
  // where n is the index to a class describing the file "filename" with
  // the options opts
  QString tmpexpr, filename, dfnum, opts;
  short inquote=0, passedcomma;
  unsigned int i;
  int dsindex;

  for (i=0;i<expression.length();i++)
    {
      if (expression.at(i)=='\"')
	{
	  inquote=1-inquote;

	  if (!inquote)
	    {
	      //add filename and opts to global list here
	      //The "" will be changed to opts later	      
	      opts.resize(1);
	      passedcomma=0;
	      for (;i<expression.length() && 
		     expression.at(i)!=')';i++)
		if (passedcomma)
		  opts+=expression.at(i);
	      else
		if (expression.at(i)==',')
		  passedcomma=1;

	      tmpexpr+=dfnum.setNum (dsindex=
				     g_kadf->addDataSet (filename.data(),
							 opts.data()));
	      if (dsindex<0)
		return dsindex;

	      if (expression.at(i)==')')
		i--;
	      filename.resize (1);
	    }
	}
      else
	{
	  if (inquote)
	    filename+=expression.at(i);
	  else if (!isspace(expression.at(i)))
	    tmpexpr+=expression.at(i);
	}

    }

  expression=static_cast<const char*>( tmpexpr );

  //printf ("2: [%s]\n",expression.data());

  //
  // We should have a dfmanager class which will keep track of the indicies
  // and the info to which they point and also keep us from rereading a
  // datafile.
  // So we'll need to go through a setup procedure, then do a
  // dfmanager::init()  to read in the necessary data, then datafile2D
  // will use that data to interpolate.

  // Do the setup here.



  // convert 3x into 3*x
  int n1 = 0;
  while ( ( n1 = expression.find( QRegExp( "[0-9][a-zA-Z_]" ) ) ) != -1 ) {
    expression.insert( n1 + 1, '*' );
#ifdef __DEBUG
    debug( "inserted '*': %s", static_cast<const char*>( expression ) );
#endif
  } // while

  // check brackets
  int* bracketLevel = static_cast<int*>( NULL );
  bool firstLevelFound = FALSE;

  while ( !firstLevelFound ) {
    bracketLevel = new int[ expression.length() ];
    CHECK_PTR( bracketLevel );

    int currentLevel = 0;

    uint x;
    for ( x = 0; x < expression.length(); x++ ) {
      if ( expression[ x ] == '(' ) bracketLevel[ x ] = ++currentLevel;
      else if ( expression[ x ] == ')' ) bracketLevel[ x ] = currentLevel--;
      else bracketLevel[ x ] = currentLevel;

      if ( currentLevel < 0 ) {
	delete[] bracketLevel;
	return err_TooManyClosingBrackets;
      } // if

      if ( bracketLevel[ x ] == 0 ) firstLevelFound = TRUE;
    } // for

    if ( currentLevel != 0 ) {
      delete[] bracketLevel;
      return err_ClosingBracketMissing;
    } // if

    if ( !firstLevelFound ) {
      // we have something that looks like this: (3+4+(5*7)), so we remove
      // the outer brackets
      expression.remove( 0, 1 );
      expression.truncate( expression.length() - 1 );

#ifdef __DEBUG
      debug( "removed brackets: %s", static_cast<const char*>( expression ) );
#endif

      delete[] bracketLevel;
    } // if
  } // while

  // search for the expression to be evaluated *last*
  int lastExpression;
  int x = expression.length();

  // search for "[+-]" in the string, excluding parts in brackets
  while ( ( ( lastExpression = expression.findRev( QRegExp( "[+-]" ), x ) )
	    != -1 ) && ( bracketLevel[ lastExpression ] > 0 ) ) {
     x = lastExpression - 1;
#ifdef __DEBUG
    debug( "ignored: %c at %i (bracket level %i)",
	   expression[ lastExpression ], lastExpression,
	   bracketLevel[ lastExpression ] );
#endif
  } // while

  if ( lastExpression == 0 ) {
#ifdef __DEBUG
    debug( "sign at position 0: %c", expression[ 0 ] );
#endif

    // there are only higher level expression to the right, so this is a
    // sign

    // ignore +, create 0-... for - sign
    if ( expression[ lastExpression ] == '-' ) {
      exp = new KNodeMinus();
      CHECK_PTR( exp );
      expLeft = new KNodeValue( 0.0 );
      CHECK_PTR( expLeft );
      exp->left = expLeft;
      sRight = expression.right( expression.length() - 1 );

      nError = parse( sRight, slist, expRight );
      if ( nError != err_Ok ) {
	delete[] bracketLevel;
	delete exp;
	exp = static_cast<KNode*>( NULL );
	return nError;
      } // if
      exp->right = expRight;

      delete[] bracketLevel;
      return err_Ok;
    } // if
    else {
      sRight = expression.right( expression.length() -1 );
      
      nError = parse( sRight, slist, exp );
      if ( nError != err_Ok ) {
	delete[] bracketLevel;
	delete exp;
	exp = static_cast<KNode*>( NULL );
	return nError;
      } // if

      delete[] bracketLevel;
      return err_Ok;
    } // else
  } // if
  
  if ( lastExpression != -1 ) {
#ifdef __DEBUG
    debug( "lastExpression = %i: %c", lastExpression,
	   expression[ lastExpression ] );
#endif

    if ( expression[ lastExpression ] == '+' ) exp = new KNodePlus();
    else exp = new KNodeMinus();
    CHECK_PTR( exp );
  
    sLeft = expression.left( lastExpression );
    nError = parse( sLeft, slist, expLeft );
    if ( nError != err_Ok ) {
      delete[] bracketLevel;
      delete exp;
      exp = static_cast<KNode*>( NULL );
      return nError;
    } // if
    exp->left = expLeft;
    
    sRight = expression.right( expression.length() - lastExpression - 1 );
    nError = parse( sRight, slist, expRight );
    if ( nError != err_Ok ) {
      delete[] bracketLevel;
      delete exp;
      exp = static_cast<KNode*>( NULL );
      return nError;
    } // if
    exp->right = expRight;

    delete[] bracketLevel;
    return err_Ok;
  } // if

  // no + or - found
  x = expression.length();
  while ( ( ( lastExpression = expression.findRev( QRegExp( "[*/]" ), x ) )
	    != -1 ) && ( bracketLevel[ lastExpression ] > 0 ) ) {
    x = lastExpression - 1;
#ifdef __DEBUG
    debug( "ignored: %c at %i (bracket level %i)",
	   expression[ lastExpression ], lastExpression,
	   bracketLevel[ lastExpression ] );
#endif
  } // while
  
  if ( lastExpression != -1 ) {
#ifdef __DEBUG
    debug( "lastExpression = %i: %c", lastExpression,
	   expression[ lastExpression ] );
#endif
    
    if ( expression[ lastExpression ] == '*' ) exp = new KNodeMult();
    else exp = new KNodeDiv();
    CHECK_PTR( exp );
    
    sLeft = expression.left( lastExpression );
    nError = parse( sLeft, slist, expLeft );
    if ( nError != err_Ok ) {
      delete[] bracketLevel;
      delete exp;
      exp = static_cast<KNode*>( NULL );
      return nError;
    } // if
    exp->left = expLeft;
    sRight = expression.right( expression.length() - lastExpression - 1 );
    nError = parse( sRight, slist, expRight );
    if ( nError != err_Ok ) {
      delete[] bracketLevel;
      delete exp;
      exp = static_cast<KNode*>( NULL );
      return nError;
    } // if
    exp->right = expRight;

    delete[] bracketLevel;
    return err_Ok;
  } // if

  
  // no +,-,*,/ found
  x = 0;
  while ( ( ( lastExpression = expression.find( '^', x ) )
	    != -1 ) && ( bracketLevel[ lastExpression ] > 0 ) ) {
    x = lastExpression + 1;
#ifdef __DEBUG
    debug( "ignored: %c at %i (bracket level %i)",
	   expression[ lastExpression ], lastExpression,
	   bracketLevel[ lastExpression ] );
#endif
  } // while
  
  if ( lastExpression != -1 ) {
#ifdef __DEBUG
    debug( "lastExpression = %i: %c", lastExpression,
	   expression[ lastExpression ] );
#endif
    
    exp = new KNodePow();
    CHECK_PTR( exp );
    sLeft = expression.left( lastExpression );
    nError = parse( sLeft, slist, expLeft );
    if ( nError != err_Ok ) {
      delete[] bracketLevel;
      delete exp;
      exp = static_cast<KNode*>( NULL );
      return nError;
    } // if
    exp->left = expLeft;
    sRight = expression.right( expression.length() - lastExpression - 1 );
    nError = parse( sRight, slist, expRight );
    if ( nError != err_Ok ) {
      delete[] bracketLevel;
      delete exp;
      exp = static_cast<KNode*>( NULL );
      return nError;
    } // if
    exp->right = expRight;

    delete[] bracketLevel;
    return err_Ok;
  } // if

  // var?
  if ( slist->find( expression ) != -1 ) {
    exp = new KNodeVar( expression );
    CHECK_PTR( exp );
    delete[] bracketLevel;
    return err_Ok;
  } // if

  // check for brackets
  int bracket;
  if ( ( bracket = expression.find( "(" ) ) == -1 ) {
#ifdef __DEBUG
    debug( "looking up constant %s", static_cast<const char*>( expression ) );
#endif
    double* constant = (*dictConstants)[ expression ];
    if ( constant ) {
#ifdef __DEBUG
      debug( "  - found! = %f", *constant );
#endif
      exp = new KNodeValue( *constant );
      CHECK_PTR( exp );
      delete[] bracketLevel;
      return err_Ok;
    } // if
    // else go down to see if it's a numeric value
  } // if no bracket found
  else { // bracket found
    // function calls need brackets. May be changed in later versions!
    KNodeFuncCall* fc;

    funcCall* f = (*dictFunctions)[ expression.left( bracket ) ];
    if ( f ) {
#ifdef __DEBUG
      debug( "function %s",
	     static_cast<const char*>( expression.left( bracket ) ) );
#endif

      uint nTemp;
      int nCommas = 0;
      for ( nTemp = 0; nTemp < expression.length(); nTemp++ ) {
	// check for commas in bracket level 1 (function calls need brackets
	// around the parameters)
	if ( ( expression[ nTemp ] == ',' ) && ( bracketLevel[ nTemp ] == 1 ) )
	  nCommas++;
      } // for
      if ( nCommas == f->numParameters - 1 ) {
#ifdef __DEBUG
	debug( "%i parameters", f->numParameters );
#endif
	fc = new KNodeFuncCall;
	CHECK_PTR( fc );

	int startOfParameter = bracket + 1;
	int endOfParameter;
	int y;
	for( y = 0; y < f->numParameters - 1; y++ ) {
	  endOfParameter = expression.find( ',', startOfParameter );
	  sLeft = expression.mid( startOfParameter,
				  endOfParameter - startOfParameter );
#ifdef __DEBUG
	  debug( "Parameter: %s", static_cast<const char*>( sLeft ) );
#endif

	  nError = parse( sLeft, slist, expLeft );
	  if ( nError != err_Ok ) {
	    delete[] bracketLevel;
	    delete exp;
	    exp = static_cast<KNode*>( NULL );
	    return nError;
	  } // if
	  fc->param[ y ] = expLeft;
	  startOfParameter = endOfParameter + 1;
	} // for

	endOfParameter = expression.findRev( ')' );
	sLeft = expression.mid( startOfParameter,
				endOfParameter - startOfParameter );
#ifdef __DEBUG
	debug( "Parameter: %s", static_cast<const char*>( sLeft ) );
#endif

	nError = parse( sLeft, slist, expLeft );
	if ( nError != err_Ok ) {
	  delete[] bracketLevel;
	  delete exp;
	  exp = static_cast<KNode*>( NULL );
	  return nError;
	} // if
	fc->param[ f->numParameters - 1 ] = expLeft;
	fc->function = f;
	
	exp = fc;

	delete[] bracketLevel;
	return err_Ok;
      } // if ( contains... )
      else {
	delete[] bracketLevel;
	return err_wrongNumberOfParameters;
      } // else
    } // if( f )
    else {
      delete[] bracketLevel;
      return err_funcCallUnknown;
    } // else
  } // else ( bracket => function call )

  // no constant, no function call => numeric value?
  bool f;
  double d = expression.toDouble( &f );
  delete[] bracketLevel;
  if ( f ) {
    exp = new KNodeValue( d );
    CHECK_PTR( exp );
    return err_Ok;
  } // if
  return err_notANumber;
} // parse



KNode::KNode()
{
  left = right = static_cast<KNode*>( NULL );
}


double
KNode::getValue( QDict<double>* )
{
  warning(
  "internal error: KNode::getValue called, please contact Ritzert@T-Online.de"
  );
  return -1;
} // KNode::getValue


KNode*
KNode::copy()
{
  warning( "internal error: KNode::copy called, please contact "
	   "Ritzert@T-Online.de" );
  return static_cast<KNode*>( NULL );
} // KNode::copy

QString
KNode::print( int lastLevel ) const
{
  QString s =lastLevel >= level() ? "(" : "";
  s += left->print( level() );
  s += type();
  s += right->print( level() );
  if( lastLevel >= level() ) s += ")";
  return s;
} // KNode::print


KNode::~KNode()
{
  if ( left ) delete left;
  if ( right ) delete right;
} // KNode destructor


KNode*
KNodePlus::copy()
{
  KNodePlus* ret = new KNodePlus;
  CHECK_PTR( ret );
  ret->left = left->copy();
  ret->right = right->copy();
  return ret;
} // KNodePlus::copy


KNode*
KNodeMinus::copy()
{
  KNodeMinus* ret = new KNodeMinus;
  CHECK_PTR( ret );
  ret->left = left->copy();
  ret->right = right->copy();
  return ret;
} // KNodeMinus::copy


KNode*
KNodeMult::copy()
{
  KNodeMult* ret = new KNodeMult;
  CHECK_PTR( ret );
  ret->left = left->copy();
  ret->right = right->copy();
  return ret;
} // KNodeMult::copy


KNode*
KNodeDiv::copy()
{
  KNodeDiv* ret = new KNodeDiv;
  CHECK_PTR( ret );
  ret->left = left->copy();
  ret->right = right->copy();
  return ret;
} // KNodeDiv::copy


KNode*
KNodePow::copy()
{
  KNodePow* ret = new KNodePow;
  CHECK_PTR( ret );
  ret->left = left->copy();
  ret->right = right->copy();
  return ret;
} // KNodePow::copy


KNode*
KNodeValue::copy()
{
  KNodeValue* ret = new KNodeValue( value );
  CHECK_PTR( ret );
  return ret;
} // KNodeValue::copy


QString
KNodeValue::print( int ) const
{
  QString s;
  s.setNum( value );
  if ( value < 0 ) { s.prepend( "(" ); s.append( ")" ); }
  return s;
} // KNodeValue::print


KNodeVar::KNodeVar( QString _sVarName ) : KNode()
{
  sVarName = _sVarName;
} // KNodeVar constructor

KNode*
KNodeVar::copy()
{
  KNodeVar* ret = new KNodeVar( sVarName );
  CHECK_PTR( ret );
  return ret;
} // KNodeVar::copy


double
KNodeFuncCall::getValue( QDict<double>* x )
{
  return function->getValue( x, param );
} // KNodeFuncCall::getValue


KNode*
KNodeFuncCall::copy()
{
  KNodeFuncCall* ret = new KNodeFuncCall;
  CHECK_PTR( ret );
  ret->function = function;
  int n;
  for( n = 0; n < 3; n++ ) ret->param[ n ] = param[ n ] ? param[ n ]->copy()
			     : static_cast<KNode*>( NULL );
  return ret;
} // KNodeFuncCall::copy


QString
KNodeFuncCall::print( int ) const
{
  QDictIterator<funcCall> iterator( *dictFunctions );

  while( function != iterator.current() ) ++iterator;
  QString s = iterator.currentKey();
  s += "(";

  int n;
  for( n = 0; n < function->numParameters; n++ ) {
    s += param[ n ]->print( 0 );
    if( n < function->numParameters - 1 ) s += ", ";
  } // for
  s += ")";
  return s;
} // KNodeFuncCall::print


KExpression::KExpression()
{
  expression = static_cast<KNode*>( NULL );
} // KExpression constructor ()

KExpression::KExpression( QString exp )
{
  QStrList slist;
  slist.append( "x" );
  expression = static_cast<KNode*>( NULL );
  parse( exp, &slist );
} // KExpression constructor ( QString )

KExpression::KExpression( QString exp, QStrList* vars )
{
  expression = static_cast<KNode*>( NULL );
  parse( exp, vars );
} // KExpression constructor ( QString, QStrList * )


KExpression::~KExpression()
{
  if ( expression ) delete expression;
} // KExpression destructor


int
KExpression::parse( QString exp, QStrList* slist, QWidget* messageParent )
{
  if ( expression ) delete expression;
  int nError = ::parse( exp, slist, expression );
  
  if ( nError == err_Ok ) return nError;

  if ( messageParent ) {
    QString s = getErrorText( nError );
    KMsgBox::message( messageParent, klocale->translate( "error" ), s,
		      KMsgBox::EXCLAMATION );
  } // if
  return nError;
} // KExpression::parse


QString
KExpression::getErrorText( int nError )
{
  QString s = "";
  switch( nError ) {
  case err_Ok: {
    s = klocale->translate( "ok, no error" ); break;
  }
  case err_TooManyClosingBrackets: {
    s = klocale->translate( "There are too many closing brackets in this "
		            "expression" ); break;
  }
  case err_ClosingBracketMissing: {
    s = klocale->translate( "There is a closing bracket missing in this "
	                    "expression" ); break;
  }
  case err_funcCallUnknown: {
    s = klocale->translate( "You're referring to an undefined function" );
    break;
  }
  case err_wrongNumberOfParameters: {
    s = klocale->translate( "You're giving a wrong number of parameters in"
			      " a function call" ); break;
  }
  case err_constantUnknown: {
    s = klocale->translate( "You're reffering to an undefined constant" );
    break;
  }
  case err_notANumber: {
    s = klocale->translate( "Not a number!" ); break;
  }
  case err_expressionEmpty: {
    s = klocale->translate( "A partial expression is an empty string" );
    break;
  }
  case err_badDataFile: {
    s = klocale->translate( "Couldn't load data file." );
    break;
  }
  case err_noMem: {
    s = klocale->translate( "Too many data files already loaded." );
    break;
  }
  } // switch
  return s;
} // KExpression::getErrorText


void
KExpression::plot( QPaintDevice* pd, QPainter* p, QPen pen,
		   double minX, double minY, double maxX, double maxY )
{
#ifdef __DEBUG
  debug( "KExpression::plot called!" );
#endif

  if ( !expression ) return;

  QPaintDeviceMetrics pdm( pd );
  p->setPen( pen );

  double deltaX = ( maxX - minX ) / pdm.width();
  double deltaY = ( maxY - minY ) / pdm.height();

#ifdef __DEBUG
  debug( "deltaX = %f, deltaY = %f", deltaX, deltaY );
#endif

  QDict<double> dict;
  double x = minX;
  dict.insert( "x", &x );
  double y = getValue( &dict );
  int y_screen = pdm.height() - static_cast<int>( ( y - minY ) / deltaY ) - 1;

  p->moveTo( 0, y_screen );

  int x_screen;
  int w = pdm.width();
  int h = pdm.height();

  bool outOfScreen = FALSE;
  bool NaN = FALSE;

#ifdef __DEBUG
  debug( "start painting" );
#endif

  for ( x_screen = 1; x_screen < w; x_screen++ ) {
    x += deltaX;
    y = getValue( &dict );
    y_screen = h - static_cast<int>( ( y - minY ) / deltaY ) - 1;

    if ( isnan( y ) ) {
      NaN = TRUE;
      outOfScreen = FALSE;
    } // if
    else if  ( ( y_screen > h ) || ( y_screen < 0 ) ) {
      if ( !outOfScreen ) p->lineTo( x_screen, y_screen );
      else p->moveTo( x_screen, y_screen );
      outOfScreen = TRUE;
      NaN = FALSE;
    } // else if
    else {
      if( NaN ) p->moveTo( x_screen, y_screen );
      else p->lineTo( x_screen, y_screen );
      outOfScreen = NaN = FALSE;
    } // else
  } // for

#ifdef __DEBUG
  debug( "end painting" );
#endif
} // KExpression::plot


double
funcCall::getValue( QDict<double>* x, KNode** param )
{
  switch( numParameters ) {
  case 2: {
    return (*twoParams)( param[0]->getValue( x ), param[1]->getValue( x ) );
  }
  case 3: {
    return (*threeParams)( param[0]->getValue( x ), param[1]->getValue( x ),
			   param[2]->getValue( x ) );
  }
  default: return (*oneParam)( param[0]->getValue( x ) );
  } // switch
  return -1;
} // funcCall::getValue


double
userFuncCall::getValue( QDict<double>* x, KNode** param )
{
  uint n;
  QDict<double> dict;
  for ( n = 0; n < numParameters; n++ ) {
    double* d = new double( param[ n ]->getValue( x ) );
    dict.insert( vars.at( n ), d );
  } // for
  return userFunction->getValue( &dict );
} // userFuncCall::getValue
