#ifndef __FUNCCALL_H__
#define __FUNCCALL_H__

#include <kfndialog.h>
#include <qdict.h>

class KNode;
class KNodeFuncCall;

class funcCall {
public:
  funcCall() { numParameters = 0; oneParam = NULL; fnDialog=0; 
               description=""; }
  virtual ~funcCall() {};
  virtual double getValue( QDict<double>* x, KNode** param );
  virtual KNode* differentiate( QString var, const KNodeFuncCall* t ) const;

  /**
    Set this equal to a pointer to a dialog which fills in options for
     a high-level function.  Set fnDialog equal to zero for simple
     functions. **/
  KFnDialog  *fnDialog;

  /**
    Put a text description of the function here.
    */
  QString description;
  uchar numParameters;
  union {
    double (*oneParam)( double );
    double (*twoParams)( double, double );
    double (*threeParams)( double, double, double );
  };

  KNode* (*differentiateFunc)( const KNodeFuncCall*, QString );
}; // class funcCall

#endif
