#ifndef __KFNDIALOG_H__
#define __KFNDIALOG_H__

#include <qdialog.h>
#include <qlabel.h>

/**
 * Inherit this class to create a dialog which will be called when
 *  a given function is inserted into the "f(x)=" edit box.
 **/

class KFnDialog : public QDialog
{
public:
  KFnDialog (QWidget *_parent, char *_name) :
    QDialog (_parent, _name, TRUE) {}

  /**
   * Return the text to be inserted in the "f(x)=" edit box.
   * The string "@@" marks the position to place a highlighted 'x'.
   * For example if getfnText() returns  "sin(@@)" then "sin(x)" will
   *  appear in the edit box with the 'x' highlighted.
   **/
  virtual char *getfnText (void) const {return 0;}
};

#endif
