#ifndef _KFUNCTION_H
#define _KFUNCTION_H

#include <qcolor.h>
#include <qdialog.h>
#include <qlist.h>
#include <qpen.h>
#include <qradiobt.h>
#include <klined.h>

#include "expression.h"

typedef struct
{
  QString     text;
  QPen        pen;
  KExpression expression;
} KFunction;

extern QList<KFunction>* functions;

extern double minX, minY, maxX, maxY;


struct KTextLabel {
  enum crossPos{ off, leftTop, leftBottom, rightTop, rightBottom };

  double   x, y;
  QString  text;
  QColor   color;
  crossPos showCross;
}; // KTextLabel

extern QList<KTextLabel> Labels;


const int grid_Off  = 0;
const int grid_Axes = 1;
const int grid_Grid = 2;
const int grid_Dots = 3;


extern int showGrid;
extern double gridX, gridY;
extern QColor gridColor;
extern PenStyle gridPenStyle;

extern bool askOnDelete;


class KGetLabelTextDlg;

class KGetLabelTextDlg : public QDialog {
  Q_OBJECT

public:
  KGetLabelTextDlg( QWidget* parent, KTextLabel* _tlabel );

protected slots:
  void color();
  void Ok();
  void Cancel();

private:
  KLined* leX, * leY;
  KTextLabel* tlabel;
  QColor   newColor;
  KLined*  editline;
  QRadioButton* rb[4];
}; // class KGetLabelTextDlg

#endif
