#ifndef _KPLOTWIN_H
#define _KPLOTWIN_H

#include <qbttngrp.h>
#include <qdialog.h>
#include <qradiobt.h>
#include <qstack.h>
#include <qwidget.h>
#include <kapp.h>
#include <klined.h>

#include "expression.h"
#include "kfunction.h"


void paintExpressions( QPaintDevice* pd, QPainter* p );

void paintGrid( QPaintDevice* pd, QPainter* p, int h, double deltaX,
		double deltaY );
void paintLabels( QPaintDevice* pd, QPainter* p, int h, double deltaX,
		  double deltaY );


struct KViewport {
  double minX, minY, maxX, maxY;
}; // KViewport


class KPlotWindow;

class KPlotWindow : public QWidget
{
  Q_OBJECT

public:
  KPlotWindow( QWidget* parent );
 ~KPlotWindow();

public slots:
  void unzoom();
  void addLabel();

protected:
  double deltaX, deltaY;
  int h;
  bool addLabelMode;

  /* used when drawing the selection */
  bool rectStart;
  QPainter* painter;
  int rectX1, rectY1, rectX2, rectY2;
  QStack<KViewport>* lastViewports;

  virtual void paintEvent( QPaintEvent* );
  virtual void resizeEvent( QResizeEvent* e );
  virtual void mouseMoveEvent( QMouseEvent* e );
  virtual void mousePressEvent( QMouseEvent* e );
  virtual void mouseReleaseEvent( QMouseEvent* e );
  virtual void keyReleaseEvent( QKeyEvent* e );

signals:
  void mouseAt( double x, double y );
}; // class KPlotWindow

#endif // _KPLOTWIN_H
