#ifndef _KSCIPLOT_H
#define _KSCIPLOT_H

#include <kapp.h>
#include <kstatusbar.h>
#include <ktopwidget.h>

#include "expression.h"
#include "kfunction.h"
#include "kfunctoolbar.h"
#include "kplotwin.h"


double xlog( double x, double base );
double log2( double x );


class KPlot;
class KPlotMainWindow;


class KPlot : public KApplication
{
  Q_OBJECT

public:
  KPlot( int& argc, char** argv );

public slots:
  void newExpression();
  void delExpression( uint index );
  void print();
  void addFromFile();

signals:
  void expressionAdded();
  void expressionDeleted( uint index );
}; // class KPlot


class KPlotMainWindow : public KTopLevelWidget
{
  Q_OBJECT

public:
  KPlotMainWindow();

private:
  QPopupMenu* qpmOptions;
  KStatusBar* statusBar;
  KFunctionToolBar* toolbar;
  bool showStatusBar;
  int statusID;
  bool showToolBar;
  int toolID;
  int toolbar1;
  KPlotWindow* plotWin;
  int deleteID; // the id of the "ask on delete" menu entry

public slots:
  void mouseAt( double x, double y );
  void overview();
  void askDelete();

private slots:
  void toggleStatusBar();
  void toggleToolBar();

protected:
  virtual void paintEvent( QPaintEvent* e );
  virtual void saveProperties( KConfig* c );
  virtual void readProperties( KConfig* c );
  virtual void keyReleaseEvent( QKeyEvent* e );

signals:
  // they are connected from the toolbar
  void unzoom();
  void addLabel();
}; // class KPlotMainWindow

#endif
