/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

/* Procedure per il disegno di una superficie */

#include<cstdio>
#include<cstring>
#include<cmath>
#include<cfloat>
#include"mplot.h"
#include"mathplot.h"

extern double number;

static struct point OnTheSpace(struct point3d p)
{
  struct point P;

  if( p.x==DBL_MAX )
    {
      P.x=P.y=P.z=0;
      P.color=127; // This special value is used to signal points you
    }              // must not draw
  else
    {
      P.x=(float)p.x;
      P.y=(float)p.y;
      P.z=(float)p.z;
      P.color=0;
    }
  return P;
}

static struct point3d
Superficie(double s,double t,short *coderr,short nel1,short nel2,short nel3)
{
  struct point3d p;

  *coderr=0;
  *coderr=CommExec(s,t,1,nel1);
  p.x=number;
  if(*coderr)
    {
      p.x=p.y=p.z=DBL_MAX;
      return p;
    }
  /* */
  *coderr=CommExec(s,t,2,nel2);
  p.y=number;
  if(*coderr)
    {
      p.x=p.y=p.z=DBL_MAX;
      return p;
    }
  /* */
  *coderr=CommExec(s,t,3,nel3);
  p.z=number;
  if(*coderr)
    {
      p.x=p.y=p.z=DBL_MAX;
      return p;
    }
  return p;
}

#define LSTR 60

char* DsnSup(mycanvas* cnv)
{
  short nel1,nel2,nel3;
  double hs,ht;
  int i,j;
  struct point3d p;
  struct point P;
  struct Param3d* par=cnv->get_par3d();
  static char str[LSTR];
  char *psz;

  if( (psz=Evaluate(1, &nel1)) )
    {
      strcpy(str,"X: ");
      strcat(str,psz); 
      // Do not worry! s is enough long to contain "X: " + psz[]
      clean(1);
      return str;
    }
  if( (psz=Evaluate(2, &nel2)) )
    {
      strcpy(str,"Y: ");
      strcat(str,psz); 
      // Do not worry! s is enough long to contain "Y: " + psz[]
      clean(2);
      return str;
    }
  if( (psz=Evaluate(3, &nel3)) )
    {
      strcpy(str,"Z: ");
      strcat(str,psz); 
      // Do not worry! s is enough long to contain "Z: " + psz[]
      clean(3);
      return str;
    }
  hs=(par->s2 - par->s1)/(par->nnods-1);
  ht=(par->t2 - par->t1)/(par->nnodt-1);
  /* Tracciamento delle curve ottenute fissando s */
  for(j=0;j<par->nnods;j++)
    {
      double s,t;

      s=par->s1+j*hs;
      /* Inizio II ciclo */
      for(i=0;i<par->nnodt;i++)
	{
	  short coderr;

	  t=par->t1+i*ht;
	  p=Superficie(s,t,&coderr, nel1, nel2, nel3);
	  switch( coderr )
	    {
	    case 24:
	      snprintf(str,LSTR,"Missing operator or parenthesis");
	      clean(3);
	      return str;
	    case 3:
	    case 4:
	    case 5:
	    case 6:
	    case 8:
	    case 0:
	      /*Nihil*/;
	    }
	  P=OnTheSpace(p);
	  cnv->setv(P,j*par->nnodt+i);
	  // j*par->nnodt+i is the index of P (first vertex of the line)
	}
      /* Fine II ciclo */
    }
  clean(3);
  return NULL;
}

char* WrtSup(struct Param3d* par,FILE* pf)
{
  short nel1,nel2,nel3;
  double hs,ht;
  int i,j;
  struct point3d p;
  struct point P;
  static char str[LSTR];
  char *psz;  

  if( (psz=Evaluate(1, &nel1)) )
    {
      strcpy(str,"X: ");
      strcat(str,psz); 
      // Do not worry! s is enough long to contain "X: " + psz[]
      clean(1);
      return str;
    }
  if( (psz=Evaluate(2, &nel2)) )
    {
      strcpy(str,"Y: ");
      strcat(str,psz); 
      // Do not worry! s is enough long to contain "Y: " + psz[]
      clean(2);
      return str;
    }
  if( (psz=Evaluate(3, &nel3)) )
    {
      strcpy(str,"Z: ");
      strcat(str,psz); 
      // Do not worry! s is enough long to contain "Z: " + psz[]
      clean(3);
      return str;
    }
  hs=(par->s2 - par->s1)/(par->nnods-1);
  ht=(par->t2 - par->t1)/(par->nnodt-1);
  for(j=0;j<par->nnods;j++)
    {
      double s,t;

      // You must insert an empty line before each data block
      fprintf(pf,"\n");
      if( ferror(pf) || feof(pf) )
	{
	  snprintf(str,LSTR,"Error in output operation on file");
	  clean(3);
	  return str;
	}
      s=par->s1+j*hs;
      /* Inizio II ciclo */
      for(i=0;i<par->nnodt;i++)
	{
	  short coderr;

	  t=par->t1+i*ht;
	  p=Superficie(s,t,&coderr, nel1, nel2, nel3);
	  switch( coderr )
	    {
	    case 24:
	      snprintf(str,LSTR,"Missing operator or parenthesis");
	      clean(3);
	      return str;
	    case 3:
	    case 4:
	    case 5:
	    case 6:
	    case 8:
	      P.x=P.y=P.z=FLT_MAX;
	      break;
	    case 0:
	      P.x=(float)p.x;
	      P.y=(float)p.y;
	      P.z=(float)p.z;
	    }
	  P.color=0;
	  fprintf(pf,"% 20f\t% 20f\t% 20f\n",P.x,P.y,P.z);
	  if( ferror(pf) || feof(pf) )
	    {
	      snprintf(str,LSTR,"Error in output operation on file");
	      clean(3);
	      return str;
	    }
	} // end for(i=0 ...
    } // end for(j=0 ...      
  clean(3);
  return NULL;
}
