/*********************************************************
			 JINX 1.1                       
Hey! Just read the header file for the official         
comments. This will just make an object file.           
*********************************************************/

#include"JINX.h"
#include<X11/Xatom.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#define UP_K 250
#define DOWN_K 251
#define LEFT_K 252
#define RIGHT_K 253
#define DEL_K 254

Pair LASTClick;
int Button;
int LASTKey;
Window EventWin;
Display *MainDisplay;
int Colors[7];
XFontStruct *MainFont;

static GC DeActivGC;

void delChar (char *p)
{
	while (*p)
	{
		*p = *(p + 1);
		p ++;
	}
}

void insChar (char *p, char c)
{
	char *t = p;

	while (*t) t ++;
	while (t != p - 1)
	{
		*(t + 1) = *t;
		t --;
	}
	*p = c;
}

int InitLib (Display *d, Window *w)
{
	XColor gett, dummy;
	XGCValues vv;
	Colormap cmap;
	MainDisplay = d;
	cmap = XDefaultColormap (d, XDefaultScreen (d));
	XAllocNamedColor (d, cmap, "white", &gett, &dummy);
	Colors [WHITE] = gett.pixel;
	XAllocNamedColor (d, cmap, "black", &gett, &dummy);
	Colors [BLACK] = gett.pixel;
	XAllocNamedColor (d, cmap, "yellow", &gett, &dummy);
	Colors [YELLOW] = gett.pixel;
	XAllocNamedColor (d, cmap, "grey", &gett, &dummy);
	Colors [GREY] = gett.pixel;
	XAllocNamedColor (d, cmap, "red", &gett, &dummy);
	Colors [RED] = gett.pixel;
	XAllocNamedColor (d, cmap, "dark grey", &gett, &dummy);
	Colors [DGREY] = gett.pixel;
	XAllocNamedColor (d, cmap, "sandy brown", &gett, &dummy);
	Colors [BROWN] = gett.pixel;
	MainFont = XLoadQueryFont (d, DEFAULT_FONT);
	vv.function = GXor;
	vv.fill_style = FillSolid;
	vv.foreground = Colors [DGREY];
	vv.background = Colors [GREY];
	DeActivGC = XCreateGC (d, *w, GCFillStyle + GCFunction +
			 + GCBackground + GCForeground, &vv);
	return 0;
}

/* 
 * Dad Box: Father of all the rest
 *   members.
 */
void DadBox::MakeInit (int x, int y, int w, int l)
{
	XGCValues* v;
	v = new XGCValues;
	Transparent = 0;
	Origin.X = x;
	Origin.Y = y;
	Dimen.X = w;
	Dimen.Y = l;
	End.X = x + w;
	End.Y = y + l;
	v->fill_style = FillSolid;
	gc = XCreateGC (MainDisplay, *W, GCFillStyle, v);
	Active = Sunken = 1;
	delete v;
}


void DadBox::SetGCColor (COLORS c, int f)
{
	XGCValues val;
	if (f) val.foreground = Colors [c];
	else val.background = Colors [c];
	XChangeGC (D, gc, (f) ? GCForeground : GCBackground, &val);
}

void DadBox::DrawBlank ()
{
	SetGCColor (GREY);
	XFillRectangle (D, *W, gc, Origin.X, Origin.Y, Dimen.X, Dimen.Y);
	SetGCColor ((Sunken) ? BLACK : WHITE);
	XDrawRectangle (D, *W, gc, Origin.X, Origin.Y, Dimen.X, Dimen.Y);
	SetGCColor ((Sunken) ? WHITE : BLACK);
	XDrawLine (D, *W, gc, Origin.X, Origin.Y, End.X, Origin.Y);
	XDrawLine (D, *W, gc, Origin.X, Origin.Y, Origin.X, End.Y);
}

DadBox::DadBox (int x, int y, int w, int l, Window *ww)
{
	D = MainDisplay;
	W = ww;
	MakeInit (x, y, w, l);
}

void DadBox::DeActivate ()
{
	XFillRectangle (MainDisplay, *W, DeActivGC,
			Origin.X, Origin.Y, Dimen.X, Dimen.Y);
}

void DadBox::Draw ()
{
	if (!(Transparent)) DrawBlank ();
	PersonalDraw ();
	if (!(Active)) DeActivate ();
}

int DadBox::CheckClick ()
{
	return  ((LASTClick.X > Origin.X) && (LASTClick.X < End.X) 
		&& (LASTClick.Y > Origin.Y) && (LASTClick.Y < End.Y));
}

Pair DadBox::Ends ()
{
	return End;
}

/* 
 * Box containing constant text.
 *  Can be a button.
 *
 */
ConstTextBox::ConstTextBox (int x, int y, int w, int l, Window *ww,
	char *FontName, char *txt, PLACEM p) : DadBox (x, y, w, l, ww)
{
	XGCValues val;
	Text = txt;
	ValidLength = strlen (txt);
	fontinfo = XLoadQueryFont (D, FontName);
	val.font = fontinfo->fid;
	XChangeGC (D, gc, GCFont, &val); 
	while (XTextWidth (fontinfo, txt, ValidLength) > Dimen.X - LOST_SPACE)
		ValidLength --;
	TextOrigin.X = Origin.X + MARGIN_SIZE + 1;
	if (p != FLUSHL) 
		TextOrigin.X += (p == FLUSHR) ?
		Dimen.X - XTextWidth (fontinfo, txt, ValidLength) - LOST_SPACE:
		(Dimen.X - XTextWidth (fontinfo, txt, ValidLength))/2;
	TextOrigin.Y = Origin.Y - MARGIN_SIZE / 2 + (Dimen.Y +
	(fontinfo->max_bounds.ascent + fontinfo->max_bounds.descent))/2;
}

void ConstTextBox::DrawText ()
{
	SetGCColor (BLACK);
	SetGCColor (GREY, 0);
	XDrawImageString (D, *W, gc, TextOrigin.X, TextOrigin.Y,
			Text, ValidLength);
}

/* 
 * A Box that can have
 *   a Yes/No Tick box
 *
 */
void CheckBox::BoxOff ()
{
	SetGCColor (BLACK);
	XDrawRectangle (D, *W, gc, Origin.X + MARGIN_SIZE * 2 - 1,
			TextOrigin.Y - 2 * MARGIN_SIZE - 1,
			MARGIN_SIZE * 2 + 2, MARGIN_SIZE * 2 + 2);
	SetGCColor (WHITE);
	XFillRectangle (D, *W, gc, Origin.X + MARGIN_SIZE * 2,
			TextOrigin.Y - 2 * MARGIN_SIZE,
			MARGIN_SIZE * 2, MARGIN_SIZE * 2);
}

void CheckBox::BoxOn ()
{
	BoxOff ();
	SetGCColor (RED);
	XDrawLine (D, *W, gc, Origin.X + MARGIN_SIZE * 2,
			TextOrigin.Y - MARGIN_SIZE,
			Origin.X + MARGIN_SIZE * 3,
			TextOrigin.Y);
	XDrawLine (D, *W, gc, Origin.X + MARGIN_SIZE * 3,
			TextOrigin.Y,
			Origin.X + MARGIN_SIZE * 4,
			TextOrigin.Y - 2 * MARGIN_SIZE);
}

CheckBox::CheckBox (int x, int y, int w, int l, Window *ww,
		char *FontName, char *txt, int s)
	: ConstTextBox (x, y, w, l, ww, FontName, txt, FLUSHR)
{
	State = s;
}

void CheckBox::PersonalDraw ()
{
	DrawText ();
	if (State) BoxOn ();
	else BoxOff ();
}

/* 
 * Like the CheckBox only round
 *    to define radio
 *
 */
void RadioBox::BoxOff ()
{
	SetGCColor (WHITE);
	XFillArc (D, *W, gc, Origin.X + MARGIN_SIZE * 2 - 2,
			TextOrigin.Y - 2 * MARGIN_SIZE - 2,
			2 * MARGIN_SIZE + 4, 2 * MARGIN_SIZE + 4,
			0, 360 * 64);
}

void RadioBox::BoxOn ()
{
	BoxOff ();
	SetGCColor (BLACK);
	XFillArc (D, *W, gc, Origin.X + MARGIN_SIZE * 2 - 1,
			TextOrigin.Y - 2 * MARGIN_SIZE  - 1,
			2 * MARGIN_SIZE + 1, 2 * MARGIN_SIZE + 1,
			0, 360 * 64);
}

/*
 * FixedFont Display
 *    Like LCD huh?
 *
 */
FFDisplay::FFDisplay (XFontStruct* f, int w, int h, int l, int x, 
			int y, Window *ww, int o)
{
	FFWidth = w;
	FFHeight = h;
	L = l;
	DrawOutline = o;
	D = MainDisplay;
	W = ww;
	Origin.X = x;
	Origin.Y = y;
	vals.font = f->fid;
	bg = BLACK;
	fg = WHITE;
	ol = DGREY;
	gc = XCreateGC (D, *W, GCFont, &vals);
}

void FFDisplay::Draw (char *t)
{
	vals.foreground = Colors [bg];
	vals.background = Colors [bg];
	XChangeGC (D, gc, GCForeground + GCBackground, &vals);
	XFillRectangle (D, *W, gc, Origin.X, Origin.Y,
			(1 + L) * FFWidth + 2, FFHeight + 4);
	if (DrawOutline)
	{
		vals.foreground = Colors [ol];
		XChangeGC (D, gc, GCForeground, &vals);
		XDrawRectangle (D, *W, gc, Origin.X, Origin.Y,
				L * FFWidth + 8, FFHeight + 4);
	}
	if (strlen (t))
	{
		vals.foreground = Colors [fg];
		XChangeGC (D, gc, GCForeground, &vals);
		XDrawImageString (D, *W, gc, Origin.X + 2, 
				Origin.Y + FFHeight, t, 
			(strlen (t) > L) ? L : strlen (t));
	}
}

/*
 * FixedFontGet stuff
 *
 */
FFGet::FFGet (XFontStruct* f, int w, int h, int l, int x, 
	int y, Window *ww, char *s, int o) 
	: FFDisplay (f, w, h, l, x, y, ww, o)
{
	Text = new char [l + 1];
	for (int i = 0; i < l; i++)
		Text [i] = 0;
	strncpy (Text, s, l);
	pointer = lc = strlen (s);
	On = 0;
}

void FFGet::PutCursor (unsigned int c)
{
	vals.foreground = Colors [bg];
	vals.background = Colors [fg];
	XChangeGC (D, gc, GCBackground | GCForeground, &vals);
	XDrawImageString (D, *W, gc, Origin.X + 2 + c * FFWidth, 
			Origin.Y + FFHeight, (c == lc) ? " " : Text + c, 1); 
}

int FFGet::StandardCheck (const unsigned char c)
{
	if (c == '\b' || c == LEFT_K) return (pointer > 0);
	if (c == DEL_K || c == RIGHT_K) return (pointer < lc);
	if (c == '\n') return 1;
	if (lc == L) return 0;
	if (c == 0 || c == UP_K || c == DOWN_K) return 0;
	return 2;
}
	
int FFGet::valid (const unsigned char c)
{
	return (StandardCheck (c));
}

int FFGet::GetChar ()
{
	lc = strlen (Text);
	if (valid (LASTKey))
		switch (LASTKey)
		{
			case '\n':
				On = 0;
				break;
			case '\b':
				delChar (Text + pointer - 1);
				if (pointer > 0)
					pointer --;
				break;
			case DEL_K:
				delChar (Text + pointer);
				break;
			case UP_K:
			case DOWN_K:
				break;
			case LEFT_K:
				if (pointer > 0)
					pointer --;
				break;
			case RIGHT_K:
				if (pointer < lc)
					pointer ++;
				break;
			default:
				insChar (Text + pointer++, LASTKey);
				lc++;
		}
	Draw (Text);
	if (On)
		PutCursor (pointer);
	Text [lc] = 0;
	return lc;
}

/*
 * Son of FFGet which
 *   allows only characters matching 
 *   those of an array
 *
 */
int MatchCharsGet::valid (const unsigned char c)
{
	char *s;
	int i;
	i = StandardCheck (c);
	if (i != 2)
		return i;
	for (s = CharSet; *s != 0; s++)
		if (*s == c) return 1;
	return 0;
}

/*
 * Son of MatchCharsGet which
 *    doesnt allow chars in the array
 *
 */
int NotMatchCharsGet::valid (const unsigned char c)
{
	char *s;
	int i;
	i = StandardCheck (c);
	if (i != 2)
		return i;
	for (s = CharSet; *s != 0; s++)
		if (*s == c) return 0;
	return 1;
}

/*
 * GetText Box of given Display Type
 *   FFDisplay or ancectors..
 *
 */
GetTextBox::GetTextBox (int x, int y, int w, int l, Window *ww,
	char *FontName, char *txt, int mc, FFGet &ffg)
	: ConstTextBox (x, y, w, l, ww, FontName, txt, FLUSHL)
{
	FFG = &ffg;
	(FFG->Origin).X = End.X - 2 * MARGIN_SIZE - 
			(mc + 1) * FFG->FFWidth;
	(FFG->Origin).Y = TextOrigin.Y - FFG->FFHeight - 1;
	if (*Text == 0) State = 0;
	ID = ++TopID;
}

void GetTextBox::PersonalDraw ()
{
	if (!(IsCurrent ())) 
	{
		LASTKey = 0;
		if (FFG->On == 1) FFG->On = 0;
	}
	State = (FFG->GetChar () != 0);
	if (FFG->On == 0) CurrentID = 0;
	DrawText ();
}

int GetTextBox::CurrentID;

int GetTextBox::TopID;

int GetTextBox::CurrentStatus (int x)
{
	return (x) ? CurrentID : CurrentID = 0;
}

/*
 * A Box with a Terminal window
 *  that prints text
 *
 */
TerminalBox::TerminalBox (int xx, int yy, int r, int l, Window *ww,
		XFontStruct *f, int w, int h, COLORS fg, COLORS bg) 
		: DadBox (xx, yy, r * w + 24, l * (h + 4) + 20, ww)
{
	FFD = new FFDisplay* [Lines = l];
	TxtBuffer = new char* [Lines];
	Rows = r;
	int i;
	for (i = 0; i < Lines; i++)
	{
		FFD[i] = new FFDisplay (f, w, h, Rows, 
			xx + 10, yy + 10 + i * (h + 4), ww, 0);
		FFD[i]->fg = fg;
		FFD[i]->bg = bg;
		TxtBuffer[i] = new char [Rows];
	}
	x = 0;
	CLS ();
}

void TerminalBox::LF ()
{
	for (y = 1; y < Lines; y++)
		strcpy (TxtBuffer [y - 1], TxtBuffer [y]);
	for (y = 0; y < Rows; y++)
		TxtBuffer [Lines - 1] [y] = ' ';
	y = Lines - 1;
}

void TerminalBox::CR ()
{
	for (;x < Rows; x++)
		TxtBuffer [y] [x] = ' ';
	x = 0;
	if (++ y >= Lines) LF ();
}

void TerminalBox::PersonalDraw ()
{
	for (int i = 0; i < Lines; i++)
		FFD[i]->Draw (TxtBuffer [i]);
}

void TerminalBox::Echo (char *s)
{
	while (*s)
	{
		if (*s == '\n') CR (); 
		else
		{
			if (x == Rows) CR ();
			TxtBuffer [y] [x++] = *s;
		}
		s++;
	}
	PersonalDraw ();
}

void TerminalBox::CLS ()
{
	y = Lines - 1;
	for (int i = 0; i < Lines; i++) CR ();
	y = 0; x = 0;
}

/*
 * Register Two values dependency
 *  If one if true then activate other
 *   friend of DadBoxes to change Active member
 *
 */

RegisterActive::RegisterActive ()
{
	lc = 0;
}

int RegisterActive::Register (DadBox& db1, DadBox& db2, int f)
{
	if (lc == ACTIVE_DEPS - 1) return 1;
	dep[lc].flag = f;
	dep[lc].r = &(db1.State);
	dep[lc].w = &(db2.Active);
	dep[lc++].BoxToDraw = &db2;
	return 0;
}

int RegisterActive::Register (int* db1, DadBox& db2, int f)
{
	if (lc == ACTIVE_DEPS - 1) return 1;
	dep[lc].flag = f;
	dep[lc].r = db1;
	dep[lc].w = &(db2.Active);
	dep[lc++].BoxToDraw = &db2;
	return 0;
}

int RegisterActive::Register (DadBox& db1, int* db2, int f)
{
	if (lc == ACTIVE_DEPS - 1) return 1;
	dep[lc].flag = f;
	dep[lc].r = &(db1.State);
	dep[lc].w = db2;
	dep[lc++].BoxToDraw = NULL;
	return 0;
}

int RegisterActive::CheckDeps ()
{
	int Change = 0;
	for (int i = 0; i < lc; i++)
		if (((dep[i].flag) ? (!(*dep[i].r)) : (*dep[i].r)) 
			!= (*dep[i].w))
		//if (((*dep[i].r) ^^ (dep[i].flag)) != (*dep[i].w))
		{
			*dep[i].w = (!(*dep[i].w));
			Change = 1;
		}
	return Change;
}

/*
 * Draw manager, register Boxes
 *   And draw them all on demand.
 *
 */
int DrawManager::Register (DadBox *b)
{
	if (Top == DM_ELEMS) return 1;
	Elements [Top++] = b;
	return 0;
}

int DrawManager::Withdraw (DadBox *b)
{
	int i, j;
	for (i = 0, j = Top; i < Top; i++)
		if (b == Elements [i]) j = i;
	if (j == Top) return 1;
	for (--Top; j < Top; j++)
		Elements [j] = Elements [j + 1];
	return 0;
}

void DrawManager::Draw ()
{
	for (int i = 0; i < Top; i++)
		Elements[i]->Draw ();
	XFlush (MainDisplay);
}

/*
 * Text Boxes manager, 
 *   Send input character to resposnible GetTextBox
 *   and proccess click to redefine active GetTextBox
 *
 */
int TextBoxManager::Register (GetTextBox *b)
{
	if (Top == TBM_ELEMS) return 1;
	Elements [Top++] = b;
	return 0;
}

void TextBoxManager::ProcChar ()
{
	int j, i;
	if (GetTextBox::CurrentStatus (1))
		if (LASTKey == '\t')
		{
			for (i = j = 0; i < Top; i++)
				if (Elements[i]->IsCurrent ())
					j = i + 1;
			DeActivateActive ();
			for (i = j; i < Top + j; i++)
			if (Elements[i % Top]->Active)
			{
				Elements[i % Top]->makeCurrent ();
				LASTKey = 0;
				Elements[i % Top]->PersonalDraw ();
				break;
			}
		}
		else
		for (i = 0; i < Top; i++)
			if (Elements[i]->IsCurrent ())
				Elements[i]->PersonalDraw ();
}

void TextBoxManager::DeActivateActive ()
{
	if (GetTextBox::CurrentStatus (1))
	{
		LASTKey = '\n';
		ProcChar ();
	}
}

void TextBoxManager::ManageClick ()
{
	int i, j;
	for (i = 0, j = Top; i < Top; i++)
		if (Elements[i]->CheckClick ()) j = i;
	if (j != Top)
	{
		if (Elements[j]->Active)
		{
			DeActivateActive ();
			Elements[j]->makeCurrent ();
			LASTKey = 0;
			Elements[j]->PersonalDraw ();
		}
		if (Button == 2) PasteToGTB (Elements[j]);
	}
	else
	{
		DeActivateActive ();
		GetTextBox::CurrentStatus (0);
	}
}

/*
 * Radio Compound manager, 
 *   Check if one from the list was clicked
 *    leave the other and go to this.
 *
 */
int RadioCompound::Register (CheckBox *b)
{
	if (Top == RC_ELEMS) return 1;
	Elements [Top++] = b;
	return 0;
}

int RadioCompound::CheckClick ()
{
	int i, j;
	for (i = 0, j = Top; i < Top; i++)
		if (Elements[i]->CheckClick ()) j = i;
	if (j != Top)
	{
		for (i = 0; i < Top; i++)
		if (Elements[i]->State)
		{
			Elements[i]->State = 0;
			Elements[i]->Draw ();
		}
		Elements[j]->State = 1;
		Elements[j]->Draw ();
		return 1;
	}
	return 0;
}

/*
 *  Check On-Off Boxes Manager
 *    Compare the last click with
 *    all register Boxes and toggle State
 *
 */

int CheckOnOffManager::CheckClick ()
{
	for (int i = 0; i < Top; i++)
		if (Elements[i]->CheckClick ())
		{
			Elements[i]->State = (!(Elements[i]->State));
			Elements[i]->Draw ();
			return 1;
		}
	return 0;
}

/*
 * Paste selection to a GetTextBox
 *  This is filtered
 *
 */
void PasteToGTB (GetTextBox *gtb)
{
	Window owner;
	unsigned char *data, *p;
	Atom type;
	int d1, result;
	unsigned long d2, d3, len;
	Display *D = MainDisplay;
	XEvent e;
	if ((owner = XGetSelectionOwner (D, XA_PRIMARY)) != None)
	{
		XConvertSelection (D, XA_PRIMARY, XA_STRING, None, EventWin,
				 CurrentTime);
		XFlush (D);
		XSelectInput (D, EventWin, NoEventMask);
		XNextEvent (D, &e);
		if (e.type != SelectionNotify)
			return;
		if (e.xselection.property != XA_STRING)
			return;
		XGetWindowProperty (D, EventWin, XA_STRING, 0, 0, 0,
				AnyPropertyType, &type, &d1, 
				&d3, &len, &data);
		if (gtb->FreeChars () < len)
			len = gtb->FreeChars ();
		result = XGetWindowProperty (D, EventWin, XA_STRING, 0, len,
			0, AnyPropertyType, &type, &d1, &d3, &d2, &data);
		d2 = 0;
		p = data;
		if (result == Success)
			while (d2++ < len && (GetTextBox::CurrentStatus (1)))
			{
				LASTKey = *p;
				gtb->Draw ();
				p++;
			}
		XFree (data);
	}
}

/*
 * Study various XEvents and send
 *   results to widgets and raise flags
 *   Depending on the BlockUntil..do that
 *
 */
char LowCase [] = "`1234567890-=[]\\;',./\0~!@#$%^&*()_+{}|:\"<>?";

int EventHandler(Window *W, int BlockUntil)
{
	XEvent xeven;
	static int CAPS = 0, SHIFT = 0;
	char cc, *ccc;
	XSelectInput (MainDisplay, *W, ButtonPressMask + KeyPressMask +
			ExposureMask + KeyReleaseMask);
	if (!(BlockUntil))
	if (XEventsQueued (MainDisplay, QueuedAfterFlush) == 0) return 0;
	XNextEvent (MainDisplay, &xeven);
	KeySym ks, kk, kks;
	cc = 0;
	EventWin = xeven.xany.window;
	switch (xeven.type)
	{
		case ButtonPress:
			LASTClick.X = xeven.xbutton.x;
			LASTClick.Y = xeven.xbutton.y;
			Button = xeven.xbutton.button;
			return ButtonPress;
		case KeyPress:
			ks = XKeycodeToKeysym (MainDisplay, 
					xeven.xkey.keycode, 0);
			if ((ks >= XK_space) && (ks <= XK_asciitilde))
			{
				kks = XK_space;
				if (SHIFT)
				{
					if ((ccc = strchr (LowCase, ks)))
						cc = *(ccc + 22);
				}
				if (!(cc))
				if ((CAPS) ? (!SHIFT) : (SHIFT))
					XConvertCase (ks, &kk, &kks);
				else
					XConvertCase (ks, &kks, &kk);
				kks += ' ' - XK_space;
				LASTKey = (cc) ? cc : kks;
				return KeyPress;
			}
			switch (ks) {
				case XK_BackSpace:
					LASTKey = '\b';
					break;
				case XK_Delete:
					LASTKey = DEL_K;
					break;
				case XK_Return:
					LASTKey = '\n';
					break;
				case XK_Tab:
					LASTKey = '\t';
					break;
				case XK_Caps_Lock:
					CAPS = (!(CAPS));
					return 0;
				case XK_Left:
					LASTKey = LEFT_K;
					break;
				case XK_Right:
					LASTKey = RIGHT_K;
					break;
				case XK_Down:
					LASTKey = DOWN_K;
					break;
				case XK_Up:
					LASTKey = UP_K;
					break;
				case XK_Shift_L:
				case XK_Shift_R:
					SHIFT = 1;
				default:
					return 0;
			}
			return KeyPress;
		case KeyRelease:
			ks = XKeycodeToKeysym (MainDisplay, 
					xeven.xkey.keycode, 0);
			if ((ks == XK_Shift_L) || (ks == XK_Shift_R))
				SHIFT = 0;
			return 0;
		case Expose:
//			EventWin = xeven.xexpose.window;
		default:
			return xeven.type;
	}
}
