/*****************************************************

			 JINX
Revision: 24
		Free Xlib Widgets Library

		by Stelios Xanthakis
		<axanth@tee.gr>

`` If you want your programs
   to be JINXed to crash all
   the time just visit
http://nemesis.ee.teiath.gr/stelios/
   to get the latest version
   and some cool documentation.
   You 'll get some pretty neat
   results too.''
   
****************************************************/

#include<X11/Xlib.h>
#include<X11/keysym.h>
#include<X11/Xutil.h>

#define DEFAULT_FONT "6x10"
#define MARGIN_SIZE 3
#define LOST_SPACE 2*MARGIN_SIZE
#define ACTIVE_DEPS 20
#define DM_ELEMS 45
#define TBM_ELEMS 25
#define RC_ELEMS 25

typedef enum { BLACK, WHITE, GREY, YELLOW, RED, DGREY, BROWN } COLORS;
typedef enum { FLUSHL, FLUSHR, CENTER } PLACEM;

struct Pair
{
	int X, Y;
};

class DadBox
{
   protected:
	Display *D;
	Window *W;
	GC gc;
	int Active;
	Pair Origin, Dimen, End, Click;
	void MakeInit (int, int, int, int);
	void DrawBlank ();
	virtual void PersonalDraw () { };
	void DeActivate ();
	void SetGCColor (COLORS, int = 1);
   public:
	int Transparent, State, Sunken;
	DadBox (int, int, int, int, Window*);
	void Draw ();
	int CheckClick ();
	friend class RegisterActive;
	Pair Ends ();
};

class ConstTextBox : public DadBox
{
   protected:
	Pair TextOrigin;
	PLACEM Placement;
	char *Text;
	unsigned short int ValidLength;
	XFontStruct *fontinfo;
	void DrawText ();
	virtual void PersonalDraw () 		{ DrawText (); }
   public:
	ConstTextBox (int, int, int, int, Window*, 
			char*, char*, PLACEM = CENTER);
};

class CheckBox : public ConstTextBox
{
   protected:
	virtual void BoxOn ();
	virtual void BoxOff ();
	void PersonalDraw ();
   public:
	CheckBox (int, int, int, int, Window*, char*, char*, int);
};

class RadioBox : public CheckBox
{
   protected:
	virtual void BoxOn ();
	virtual void BoxOff ();
   public:
	RadioBox (int x, int y, int w, int l, Window *ww, char *f,
			char *t, int s) :
		CheckBox (x, y, w, l, ww, f, t, s) { }
};

class FFDisplay
{
   protected:
	unsigned int DrawOutline, FFWidth, FFHeight, L;
	Pair Origin;
	Display *D;
	Window *W;
	GC gc;
	XGCValues vals;
   public:
	COLORS bg, fg, ol;
	FFDisplay (XFontStruct*, int, int, int, int, int, Window*, int = 1);
	void Draw (char *);
};

class FFGet : public FFDisplay
{
   protected:
	unsigned int lc, pointer;
	int StandardCheck (const unsigned char);
	virtual int valid (const unsigned char);
	void PutCursor (unsigned int);
	int On;
   public:
	char *Text;
	FFGet (XFontStruct*, int, int, int, int, int, Window*, 
				char*, int = 1);
	int GetChar ();
	friend class GetTextBox;
};	

class MatchCharsGet : public FFGet
{
   protected:
 	char *CharSet;
	virtual int valid (const unsigned char);
   public:
	MatchCharsGet (XFontStruct* f, int x, int y, int w, int l, int q, 
		Window* ww, char* c, char *st, int z = 1) : 
		FFGet (f, x, y, w, l, q, ww, c, z) { CharSet = st; }
};

class NotMatchCharsGet : public FFGet
{
   protected:
 	char *CharSet;
	virtual int valid (const unsigned char);
   public:
	NotMatchCharsGet (XFontStruct* f, int x, int y, int w, int l, int q, 
		Window* ww, char* c, char *st, int z = 1) : 
		FFGet (f, x, y, w, l, q, ww, c, z) { CharSet = st; }
};

class GetTextBox : public ConstTextBox
{
   private:
	FFGet* FFG;
	static int CurrentID, TopID;
	int ID;
   protected:
	void PersonalDraw ();
   public:
	GetTextBox (int, int, int, int, Window*, char*, 
			char*, int, FFGet&);
	int IsCurrent ()		{ return (ID == CurrentID); }
	void makeCurrent ()		{ CurrentID = ID; FFG->On = 1; }
	static int CurrentStatus (int);
	char* QueryString ()		{ return FFG->Text; }
	unsigned int FreeChars ()	{ return FFG->L - FFG->lc; }
	friend class TextBoxManager;
};

class TerminalBox : public DadBox
{
   private:
	int x, y, Lines, Rows;
	FFDisplay **FFD;
	char **TxtBuffer;
	void LF ();
	void CR ();
	void PersonalDraw ();
   public:
	TerminalBox (int, int, int, int, Window*, XFontStruct*, int, int,
			COLORS = WHITE, COLORS = BLACK);
	void Echo (char*);
	void CLS ();
};

struct Depend
{
	int *r, *w, flag;
	DadBox *BoxToDraw;
};

class RegisterActive
{
   private:
	Depend dep [ACTIVE_DEPS];
	unsigned short int lc;
   public:
	RegisterActive ();
	int Register (DadBox&, DadBox&, int = 1);
	int Register (int*, DadBox&, int = 1);
	int Register (DadBox&, int*, int = 1);
	int CheckDeps ();
};

class DrawManager
{
   private:
	DadBox * Elements [DM_ELEMS];
	unsigned short int Top;
   public:
	DrawManager ()		{ Top = 0; }
	int Register (DadBox*);
	int Withdraw (DadBox*);
	void Draw ();
};

class TextBoxManager
{
   private:
	GetTextBox * Elements [TBM_ELEMS];
	unsigned short int Top;
	void DeActivateActive ();
   public:
	TextBoxManager ()	{ Top = 0; }
	int Register (GetTextBox*);
	void ProcChar ();
	void ManageClick ();
};

class RadioCompound
{
   protected:
	CheckBox * Elements [RC_ELEMS];
	unsigned short int Top;
   public:
	RadioCompound ()	{ Top = 0; }
	int Register (CheckBox*);
	virtual int CheckClick ();
};

class CheckOnOffManager : public RadioCompound
{
   public:
	CheckOnOffManager () : RadioCompound () { }
	virtual int CheckClick ();
};

void PasteToGTB (GetTextBox*);
int EventHandler (Window*, int);
int InitLib (Display*, Window*);
