/********************************************

	Text mode Formula Evaluation

 		by Stelios Xanthakis
			<axanth@tee.gr>

*********************************************/
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <math.h>

#define MAX_LENGTH 60

#define INNUM(x) (((x >= '0') && (x <= '9')) || (x == '.'))
#define INCHARS(x) ((x >= 'A') && (x <='Z'))
#define ALLIN(x, y) for (ip = mainstr; *(ip+1) != '\0'; ip++) \
if (charinstring (*ip, x)) if (!charinstring (*(ip+1), y)) return 6;

#define MAX_PARENTH 20
#define MAX_NUMS 20
#define BL 12
#define DL 10
#define FUNC_NUM 12

typedef enum { MULT, DIVI, POWE } PRAXI;

char mainstr [MAX_LENGTH];

char fstr [] = "COS\0SIN\0TAN\0LOG\0LN\0ATN\0COSH\0SINH\0EXP\0";
char cstr [] = "PI\0E\0X\0DUMY";
char* fst [] = { fstr, fstr+4, fstr+8, fstr+12, fstr+16,\
 fstr+19, fstr+23, fstr+28, fstr+33, cstr, cstr+3, cstr+5, cstr+7 };

double m [MAX_NUMS];
double (*funcat [MAX_PARENTH])(double);

double NOFUNC (double d)
{
	return d;
}

int charinstring (char c, char *s)
{
	for (; *s != '\0'; s++) if (*s == c) return 1;
	return 0;
}
	
int checkparenthesis (char o, char c)
{
	int i = 0, j = 0;
	while ((mainstr[i] != '\0') && (j >= 0))
	{
		if (mainstr[i] == o) j++;
		if (mainstr[i++] == c) j--;
	}
	return (j == 0) ? 0 : (j < 0) ? 1 : 2;
}

int checkwhole ()
{
	char befabso [] = "+-*/^([\0";
	char buffer [] = "1234567890XIE)]\0";
	char *ip, *jp;
	int i, d[DL], j = 0;
	//----Make CAPITAL & Check if only good characters
	for (ip = mainstr; *ip != '\0'; ip++)
	{
		if INCHARS((*ip)-32) *ip -= 32;
		if (!charinstring (*ip, "|1234567890-+*/^.)]([COSINTALGHPEX"))
		return 7;
	}
	//----Check if x in there.
	if (!charinstring ('X', (ip = mainstr))) return 8;
	//----Check if parenthesis Ok
	if ((i = checkparenthesis ('(', ')'))) return i;
	//----Replace and check abs
	if (mainstr[0] == '|') mainstr[0] = '[';
	for (ip = mainstr+1; *ip != '\0'; ip++)
	if (*ip == '|')
	{
		if (charinstring (*(ip-1), befabso)) *ip = '[';
		else if (charinstring (*(ip-1), buffer)) *ip = ']';
			else return 4;
	}
	//----Check if absolut ok
	if ((i = checkparenthesis ('[', ']'))) return i;
	//----Check if no ambiguity abs
	for (ip = mainstr, i = j = 0; *ip != '\0'; ip++)
	switch (*ip)
	{
		case '[': i++; break;
		case ']': i--; break;
		case '(': d[j++] = i; break;
		case ')': if (d[--j] != i) return 5;
	}
	//----Check if strings are valid
	ip = mainstr;
	while (*ip != '\0')
	if INCHARS(*ip)
	{
		jp = ip;
		while INCHARS(*ip) ip++;		
		i = 0;
		while ((i < BL) && (jp < ip)) buffer[i++] = *jp++;
		buffer[i] = '\0';
		i = 0;
		while ((i<FUNC_NUM) && (strcmp (buffer, fst[i]))) i++;
		if (i == 12) return 3;
	}
	else ip++;
	//----Check Rules
	ALLIN("1234567890", ".1234567890-+*/^)]")
	ALLIN("-+*/^", "1234567890CSTALPEX([")
	ALLIN("NGH", "H(")
	ALLIN("SP", "I(")
	ALLIN("EX)]", "-+*/^)]XP")
	ALLIN("I", "N-+*/^)]")
	ALLIN("[(", "1234567890CSTALPEX([-")
	ALLIN(".", "1234567890")
	if (charinstring (mainstr[0], ".+*/^")) return 6;
	if (charinstring (*ip, ".-+*/^CSTAL")) return 6;
	return 0;
}

void del (char *cc)
{
	char *a = cc;
	while (*a++ != '\0') *(a-1) = *a;
}

void insert (char *cp, char c)
{
	char buffer [100];
	strcpy (buffer, cp);
	*cp = c;
	*(cp + 1) = 0;
	strcat (cp, buffer);
}

void fixpriority ()
{
	char *c, *d, *e;
	signed char s, w;

	for (c = mainstr; *c; c++)
	if (*c == '^')
	{
		e = d = c;
		e++;
		s = w = 0;
		while (((*d != '+') && (*d != '-') && (*d != '/')
			&& (*d != '*') && (*d)) || (s < 0))
		{
			if (*d == ')') s--;
			if (*d == '(') s++;
			d--;
		}
		if (((*d == '*') || (*d == '/')) && (s == 0))
		{
			while (((*e != '+') && (*e != '-') && (*e != '/')
				&& (*e != '*') && (*e)) || (w > 0))
			{
				if (*e == ')') w--;
				if (*e == '(') w++;
				e++;
			}
			insert (d + 1, '(');
			insert (e + 1, ')');
			c = mainstr;
		}
	}
}

int getallnums ()
{
	char *ip, *jp, buffer [BL], *kp;
	int i, j = 0;
	for (ip = mainstr; *ip != '\0'; ip++) 
	if INNUM(*ip)
	{
		jp = ip;
		while INNUM(*ip) ip++;
		i = 0;
		while ((i < BL) && (jp < ip)) buffer[i++] = *jp++;
		buffer[i] = '\0';
		i = 0;
		m[j++] = strtod (buffer, &kp);
		if (*kp != '\0') return 9;
	}
	else if (((*ip == 'P') && (*(ip+1) != '(')) || ((*ip == 'E') && (*(ip+1) != 'X'))) 
	     m[j++] = (*ip=='E') ? M_E : M_PI;
	return 0;
}

void getallfuncs ()
{
	char *ip = mainstr;
	int j = 0;
	while (*ip != '\0')
	switch (*ip)
	{
		case 'C': if (*(ip+3) == 'H') { funcat [j++] = cosh; ip += 5; }
			else { funcat [j++] = cos; ip += 4; } break;
		case 'S': if (*(ip+3) == 'H') { funcat [j++] = sinh; ip += 5; }
			else { funcat [j++] = sin; ip += 4; } break;
		case 'T': funcat [j++] = tan; ip += 4; break;
		case 'A': funcat [j++] = atan; ip += 4; break;
		case 'L': if (*(ip+1) == 'N') { funcat[j++] = log; ip += 3; }
			else { funcat [j++] = log10; ip += 4; } break;
		case 'E': funcat [j++] = exp; ip += 4; break;
		case '(': funcat [j++] = NOFUNC; ip++; break;
		case '[': funcat [j++] = fabs; ip++; break;
		default : ip++;
	}
}

void delallnums ()
{
	char *ip = mainstr;
	while (*ip != '\0')
	if INNUM(*ip)
	{
		while INNUM(*(ip+1)) del (ip);
		*ip = 'm';
	}
	else 
	switch(*ip)
	{
		case 'P': del (ip);
		case 'E': if (*(ip+1) == 'X') ip += 3;
		          else *ip = 'm'; break;
		case 'X': if (*(ip+1) != 'P') *ip = 'x';
		default: ip++;
	}
}

void delallfuncs ()
{
	char *ip = mainstr;
	while (*ip != '\0')
	if INCHARS(*ip)	del (ip);
	else
	switch (*ip)
	{
		case '[': *ip = '('; break;
		case ']': *ip = ')';
		default: ip++;
	}
}

static int mp = 0, fp = 1;
static char *p;
static double X;

double getreg (double (*fnx)(double))
{
	double accum = 1, reg = 0, num;
	PRAXI pr = MULT;
	if (*(++p) == '-') 
	{
		accum = -1;
		p++;
	}
	while (1)
	{
		num = (*p == 'm') ? m[mp++] : 
		      (*p == 'x') ? X : getreg (funcat[fp++]);
		switch (pr) 
		{
			case MULT: accum *= num; break;
			case DIVI: accum /= num; break;
			case POWE: accum = pow (accum, num); 
		}
		if (*(++p) == ')') 
		{ 
			reg += accum;
			break;
		}
		switch (*p)
		{
			case '*': pr = MULT; break;
			case '/': pr = DIVI; break;
			case '^': pr = POWE; break;
			default : reg += accum; pr = MULT;
				accum = (*p == '-') ? -1 : 1;
		}
		p++;
	}
	return fnx(reg);
/***
	switch (fnx)
	{
		case  COS: return cos(reg);
		case  SIN: return sin(reg);
		case  TAN: return tan(reg);
		case  LOG: return log10(reg);
		case   LN: return log(reg);
		case  ATN: return atan(reg);
		case COSH: return cosh(reg);
		case SINH: return sinh(reg);
		case  EXP: return exp(reg);
		case  ABS: return fabs(reg);
		default: return reg;
	}
****/
}

char Dumy [] = "Ok";
char Err1 [] = "Wrong parenthesis";
char Err2 [] = "Missing parenthesis";
char Err3 [] = "Invalid string sequence detected";
char Err4 [] = "Misplaced absolute value";
char Err5 [] = "Parenthesis - absolute values conflict";
char Err6 [] = "Syntax doesn't follow the rules";
char Err7 [] = "Invalid character detected";
char Err8 [] = "Not a function of x";
char Err9 [] = "Error in converting string to number";
char* err [] = { Dumy, Err1, Err2, Err3, Err4, Err5, Err6, Err7, Err8, Err9 };

void addparenth ()
{
	char perm [MAX_LENGTH] = "(";
	strcpy (mainstr, (char *) strcat (strcat (perm, mainstr), ")"));
}

int main (int argc, char** argv)
{
	char inchars[30], c, *endptr;
	int errval, i;

	/* Check arguments */
	if (argc == 1)
	{
		fprintf (stderr, "Error: function formula must be defined\n");
		return 1;
	}
	argv++;
	if (!(strcmp (*argv, "--help")))
	{
		printf ("Usage: feval 'function' string.\n");
		return 0;
	}

	/* The first argument is the function therefore */
	strcpy (mainstr, *argv);

	/* Prepare mainstr and check for errors */
	addparenth ();                /* add (mainstr) */
	if ((errval = checkwhole ()))   /* main check */
	{
		fprintf (stderr, "Error:%s\n", err [errval]);
		return 1;
	}
	fixpriority ();
	if ((errval = getallnums ()))   /* put all numbers in registers & check */
	{
		fprintf (stderr, "Error:%s\n", err [errval]);
		return 1;
	}
	delallnums ();               /* replace numbers with 'm' */
	getallfuncs ();              /* make functions array */
	delallfuncs ();              /* delete functions */

	/* Proceed getting values from stdin */
	inchars [0] = 0;
gl00p:
	i = 0;
	if ((c = getchar ()) == EOF) return 0;
	if ((c == ' ') || (c == '\n'))
	{
		X = strtod (inchars, &endptr);
		if (*endptr == '\0')
		{
			fp = 1;
			mp = 0;
			p = mainstr;
			printf ("%f\n", getreg(NOFUNC));
		}
		else
		printf ("Not_a_number:%s\n", inchars);
		while ((c == '\n') || (c == ' '))
			if ((c = getchar ()) == EOF) return 0;
		inchars[0] = '\0';
	}
	while ((i < 30) && (inchars[i] != '\0')) i++;
	if (i == 30)
	{
		fprintf (stderr, "String too long %s:\n", inchars);
		return 1;
	}
	inchars[i++] = c;
	inchars[i] = '\0';
	/** Just because i've read the worse about goto in
	** books about structured programming, well here is
	** a goto with love */
	goto gl00p;
}
