/**********************************************************************

	--- Qt Architect generated file ---

	File: xgfeMain.h

    Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.    

 *********************************************************************/

#ifndef xgfeMain_included
#define xgfeMain_included

#include "xgfeMainData.h"
#include "latexEmtexOp.h"
#include "pbmOp.h"
#include "psOpt.h"
#include "sizeOp.h"
#include "rawGnu.h"
#include "fileOptions.h"
#include "legendOp.h"
#include "multiFile.h"
#include "multiFunc.h"
#include "fileLegendTitle.h"
#include "funcLegendTitle.h"
#include "logScaleOp.h"
#include "fileFilter.h"
#include "barOp.h"
#include "curveFit.h"
#include "boxWidthOp.h"
#include "ticsOp.h"
#include <qapp.h>
#include <qfiledlg.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <iostream.h>
#include <string>
#include <stdio.h>

class xgfeMain : public xgfeMainData
{
    Q_OBJECT

public:

    xgfeMain
    (
        QWidget* parent = 0,
        const char* name = 0
    );

    virtual ~xgfeMain();
  
 public slots:
 
 void plot();
  void replot();
  void dataFileOpen();
  void save();
  void load();
  void saveXgfe();
  void loadXgfe();
  void xgfeQuit();
  void setFilePoints();
  void setFileLines();
  void setFileLinesPoints();
  void setFileImpulses();
  void setFileDots();
  void setFileSteps();
  void setFileFsteps();
  void setFileHisteps();
  void setFileErrorbars();
  void setFileXerrorbars();
  void setFileYerrorbars();
  void setFileXyerrorbars();
  void setFileBoxes();
  void setFileBoxerrorbars();
  void setFileBoxxyerrorbars();
  void setFileFinancebars();
  void setFileCandlesticks();
  void setFuncPoints();
  void setFuncLines();
  void setFuncLinesPoints();
  void setFuncImpulses();
  void setFuncDots();
  void setFuncSteps();
  void setFuncErrorbars();
  void setFuncBoxes();
  void setFilePlotType2d();
  void setFilePlotType3d();
  void setFuncPlotType2d();
  void setFuncPlotType3d();
  void setTermBfig();
  void setTermCorel();
  void setTermDxf();
  void setTermEepic();
  void setTermEmtex();
  void setTermFig();
  void setTermLatex();
  void setTermPbm();
  void setTermPostscript();
  void setTermPslatex(); 
  void setTermPstricks();
  void setTermTable();
  void setTermTexdraw();
  void setTermTgif();
  void setTermTpic();
  void setTermX11();
  void setPlotSize();
  void rawGnuInput();
  void getFileOptions();
  void getLegendOps();
  void getMultiFile();
  void getMultiFunction();
  void setFileLegendTitle();
  void setFuncLegendTitle();
  void setLogScaleOptions();
  void setFileFilter();
  void setBarOptions();
  void resetBarOptions();
  void getCurveFit();
  void setBoxWidthOption();
  void resetBoxWidthOption();
  void setTicsOptions();
  
private:
  void clearFileStyleChecks();
  void clearFuncStyleChecks();
  void clearTermChecks();
};
#endif // xgfeMain_included

