/**********************************************************************

	File: xgfeMainData.cpp

    Main dialog window. This file has been modified by hand to add the 
    menu bar and geometry management. 

    Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


 *********************************************************************/

#include "xgfeMainData.h"

#define Inherited QDialog

#include <qlabel.h>
#include <qmenubar.h>
#include <qpushbt.h>
#include <qlayout.h>

xgfeMainData::xgfeMainData
(
 	QWidget* parent = 0,
	const char* name = 0
)
	:
  Inherited( parent, name, TRUE, WStyle_Customize | WStyle_NormalBorder 
             | WStyle_Title | WStyle_Minimize)
{
  gnuInt = new gnuInterface;
  
  // setup gnuplot interface

  gnuRC = gnuInt->openGnuplot();

  if (gnuRC == NULL) // trouble opening gnuplot
  {
    QMessageBox::critical(0, "Xgfe",
                          "Could not open pipe to Gnuplot!\n"
                          "Application will now exit");
  }
  // end setup of gnuplot

	filenameCB = new QCheckBox( this, "CheckBox_1" );
	filenameCB->setMinimumSize( 80, 30 );
	filenameCB->setMaximumSize( 80, 30 );
	filenameCB->setText( "Filename" );
	filenameCB->setAutoRepeat( FALSE );
	filenameCB->setAutoResize( FALSE );

    filenameEdit = new QLineEdit( this, "LineEdit_23" );
	filenameEdit->setMinimumSize( 290, 30 );
	filenameEdit->setMaximumSize( 32767, 30 );
	filenameEdit->setText( "none" );
	filenameEdit->setMaxLength( 32767 );
	filenameEdit->setEchoMode( QLineEdit::Normal );
	filenameEdit->setFrame( TRUE );

	functionCB = new QCheckBox( this, "CheckBox_2" );
	functionCB->setMinimumSize( 80, 30 );
	functionCB->setMaximumSize( 80, 30 );
	functionCB->setText( "Function" );
	functionCB->setAutoRepeat( FALSE );
	functionCB->setAutoResize( FALSE );

	functionEdit = new QLineEdit( this, "LineEdit_1" );
	functionEdit->setMinimumSize( 290, 30 );
	functionEdit->setMaximumSize( 32767, 30 );
	functionEdit->setText( "" );
	functionEdit->setMaxLength( 32767 );
	functionEdit->setEchoMode( QLineEdit::Normal );
	functionEdit->setFrame( TRUE );

	multiFileCheckbox = new QCheckBox( this, "CheckBox_3" );
	multiFileCheckbox->setMinimumSize( 110, 20 );
	multiFileCheckbox->setMaximumSize( 110, 20 );
	multiFileCheckbox->setText( "Multiple Files" );
	multiFileCheckbox->setAutoRepeat( FALSE );
	multiFileCheckbox->setAutoResize( FALSE );

	multiFuncCheckbox = new QCheckBox( this, "CheckBox_4" );
	multiFuncCheckbox->setMinimumSize( 125, 20 );
	multiFuncCheckbox->setMaximumSize( 125, 20 );
	multiFuncCheckbox->setText( "Multiple Functions" );
	multiFuncCheckbox->setAutoRepeat( FALSE );
	multiFuncCheckbox->setAutoResize( FALSE );

    QLabel* Label_4;
	Label_4 = new QLabel( this, "Label_4" );
	Label_4->setMinimumSize( 80, 30 );
	Label_4->setMaximumSize( 80, 30 );
	Label_4->setText( "Variable X:" );
	Label_4->setAlignment( 289 );
	Label_4->setMargin( -1 );

	varX = new QLineEdit( this, "LineEdit_2" );
	varX->setMinimumSize( 40, 30 );
	varX->setMaximumSize( 32767, 30 );
	varX->setText( "" );
	varX->setMaxLength( 32767 );
	varX->setEchoMode( QLineEdit::Normal );
	varX->setFrame( TRUE );

	QLabel* Label_5;
	Label_5 = new QLabel( this, "Label_5" );
	Label_5->setMinimumSize( 30, 30 );
	Label_5->setMaximumSize( 30, 30 );
	Label_5->setText( "Start:" );
	Label_5->setAlignment( 289 );
	Label_5->setMargin( -1 );

	xStart = new QLineEdit( this, "LineEdit_3" );
	xStart->setMinimumSize( 90, 30 );
	xStart->setMaximumSize( 32767, 30 );
	xStart->setText( "" );
	xStart->setMaxLength( 32767 );
	xStart->setEchoMode( QLineEdit::Normal );
	xStart->setFrame( TRUE );

	QLabel* Label_6;
	Label_6 = new QLabel( this, "Label_6" );
	Label_6->setMinimumSize( 30, 30 );
	Label_6->setMaximumSize( 30, 30 );
	Label_6->setText( "End:" );
	Label_6->setAlignment( 289 );
	Label_6->setMargin( -1 );

	xEnd = new QLineEdit( this, "LineEdit_4" );
	xEnd->setMinimumSize( 90, 30 );
	xEnd->setMaximumSize( 32767, 30 );
	xEnd->setText( "" );
	xEnd->setMaxLength( 32767 );
	xEnd->setEchoMode( QLineEdit::Normal );
	xEnd->setFrame( TRUE );

	QLabel* Label_10;
	Label_10 = new QLabel( this, "Label_10" );
	Label_10->setMinimumSize( 80, 30 );
	Label_10->setMaximumSize( 80, 30 );
	Label_10->setText( "Variable Y:" );
	Label_10->setAlignment( 289 );
	Label_10->setMargin( -1 );

	varY = new QLineEdit( this, "LineEdit_8" );
	varY->setMinimumSize( 40, 30 );
	varY->setMaximumSize( 32767, 30 );
	varY->setText( "" );
	varY->setMaxLength( 32767 );
	varY->setEchoMode( QLineEdit::Normal );
	varY->setFrame( TRUE );

	QLabel* Label_12;
	Label_12 = new QLabel( this, "Label_12" );
	Label_12->setMinimumSize( 30, 30 );
	Label_12->setMaximumSize( 30, 30 );
	Label_12->setText( "Start:" );
	Label_12->setAlignment( 289 );
	Label_12->setMargin( -1 );

	yStart = new QLineEdit( this, "LineEdit_9" );
	yStart->setMinimumSize( 90, 30 );
	yStart->setMaximumSize( 32767, 30 );
	yStart->setText( "" );
	yStart->setMaxLength( 32767 );
	yStart->setEchoMode( QLineEdit::Normal );
	yStart->setFrame( TRUE );

	QLabel* Label_13;
	Label_13 = new QLabel( this, "Label_13" );
	Label_13->setMinimumSize( 30, 30 );
	Label_13->setMaximumSize( 30, 30 );
	Label_13->setText( "End:" );
	Label_13->setAlignment( 289 );
	Label_13->setMargin( -1 );

	yEnd = new QLineEdit( this, "LineEdit_10" );
	yEnd->setMinimumSize( 90, 30 );
	yEnd->setMaximumSize( 32767, 30 );
	yEnd->setText( "" );
	yEnd->setMaxLength( 32767 );
	yEnd->setEchoMode( QLineEdit::Normal );
	yEnd->setFrame( TRUE );

	QLabel* Label_14;
	Label_14 = new QLabel( this, "Label_14" );
	Label_14->setMinimumSize( 80, 30 );
	Label_14->setMaximumSize( 80, 30 );
	Label_14->setText( "Variable Z:" );
	Label_14->setAlignment( 289 );
	Label_14->setMargin( -1 );

	QLabel* Label_15;
	Label_15 = new QLabel( this, "Label_15" );
	Label_15->setMinimumSize( 30, 30 );
	Label_15->setMaximumSize( 30, 30 );
	Label_15->setText( "Start:" );
	Label_15->setAlignment( 289 );
	Label_15->setMargin( -1 );

	zStart = new QLineEdit( this, "LineEdit_12" );
	zStart->setMinimumSize( 90, 30 );
	zStart->setMaximumSize( 32767, 30 );
	zStart->setText( "" );
	zStart->setMaxLength( 32767 );
	zStart->setEchoMode( QLineEdit::Normal );
	zStart->setFrame( TRUE );

	QLabel* Label_16;
	Label_16 = new QLabel( this, "Label_16" );
	Label_16->setMinimumSize( 30, 30 );
	Label_16->setMaximumSize( 30, 30 );
	Label_16->setText( "End:" );
	Label_16->setAlignment( 289 );
	Label_16->setMargin( -1 );

	zEnd = new QLineEdit( this, "LineEdit_13" );
	zEnd->setMinimumSize( 90, 30 );
	zEnd->setMaximumSize( 32767, 30 );
	zEnd->setText( "" );
	zEnd->setMaxLength( 32767 );
	zEnd->setEchoMode( QLineEdit::Normal );
	zEnd->setFrame( TRUE );

    QLabel* Label_22;
	Label_22 = new QLabel( this, "Label_22" );
	Label_22->setMinimumSize( 20, 20 );
	Label_22->setMaximumSize( 20, 20 );
	Label_22->setText( "X" );
	Label_22->setAlignment( 289 );
	Label_22->setMargin( -1 );

    QLabel* Label_23;
	Label_23 = new QLabel( this, "Label_23" );
	Label_23->setMinimumSize( 20, 20 );
	Label_23->setMaximumSize( 20, 20 );
	Label_23->setText( "Y" );
	Label_23->setAlignment( 289 );
	Label_23->setMargin( -1 );
    
	QLabel* Label_7;
	Label_7 = new QLabel( this, "Label_7" );
	Label_7->setMinimumSize( 80, 30 );
	Label_7->setMaximumSize( 80, 30 );
	Label_7->setText( "X Label:" );
	Label_7->setAlignment( 289 );
	Label_7->setMargin( -1 );

	xLabel = new QLineEdit( this, "LineEdit_7" );
	xLabel->setMinimumSize( 220, 30 );
	xLabel->setMaximumSize( 32767, 30 );
	xLabel->setText( "" );
	xLabel->setMaxLength( 32767 );
	xLabel->setEchoMode( QLineEdit::Normal );
	xLabel->setFrame( TRUE );

    XLabelOffset_X = new QLineEdit( this, "LineEdit_15" );
	XLabelOffset_X->setMinimumSize( 40, 30 );
	XLabelOffset_X->setMaximumSize( 32767, 30 );
	XLabelOffset_X->setText( "" );
	XLabelOffset_X->setMaxLength( 32767 );
	XLabelOffset_X->setEchoMode( QLineEdit::Normal );
	XLabelOffset_X->setFrame( TRUE );

	XLabelOffset_Y = new QLineEdit( this, "LineEdit_16" );
	XLabelOffset_Y->setMinimumSize( 40, 30 );
	XLabelOffset_Y->setMaximumSize( 32767, 30 );
	XLabelOffset_Y->setText( "" );
	XLabelOffset_Y->setMaxLength( 32767 );
	XLabelOffset_Y->setEchoMode( QLineEdit::Normal );
	XLabelOffset_Y->setFrame( TRUE );
    
	QLabel* Label_8;
	Label_8 = new QLabel( this, "Label_8" );
	Label_8->setMinimumSize( 80, 30 );
	Label_8->setMaximumSize( 80, 30 );
	Label_8->setText( "Y Label:" );
	Label_8->setAlignment( 289 );
	Label_8->setMargin( -1 );
    
	yLabel = new QLineEdit( this, "LineEdit_6" );
	yLabel->setMinimumSize( 220, 30 );
	yLabel->setMaximumSize( 32767, 30 );
	yLabel->setText( "" );
	yLabel->setMaxLength( 32767 );
	yLabel->setEchoMode( QLineEdit::Normal );
	yLabel->setFrame( TRUE );

	YLabelOffset_X = new QLineEdit( this, "LineEdit_17" );
	YLabelOffset_X->setMinimumSize( 40, 30 );
	YLabelOffset_X->setMaximumSize( 32767, 30 );
	YLabelOffset_X->setText( "" );
	YLabelOffset_X->setMaxLength( 32767 );
	YLabelOffset_X->setEchoMode( QLineEdit::Normal );
	YLabelOffset_X->setFrame( TRUE );

	YLabelOffset_Y = new QLineEdit( this, "LineEdit_18" );
	YLabelOffset_Y->setMinimumSize( 40, 30 );
	YLabelOffset_Y->setMaximumSize( 32767, 30 );
	YLabelOffset_Y->setText( "" );
	YLabelOffset_Y->setMaxLength( 32767 );
	YLabelOffset_Y->setEchoMode( QLineEdit::Normal );
	YLabelOffset_Y->setFrame( TRUE );    

	QLabel* Label_9;
	Label_9 = new QLabel( this, "Label_9" );
	Label_9->setMinimumSize( 80, 30 );
	Label_9->setMaximumSize( 80, 30 );
	Label_9->setText( "Z Label:" );
	Label_9->setAlignment( 289 );
	Label_9->setMargin( -1 );
    
    zLabel = new QLineEdit( this, "LineEdit_5" );
	zLabel->setMinimumSize( 220, 30 );
	zLabel->setMaximumSize( 32767, 30 );
	zLabel->setText( "" );
	zLabel->setMaxLength( 32767 );
	zLabel->setEchoMode( QLineEdit::Normal );
	zLabel->setFrame( TRUE );

	ZLabelOffset_X = new QLineEdit( this, "LineEdit_19" );
	ZLabelOffset_X->setMinimumSize( 40, 30 );
	ZLabelOffset_X->setMaximumSize( 32767, 30 );
	ZLabelOffset_X->setText( "" );
	ZLabelOffset_X->setMaxLength( 32767 );
	ZLabelOffset_X->setEchoMode( QLineEdit::Normal );
	ZLabelOffset_X->setFrame( TRUE );

	ZLabelOffset_Y = new QLineEdit( this, "LineEdit_20" );
	ZLabelOffset_Y->setMinimumSize( 40, 30 );
	ZLabelOffset_Y->setMaximumSize( 32767, 30 );
	ZLabelOffset_Y->setText( "" );
	ZLabelOffset_Y->setMaxLength( 32767 );
	ZLabelOffset_Y->setEchoMode( QLineEdit::Normal );
	ZLabelOffset_Y->setFrame( TRUE );

    QLabel* Label_21;
	Label_21 = new QLabel( this, "Label_21" );
	Label_21->setMinimumSize( 80, 30 );
	Label_21->setMaximumSize( 80, 30 );
	Label_21->setText( "Title:" );
	Label_21->setAlignment( 289 );
	Label_21->setMargin( -1 );
    
	titleLabel = new QLineEdit( this, "LineEdit_14" );
	titleLabel->setMinimumSize( 220, 30 );
	titleLabel->setMaximumSize( 32767, 30 );
	titleLabel->setText( "" );
	titleLabel->setMaxLength( 32767 );
	titleLabel->setEchoMode( QLineEdit::Normal );
	titleLabel->setFrame( TRUE );

    titleOffset_X = new QLineEdit( this, "LineEdit_21" );
	titleOffset_X->setMinimumSize( 40, 30 );
	titleOffset_X->setMaximumSize( 32767, 30 );
	titleOffset_X->setText( "" );
	titleOffset_X->setMaxLength( 32767 );
	titleOffset_X->setEchoMode( QLineEdit::Normal );
	titleOffset_X->setFrame( TRUE );

	titleOffset_Y = new QLineEdit( this, "LineEdit_22" );
	titleOffset_Y->setMinimumSize( 40, 30 );
	titleOffset_Y->setMaximumSize( 32767, 30 );
	titleOffset_Y->setText( "" );
	titleOffset_Y->setMaxLength( 32767 );
	titleOffset_Y->setEchoMode( QLineEdit::Normal );
	titleOffset_Y->setFrame( TRUE );
    
    QLabel* Label_17;
    Label_17 = new QLabel( this, "Label_17" );
    Label_17->setMinimumSize( 80, 30 );
    Label_17->setMaximumSize( 80, 30 );
    Label_17->setText( "Output:" );
    Label_17->setAlignment( 289 );
    Label_17->setMargin( -1 );   
    
    outputLabel = new QLabel( this, "Label_18" );
    outputLabel->setMinimumSize( 35, 30 );
    outputLabel->setMaximumSize( 32767, 30 );
    {
      QColorGroup normal( QColor( QRgb(0) ), QColor( QRgb(12632256) ),
                          QColor( QRgb(16777215) ), QColor( QRgb(6316128) ),
                          QColor( QRgb(10789024) ),
                          QColor( QRgb(16711680) ), QColor( QRgb(16777215) ) );
      QColorGroup disabled( QColor( QRgb(8421504) ), QColor( QRgb(12632256) ),
                            QColor( QRgb(16777215) ), QColor( QRgb(6316128) ),
                            QColor( QRgb(10789024) ), QColor( QRgb(8421504) ),
                            QColor( QRgb(12632256) ) );
      QColorGroup active( QColor( QRgb(0) ), QColor( QRgb(12632256) ),
                          QColor( QRgb(16777215) ), QColor( QRgb(6316128) ),
                          QColor( QRgb(10789024) ), QColor( QRgb(0) ),
                          QColor( QRgb(16777215) ) );
      QPalette palette( normal, disabled, active );
      outputLabel->setPalette( palette );
      outputLabel->setAutoResize(TRUE);
    }
    outputLabel->setText( "stdout" );
    outputLabel->setAlignment( 289 );
    outputLabel->setMargin( -1 );

    QLabel* Label_19;
    Label_19 = new QLabel( this, "Label_19" );
    Label_19->setMinimumSize( 80, 30 );
    Label_19->setMaximumSize( 80, 30 );
    Label_19->setText( "Terminal:" );
    Label_19->setAlignment( 289 );
    Label_19->setMargin( -1 );

    termLabel = new QLabel( this, "Label_20" );
    termLabel->setMinimumSize( 60, 30 );
    termLabel->setMaximumSize( 32767, 30 );
    {
      QColorGroup normal( QColor( QRgb(0) ), QColor( QRgb(12632256) ),
                          QColor( QRgb(16777215) ), QColor( QRgb(6316128) ),
                          QColor( QRgb(10789024) ), QColor( QRgb(16711680) ),
                          QColor( QRgb(16777215) ) );
      QColorGroup disabled( QColor( QRgb(8421504) ), QColor( QRgb(12632256) ),
                            QColor( QRgb(16777215) ), QColor( QRgb(6316128) ),
                            QColor( QRgb(10789024) ), QColor( QRgb(8421504) ),
                            QColor( QRgb(12632256) ) );
      QColorGroup active( QColor( QRgb(0) ), QColor( QRgb(12632256) ),
                          QColor( QRgb(16777215) ), QColor( QRgb(6316128) ),
                          QColor( QRgb(10789024) ), QColor( QRgb(0) ),
                          QColor( QRgb(16777215) ) );
      QPalette palette( normal, disabled, active );
      termLabel->setPalette( palette );
    }
    termLabel->setText( "x11" );
    termLabel->setMargin( -1 );
    termLabel->setAlignment( 289 );

	QPushButton* PushButton_1;
	PushButton_1 = new QPushButton( this, "PushButton_1" );
	PushButton_1->setMinimumSize( 100, 40 );
	PushButton_1->setMaximumSize( 100, 40 );
	PushButton_1->setText( "Plot" );
	PushButton_1->setAutoRepeat( FALSE );
	PushButton_1->setAutoResize( TRUE );
    PushButton_1->setDefault(TRUE);
    connect( PushButton_1, SIGNAL(clicked()), this, SLOT(plot()) );

	QPushButton* PushButton_4;
	PushButton_4 = new QPushButton( this, "PushButton_4" );
	PushButton_4->setMinimumSize( 100, 30 );
	PushButton_4->setMaximumSize( 100, 30 );
	PushButton_4->setText( "Replot" );
	PushButton_4->setAutoRepeat( FALSE );
	PushButton_4->setAutoResize( FALSE );
    connect(PushButton_4, SIGNAL(clicked()), this, SLOT(replot()));

	QPushButton* PushButton_3;
	PushButton_3 = new QPushButton( this, "PushButton_3" );
	PushButton_3->setMinimumSize( 100, 30 );
	PushButton_3->setMaximumSize( 100, 30 );
    connect( PushButton_3, SIGNAL(clicked()), this, SLOT(xgfeQuit()) );
	PushButton_3->setText( "Quit" );
	PushButton_3->setAutoRepeat( FALSE );
	PushButton_3->setAutoResize( TRUE );
    
    // ------------------------ create layouts

    // main column layout for whole dialog
    QVBoxLayout* mainCol = new QVBoxLayout(this, 5, -1, "mainCol");

    QHBoxLayout* filenameRowLayout = new QHBoxLayout(-1, "filenameRow");
    QHBoxLayout* functionRowLayout= new QHBoxLayout(-1, "functionRow");
    QHBoxLayout* multiCheckboxRowLayout = new QHBoxLayout(-1, "multiCheckboxRow");
    QHBoxLayout* varXRowLayout = new QHBoxLayout(-1, "varXRow");
    QHBoxLayout* varYRowLayout = new QHBoxLayout(-1, "varYRow");
    QHBoxLayout* varZRowLayout = new QHBoxLayout(-1, "varZRow");
    QHBoxLayout* xyLabelRowLayout = new QHBoxLayout(-1, "xyLabelRow");
    QHBoxLayout* xlabelRowLayout = new QHBoxLayout(-1, "xlabelRow");
    QHBoxLayout* ylabelRowLayout = new QHBoxLayout(-1, "ylabelRow");
    QHBoxLayout* zlabelRowLayout = new QHBoxLayout(-1, "zlabelRow");
    QHBoxLayout* titleRowLayout = new QHBoxLayout(-1, "titleRow");
    QHBoxLayout* outputRowLayout = new QHBoxLayout(-1, "outputRow");
    QHBoxLayout* terminalRowLayout = new QHBoxLayout(-1, "terminalRow");
    QHBoxLayout* pushbuttonRowLayout = new QHBoxLayout(-1, "pushbuttonRow");

    // create menubar

	QMenuBar* MenuBar;
	MenuBar = new QMenuBar(this, "MenuBar_2" );
	MenuBar->setMinimumSize( 100, 30 );
	MenuBar->setMaximumSize( 32767, 30 );
	MenuBar->setFrameStyle( 34 );
	MenuBar->setLineWidth( 2 );

    // file menu
    file = new QPopupMenu;
    file->insertItem("&Open", this, SLOT(dataFileOpen()));
    file->insertSeparator();
    file->insertItem("&Save Gnuplot", this, SLOT(save()));
    file->insertItem("&Load Gnuplot", this, SLOT(load()));
    file->insertSeparator();
    file->insertItem("S&ave Xgfe", this, SLOT(saveXgfe()));
    file->insertItem("Loa&d Xgfe", this, SLOT(loadXgfe()));
    file->insertSeparator();
    file->insertItem("&Raw Gnu", this, SLOT(rawGnuInput()));
    file->insertItem("&Plot", this, SLOT(plot()));
    file->insertItem("R&eplot", this, SLOT(replot()));
    file->insertSeparator();
    file->insertItem("&Quit", this, SLOT(xgfeQuit()));

    // file plotting style popup menu
    fileStyle = new QPopupMenu;
    file_p_id = fileStyle->insertItem("&Points", this, SLOT(setFilePoints()));
    file_l_id = fileStyle->insertItem("&Lines", this, SLOT(setFileLines()));
    file_lp_id = fileStyle->insertItem("Li&nespoints", this, SLOT(setFileLinesPoints()));
    file_i_id = fileStyle->insertItem("&Impulses", this, SLOT(setFileImpulses()));
    file_d_id = fileStyle->insertItem("&Dots", this, SLOT(setFileDots()));
    file_s_id = fileStyle->insertItem("S&teps", this, SLOT(setFileSteps()));
    file_fs_id = fileStyle->insertItem("&Fsteps", this, SLOT(setFileFsteps()));
    file_hs_id = fileStyle->insertItem("&Histeps", this, SLOT(setFileHisteps()));
    file_eb_id = fileStyle->insertItem("&Errorbars", this, SLOT(setFileErrorbars()));
    file_xeb_id = fileStyle->insertItem("&Xerrorbars", this, SLOT(setFileXerrorbars()));
    file_yeb_id = fileStyle->insertItem("&Yerrorbars", this, SLOT(setFileYerrorbars()));
    file_xyeb_id = fileStyle->insertItem("Xye&rrorbars", this, SLOT(setFileXyerrorbars()));
    file_b_id = fileStyle->insertItem("&Boxes", this, SLOT(setFileBoxes()));
    file_be_id = fileStyle->insertItem("B&oxerrorbars", this, SLOT(setFileBoxerrorbars()));
    file_bxye_id = fileStyle->insertItem("Boxxyerrorbar&s", this, SLOT(setFileBoxxyerrorbars()));
    file_fin_id = fileStyle->insertItem("Fin&ancebars", this, SLOT(setFileFinancebars()));
    file_cs_id = fileStyle->insertItem("&Candlesticks", this, SLOT(setFileCandlesticks()));
    fileStyle->setCheckable(TRUE);
    fileStyle->setItemChecked(file_p_id, TRUE);

    // function plotting style popup menu
    funcStyle = new QPopupMenu;
    func_p_id = funcStyle->insertItem("&Points", this, SLOT(setFuncPoints()));
    func_l_id = funcStyle->insertItem("&Lines", this, SLOT(setFuncLines()));
    func_lp_id = funcStyle->insertItem("Li&nespoints", this, SLOT(setFuncLinesPoints()));
    func_i_id = funcStyle->insertItem("&Impulses", this, SLOT(setFuncImpulses()));
    func_d_id = funcStyle->insertItem("&Dots", this, SLOT(setFuncDots()));
    func_s_id = funcStyle->insertItem("S&teps", this, SLOT(setFuncSteps()));
    func_eb_id = funcStyle->insertItem("&Errorbars", this, SLOT(setFuncErrorbars()));
    func_b_id = funcStyle->insertItem("&Boxes", this, SLOT(setFuncBoxes()));
    funcStyle->setCheckable(TRUE);
    funcStyle->setItemChecked(func_l_id, TRUE);

    // file plotting type menu
    filePlotType = new QPopupMenu();
    file2d_id = filePlotType->insertItem("&2D", this, SLOT(setFilePlotType2d()));
    file3d_id = filePlotType->insertItem("&3D", this, SLOT(setFilePlotType3d()));
    filePlotType->setCheckable(TRUE);
    filePlotType->setItemChecked(file2d_id, TRUE);

    // function plotting type menu
    funcPlotType = new QPopupMenu();
    func2d_id = funcPlotType->insertItem("&2D", this, SLOT(setFuncPlotType2d()));
    func3d_id = funcPlotType->insertItem("&3D", this, SLOT(setFuncPlotType3d()));
    funcPlotType->setCheckable(TRUE);
    funcPlotType->setItemChecked(func2d_id, TRUE);


    // terminal menu
    terminals = new QPopupMenu;
    bfig_t_id = terminals->insertItem("&bfig", this, SLOT(setTermBfig()));
    corel_t_id = terminals->insertItem("&corel", this, SLOT(setTermCorel()));
    dxf_t_id = terminals->insertItem("&dxf", this, SLOT(setTermDxf()));
    eepic_t_id = terminals->insertItem("&eepic", this, SLOT(setTermEepic()));
    emtex_t_id = terminals->insertItem("e&mtex", this, SLOT(setTermEmtex()));
    fig_t_id = terminals->insertItem("&fig", this, SLOT(setTermFig()));
    latex_t_id = terminals->insertItem("&latex", this, SLOT(setTermLatex()));
    pbm_t_id = terminals->insertItem("&pbm", this, SLOT(setTermPbm()));
    ps_t_id = terminals->insertItem("p&ostscript", this, SLOT(setTermPostscript()));
    pslatex_t_id = terminals->insertItem("psl&atex", this, SLOT(setTermPslatex()));
    pstricks_t_id = terminals->insertItem("pstric&ks", this, SLOT(setTermPstricks()));
    table_t_id = terminals->insertItem("&table", this, SLOT(setTermTable()));
    texdraw_t_id = terminals->insertItem("texdra&w", this, SLOT(setTermTexdraw()));
    tgif_t_id = terminals->insertItem("t&gif", this, SLOT(setTermTgif()));
    tpic_t_id = terminals->insertItem("tp&ic", this, SLOT(setTermTpic()));
    x11_t_id = terminals->insertItem("&x11", this, SLOT(setTermX11()));
    terminals->setCheckable(TRUE);
    terminals->setItemChecked(x11_t_id, TRUE);

    output = ""; // initialize output to empty (stdout)

    // datafile menu
    QPopupMenu* datafileOpMenu = new QPopupMenu;
    datafileOpMenu->insertItem("&Type", filePlotType);
    datafileOpMenu->insertItem("&Style", fileStyle);
    datafileOpMenu->insertItem("&Legend Title",this, SLOT(setFileLegendTitle()));
    datafileOpMenu->insertItem("&Modifiers", this, SLOT(getFileOptions()) );
    datafileOpMenu->insertItem("&Filtering", this, SLOT(setFileFilter()));

    // functions menu
    QPopupMenu* funcOpMenu = new QPopupMenu;
    funcOpMenu->insertItem("&Type",funcPlotType);
    funcOpMenu->insertItem("&Style",funcStyle );
    funcOpMenu->insertItem("&Legend Title", this, SLOT(setFuncLegendTitle()));

    // option menu
    options = new QPopupMenu;
    options->insertItem("&Datafile", datafileOpMenu);
    options->insertItem("&Function", funcOpMenu);
    options->insertSeparator();
    options->insertItem("&Terminal", terminals);
    options->insertItem("&Output", this, SLOT(getOutput()));
    options->insertItem("&Reset Output", this, SLOT(resetOutput()));
    options->insertItem("Plot S&ize", this, SLOT(setPlotSize()));
    options->insertItem("Reset Si&ze", this, SLOT(resetSize()));
    options->insertItem("&Legend", this, SLOT(getLegendOps()));
    options->insertItem("Lo&g Scale", this, SLOT(setLogScaleOptions()));
    options->insertItem("&Bar Size", this, SLOT(setBarOptions()));
    options->insertItem("Reset B&ar Size", this, SLOT(resetBarOptions()));
    options->insertItem("Box &Width", this, SLOT(setBoxWidthOption()));
    options->insertItem("Reset Box Wi&dth", this, SLOT(resetBoxWidthOption()));
    options->insertItem("Ti&cs", this, SLOT(setTicsOptions()));
        
    // advanced menu
    QPopupMenu* advanced = new QPopupMenu();
    advanced->insertItem("&Multiple Files", this,SLOT(getMultiFile()));
    advanced->insertItem("M&ultiple Functions", this, SLOT(getMultiFunction()));
    advanced->insertItem("&Curve Fitting", this, SLOT(getCurveFit()));
    
    // help menu
    QPopupMenu* help = new QPopupMenu;
    help->insertItem("&About", this, SLOT(showAbout()));

    MenuBar->insertItem("&File", file);
    MenuBar->insertItem("&Options", options);
    MenuBar->insertItem("&Advanced", advanced);
    MenuBar->insertItem("&Help",help);

    // ----------- assemble layouts and widgets

    mainCol->setMenuBar(MenuBar);
    mainCol->addLayout(filenameRowLayout, 0);
    filenameRowLayout->addWidget(filenameCB, 0);
    filenameRowLayout->addWidget(filenameEdit, 0);

    mainCol->addLayout(functionRowLayout, 0);
    functionRowLayout->addWidget(functionCB, 0);
    functionRowLayout->addWidget(functionEdit, 0);
      
    mainCol->addLayout(multiCheckboxRowLayout,0);
    multiCheckboxRowLayout->addSpacing(80);
    multiCheckboxRowLayout->addWidget(multiFileCheckbox, 0);
    multiCheckboxRowLayout->addStretch(1);
    multiCheckboxRowLayout->addWidget(multiFuncCheckbox, 0);

    mainCol->addLayout(varXRowLayout, 0);
    varXRowLayout->addWidget(Label_4, 0);
    varXRowLayout->addWidget(varX, 0);
    varXRowLayout->addStretch(1);
    varXRowLayout->addWidget(Label_5, 0);
    varXRowLayout->addWidget(xStart, 0);
    varXRowLayout->addStretch(1);
    varXRowLayout->addWidget(Label_6, 0);
    varXRowLayout->addWidget(xEnd, 0);

    mainCol->addLayout(varYRowLayout, 0);
    varYRowLayout->addWidget(Label_10, 0);
    varYRowLayout->addWidget(varY, 0);
    varYRowLayout->addStretch(1);
    varYRowLayout->addWidget(Label_12, 0);
    varYRowLayout->addWidget(yStart, 0);
    varYRowLayout->addStretch(1);
    varYRowLayout->addWidget(Label_13, 0);
    varYRowLayout->addWidget(yEnd, 0);
    
    mainCol->addLayout(varZRowLayout, 0);
    varZRowLayout->addWidget(Label_14, 0);
    varZRowLayout->addSpacing(47);
    varZRowLayout->addStretch(1);
    varZRowLayout->addWidget(Label_15, 0);
    varZRowLayout->addWidget(zStart, 0);
    varZRowLayout->addStretch(1);
    varZRowLayout->addWidget(Label_16, 0);
    varZRowLayout->addWidget(zEnd, 0);

    mainCol->addLayout(xyLabelRowLayout,0);
    xyLabelRowLayout->addSpacing(330);
    xyLabelRowLayout->addStretch(1);
    xyLabelRowLayout->addWidget(Label_22,0);
    xyLabelRowLayout->addSpacing(14);
    xyLabelRowLayout->addStretch(1);
    xyLabelRowLayout->addWidget(Label_23,0);
    xyLabelRowLayout->addStretch(1);

    mainCol->addLayout(xlabelRowLayout,0);
    xlabelRowLayout->addWidget(Label_7,0);
    xlabelRowLayout->addWidget(xLabel,0);
    xlabelRowLayout->addWidget(XLabelOffset_X,0);
    xlabelRowLayout->addWidget(XLabelOffset_Y,0);

    mainCol->addLayout(ylabelRowLayout,0);
    ylabelRowLayout->addWidget(Label_8,0);
    ylabelRowLayout->addWidget(yLabel,0);
    ylabelRowLayout->addWidget(YLabelOffset_X,0);
    ylabelRowLayout->addWidget(YLabelOffset_Y,0);

    mainCol->addLayout(zlabelRowLayout,0);
    zlabelRowLayout->addWidget(Label_9,0);
    zlabelRowLayout->addWidget(zLabel,0);
    zlabelRowLayout->addWidget(ZLabelOffset_X,0);
    zlabelRowLayout->addWidget(ZLabelOffset_Y,0);

    mainCol->addLayout(titleRowLayout,0);
    titleRowLayout->addWidget(Label_21,0);
    titleRowLayout->addWidget(titleLabel,0);
    titleRowLayout->addWidget(titleOffset_X,0);
    titleRowLayout->addWidget(titleOffset_Y,0);

    mainCol->addLayout(outputRowLayout,0);
    outputRowLayout->addWidget(Label_17,0);
    outputRowLayout->addWidget(outputLabel,0);
    outputRowLayout->addStretch(1);

    mainCol->addLayout(terminalRowLayout,0);
    terminalRowLayout->addWidget(Label_19,0);
    terminalRowLayout->addWidget(termLabel,1);
    terminalRowLayout->addStretch(1);

    mainCol->addLayout(pushbuttonRowLayout,0);
    pushbuttonRowLayout->addStretch(1);
    pushbuttonRowLayout->addWidget(PushButton_1,0);
    pushbuttonRowLayout->addStretch(1);
    pushbuttonRowLayout->addWidget(PushButton_4,0);
    pushbuttonRowLayout->addStretch(1);
    pushbuttonRowLayout->addWidget(PushButton_3,0);
    pushbuttonRowLayout->addStretch(1);

    resize(405,513);
    mainCol->activate();
}


xgfeMainData::~xgfeMainData()
{
}

void xgfeMainData::plot()
{
}

void xgfeMainData::replot()
{
}

void xgfeMainData::dataFileOpen()
{
}

void xgfeMainData::save()
{
}

void xgfeMainData::load()
{
}

void xgfeMainData::saveXgfe()
{
}

void xgfeMainData::loadXgfe()
{
}

void xgfeMainData::xgfeQuit()
{
}

void xgfeMainData::setFilePoints()
{
}

void xgfeMainData::setFileLines()
{
}

void xgfeMainData::setFileLinesPoints()
{
}

void xgfeMainData::setFileImpulses()
{
}

void xgfeMainData::setFileDots()
{
}

void xgfeMainData::setFileSteps()
{
}

void xgfeMainData::setFileFsteps()
{
}

void xgfeMainData::setFileHisteps()
{
}

void xgfeMainData::setFileErrorbars()
{
}

void xgfeMainData::setFileXerrorbars()
{
}

void xgfeMainData::setFileYerrorbars()
{
}

void xgfeMainData::setFileXyerrorbars()
{
}

void xgfeMainData::setFileBoxes()
{
}

void xgfeMainData::setFileBoxerrorbars()
{
}

void xgfeMainData::setFileBoxxyerrorbars()
{
}

void xgfeMainData::setFileFinancebars()
{
}

void xgfeMainData::setFileCandlesticks()
{
}

void xgfeMainData::setFuncPoints()
{
}

void xgfeMainData::setFuncLines()
{
}

void xgfeMainData::setFuncLinesPoints()
{
}

void xgfeMainData::setFuncImpulses()
{
}

void xgfeMainData::setFuncDots()
{
}

void xgfeMainData::setFuncSteps()
{
}

void xgfeMainData::setFuncErrorbars()
{
}

void xgfeMainData::setFuncBoxes()
{
}

void xgfeMainData::setFilePlotType2d()
{
}

void xgfeMainData::setFilePlotType3d()
{
}

void xgfeMainData::setFuncPlotType2d()
{
}

void xgfeMainData::setFuncPlotType3d()
{
}

void xgfeMainData::setTermBfig()
{
}

void xgfeMainData::setTermCorel()
{
}

void xgfeMainData::setTermDxf()
{
}

void xgfeMainData::setTermEepic()
{
}

void xgfeMainData::setTermEmtex()
{
}

void xgfeMainData::setTermFig()
{
}

void xgfeMainData::setTermLatex()
{
}

void xgfeMainData::setTermPbm()
{
}

void xgfeMainData::setTermPostscript()
{
}

void xgfeMainData::setTermPslatex()
{
}

void xgfeMainData::setTermPstricks()
{
}

void xgfeMainData::setTermTable()
{
}

void xgfeMainData::setTermTexdraw()
{
}

void xgfeMainData::setTermTgif()
{
}

void xgfeMainData::setTermTpic()
{
}

void xgfeMainData::setTermX11()
{
}

void xgfeMainData::getOutput()
{
  string temp;
  QString f = QFileDialog::getSaveFileName(); // get filename

  if (!f.isEmpty())
  {
    temp = f;
    gnuInt->setOutput(temp);
    outputLabel->setText(f);
  }
}

void xgfeMainData::resetOutput()
{
  gnuInt->setOutput(""); // reset output to empty (stdout)
  outputLabel->setText("stdout");
}

void xgfeMainData::setPlotSize()
{
}

void xgfeMainData::resetSize()
{
  gnuInt->setHorizSize("");
  gnuInt->setVertSize("");
}

void xgfeMainData::showAbout()
{
  QMessageBox::information(0, "Xgfe", "X Gnuplot Front End v2.0\n"
                           "Author: David Ishee\n"
                           "Xgfe homepage: http://von-mises.home.ml.org/xgfe/xgfe.html\n");

}


void xgfeMainData::rawGnuInput()
{
}

void xgfeMainData::getFileOptions()
{
}

void xgfeMainData::getLegendOps()
{
}

void xgfeMainData::getMultiFile()
{
}

void xgfeMainData::getMultiFunction()
{
}

void xgfeMainData::setFileLegendTitle()
{
}

void xgfeMainData::setFuncLegendTitle()
{
}

void xgfeMainData::setLogScaleOptions()
{
}

void xgfeMainData::setFileFilter()
{
}

void xgfeMainData::setBarOptions()
{
}

void xgfeMainData::resetBarOptions()
{
}

void xgfeMainData::getCurveFit()
{
}

void xgfeMainData::setBoxWidthOption()
{
}

void xgfeMainData::resetBoxWidthOption()
{
}

void xgfeMainData::setTicsOptions()
{
}
