c Based on algorithms from the book on
c Numerical Recipes by Press et al.
c All of these routines have been rewritten
c somewhat and are unlikely to work as the
c original routines did.
                                                    
                                                    
                                                    
c KENDALL'S NON-PARAMETRIC TEST OF CORRELATION
c based on algorithm in Numerical Recipes P. 493
        subroutine kendl(xfit, yfit, n)
	include 'robcom'
        real xfit(*), yfit(*)

c square root of two
	parameter (srt = 1.4142136)

	if(n .le. 1)then
		call xtext('NOT ENOUGH POINTS TO CALCULATE STATISTIC!')
		write(tstring, *)'Number of points =', n
		call xtext(tstring)
		return
	end if

        n1 = 0
        n2 = 0
        is = 0
        do 120 j = 1, n - 1
          do 110 k = j + 1, n
            aa1 = xfit(j) - xfit(k)
            aa2 = yfit(j) - yfit(k)
            a12 = aa1 * aa2
            if(a12 .ne. 0.0)then
              n1 = n1 + 1
              n2 = n2 + 1
              if(a12 .gt. 0.0)then
                is = is + 1
              else
                is = is - 1
              end if
            else
              if(aa1 .ne. 0.0) n1 = n1 + 1
              if(aa2 .ne. 0.0) n2 = n2 + 1
            end if
110        continue
120      continue
        t = float(is) / sqrt(float(n1) * float(n2))
        var = (4. * n + 10.) / (9. * n * (n - 1.))
        z = t / sqrt(var)
        prob = erfrc(abs(z)/srt)
        write(tstring,*)'Kendall tau statistic = ',t
	call totext(tstring)
 	call write8(tstring)
        write(tstring,*)'Probability = ',prob
	call totext(tstring)
 	call write8(tstring)
        end
           
C ERROR FUNCTION
c based on algorithm in Numerical Recipes P.164
        function erfrc(xin)
	include 'robcom'
	real xin
	parameter (HALF = 0.5)


        y = abs(xin)
        t1 = 1. / (1. + HALF * y)
        erfrc = t1*exp(-y*y - 1.26551223 + t1 *
     +    (1.00002368 + t1 * (.37409196 +
     +    t1 * (.09678418 + t1 * (-.18628806 + t1 *
     +    (.27886807 + t1 * (-1.13520398 +
     +    t1 * (1.48851587 + t1 * (-.82215223 + t1 *.17087277)))))))))
        if(xin .lt. 0.0) erfrc = 2.0 - erfrc
        end

C MEDIAN OF DATA ARRAY
C based on algorithm in Numerical Recipes P. 461
        subroutine mdian(x, n)
	include	'robcom'
        real x(*)
        parameter(HUGE = 1.0e30, afct = 1.5, amp = 1.5)
	parameter (HALF = 0.5)


        a = HALF * (x(1) + x(n))
        esp = abs(x(n) - x(1))
        ap = HUGE
        am = -HUGE
10      sum = 0.0
        sumx = 0.0
        np = 0
        nm = 0
        xp = HUGE
        xm = -HUGE
        do 110 j = 1, n
          xx = x(j)
          if(xx .ne. a)then
            if(xx .gt. a)then
            np = np + 1
            if(xx .lt. xp)xp = xx
          else if(xx .lt. a)then
            nm = nm+1
            if(xx .gt. xm)xm = xx
          end if
          dum = 1. / (esp + abs(xx - a))
          sum = sum + dum
          sumx = sumx + xx * dum
        end if
110      continue
        if((np - nm) .ge. 2)then
          am = a
          aa = xp + max(0., sumx/sum-a) * amp
          if(aa .gt. ap)aa = HALF*(a+ap)
          esp = afct*abs(aa - a)
          a = aa
          goto 10
        else if((nm - np) .ge. 2)then
          ap = a
          aa = xm + min(0.,sumx/sum-a)*amp
          if(aa .lt. am)aa = HALF * (a + am)
          esp = afct * abs(aa - a)
          a = aa
          goto 10
        else
          if(mod(n,2).eq.0)then
            if(np.eq.nm)then
              xmed = HALF*(xp+xm)
            else if(np.gt.nm)then
              xmed = HALF*(a+xp)
            else
              xmed = HALF*(xm+a)
            end if
          else
            if(np.eq.nm)then
              xmed = a
            else if(np.gt.nm)then
              xmed = xp
            else
              xmed = xm
            end if
          end if
         end if
         write(tstring,*)'Median = ',xmed
	call totext(tstring)
        call write8(tstring)
         end
            
C GAUSSIAN RANDOM NUMBER GENERATOR
C based on algorithm in Numerical Recipes P. 203
      function gasd(dummy)
	include 'robcom'
	integer dummy
      data ist/0/


      if(ist.eq.0)then
10      val1 = 2. * ran1(dummy) - 1.
        val2 = 2. * ran1(dummy) - 1.
        rad = val1 * val1 + val2 * val2
        if(rad .ge. 1.0)goto 10
        fact = sqrt(-2. * log(rad) / rad)
        gst = val1 * fact
        gasd = val2 * fact
        ist = 1
      else
        gasd = gst
        ist = 0
      end if
      end

c Numerical recipes one didn't work (dunno why)
	function ran1(dummy)
	integer*4 dummy
	ran1 = rann(dummy)
	end
	
	
C RAN1: RETURNS UNIFORM RANDOM DEVIATE BETWEEN 0 AND 1
C based on algorithm in Numerical Recipes P.196
      function rann(dummy)
	integer dummy
	include 'robcom'
      real xa(97)

      integer m1, m2, m3
      integer ia1, ia2, ia3
      real rm1, rm2

      parameter(m1 = 259200, ia1 = 7141, ik1 = 54773, rm1 = 1./m1)
      parameter(m2 = 134456, ia2 = 8121, ik2 = 28411, rm2 = 1./m2)
      parameter(m3 = 243000, ia3 = 4561, ik3 = 51349)

      data ifrc/0/


      if(dummy .lt. 0 .or. ifrc .eq. 0)then
        ifrc = 1
        jx1 = mod(ik1-dummy,m1)
        jx1 = mod(ia1*jx1+ik1,m1)
        jx2 = mod(jx1,m2)
        jx1 = mod(ia1*jx1+ik1,m1)
        jx3 = mod(jx1,m3)
        do 110 j = 1,97
          jx1 = mod(ia1*jx1+ik1,m1)
          jx2 = mod(ia2*jx2+ik2,m2)
          xa(j) = (float(jx1) + float(jx2) * rm2) * rm1
110      continue
        dummy = 1
      end if
      jx1 = mod(ia1 * jx1 + ik1,m1)
      jx2 = mod(ia2 * jx2 + ik2,m2)
      jx3 = mod(ia3 * jx3 + ik3,m3)
      j = 1 + (97 * jx3) / m3
      rann = xa(j)
      xa(j) = (float(jx1) + float(jx2) * rm2) * rm1
      end

C CUBIC SPLINE ROUTINE
c  based on algorithm in Numerical Recipes P.88
      subroutine nrspln(x, y, n, yp1, ypn, yout, u)
	include	'robcom'
      real x(*), y(*), yout(*), u(*)
	parameter (HUGE = 0.99e+30)
	parameter (HALF = 0.5)


      if(yp1 .gt. HUGE)then
        yout(1) = 0.0
        u(1) = 0.0
      else
        yout(1) = -HALF
        u(1) = (3./(x(2)-x(1)))*((y(2)-y(1))/(x(2)-x(1))-yp1)
      end if
      do 110 i = 2, n - 1
        sig = (x(i)-x(i-1))/(x(i+1)-x(i-1))
        p = sig*yout(i-1) + 2.
        yout(i) = (sig-1.)/p
        u(i) = (6.*((y(i+1)-y(i))/(x(i+1)-x(i))-(y(i)-y(i-1))
     +/(x(i)-x(i-1)))/(x(i+1)-x(i-1))-sig*u(i-1))/p
110    continue

      if(ypn .gt. HUGE)then
        pn = 0.0
        un = 0.0
      else
        pn = HALF
        un = (3.0/(x(n)-x(n-1)))*(ypn-(y(n)-y(n-1))/(x(n)-x(n-1)))
      end if

      yout(n) = (un - pn * u(n - 1))/(pn * yout(n - 1) + 1.0)

      do 120 index = n - 1, 1, -1
        yout(index) = yout(index) * yout(index + 1) + u(index)
120    continue

      end
         
C INTERPOLATE RESULTS OF SPLINE FIT
c based on algorithm in Numerical Recipes P.89
      subroutine splnt(xin, yin, yin2, n, x, y)
	include	'robcom'
      real xin(*), yin(*), yin2(*)
      integer lo, hi


      lo = 1
      hi = n

10    if((hi - lo) .gt. 1)then
        kt = (hi + lo) / 2
        if(xin(kt) .gt. x)then
          hi = kt
        else
          lo = kt
        end if
        goto 10
      end if

      h = xin(hi) - xin(lo)
      if(h .eq. 0.0)then
        call xtext('ERROR: BAD XA INPUT DETECTED IN S/R SPLINT')
        return
      end if

      a = (xin(hi) - x) / h
      b = (x - xin(lo)) / h
      y = a * yin(lo) + b * yin(hi) +
     +		((a * a * a - a) * yin2(lo) + 
     +		(b  * b * b - b) * yin2(hi)) * 
     +		(h * h)/6.0

      end
         

c-----------------------------
c temporary routines
c based on algorithm in Numerical Recipes P.394

      subroutine four1(data,nn,isign)
	include 'robcom'
      real*8 wr,wi,wpr,wpi,wtemp,theta
      dimension data(*)

      n=2*nn
      j=1
      do 11 i=1,n,2
        if(j.gt.i)then
          tempr=data(j)
          tempi=data(j+1)
          data(j)=data(i)
          data(j+1)=data(i+1)
          data(i)=tempr
          data(i+1)=tempi
        endif
        m=n/2
100     if ((m.ge.2).and.(j.gt.m)) then
          j=j-m
          m=m/2
        go to 100
        endif
        j=j+m
11    continue
      mmax=2
200   if (n.gt.mmax) then
        istep=2*mmax
        theta=6.28318530717959d0/(isign*mmax)
        wpr=-2.d0*dsin(0.5d0*theta)**2
        wpi=dsin(theta)
        wr=1.d0
        wi=0.d0
        do 13 m=1,mmax,2
          do 12 i=m,n,istep
            j=i+mmax
            tempr=sngl(wr)*data(j)-sngl(wi)*data(j+1)
            tempi=sngl(wr)*data(j+1)+sngl(wi)*data(j)
            data(j)=data(i)-tempr
            data(j+1)=data(i+1)-tempi
            data(i)=data(i)+tempr
            data(i+1)=data(i+1)+tempi
12        continue
          wtemp=wr
          wr=wr*wpr-wi*wpi+wr
          wi=wi*wpr+wtemp*wpi+wi
13      continue
        mmax=istep
      go to 200
      endif

      end


      subroutine spctrm(p,m,k,ovrlap,w1,w2)
c based on algorithm in Numerical Recipes P.428
      logical ovrlap
      dimension p(m),w1(*),w2(m)

      window(j)=(1.-abs(((j-1)-facm)*facp))
c     window(j)=1.
c     window(j)=(1.-(((j-1)-facm)*facp)**2)
      mm=m+m
      m4=mm+mm
      m44=m4+4
      m43=m4+3
      den=0.
      facm=m-0.5
      facp=1./(m+0.5)
      sumw=0.
      do 11 j=1,mm
        sumw=sumw+window(j)**2
11    continue
      do 12 j=1,m
        p(j)=0.
12    continue
      if(ovrlap)then
c        read (9,*) (w2(j),j=1,m)
      endif
      do 18 kk=1,k
        do 15 joff=-1,0,1
          if (ovrlap) then
            do 13 j=1,m
              w1(joff+j+j)=w2(j)
13          continue
            read (9,*) (w2(j),j=1,m)
            joffn=joff+mm
            do 14 j=1,m
              w1(joffn+j+j)=w2(j)
14          continue
          else
            read (9,*) (w1(j),j=joff+2,m4,2)
          endif
15      continue
        do 16 j=1,mm
          j2=j+j
          w=window(j)
          w1(j2)=w1(j2)*w
          w1(j2-1)=w1(j2-1)*w
16      continue
        call four1(w1,mm,1)
        p(1)=p(1)+w1(1)**2+w1(2)**2
        do 17 j=2,m
          j2=j+j
          p(j)=p(j)+w1(j2)**2+w1(j2-1)**2
     *        +w1(m44-j2)**2+w1(m43-j2)**2
17      continue
        den=den+sumw
18    continue
      den=m4*den
      do 19 j=1,m
        p(j)=p(j)/den
19    continue

      end
