#!/usr/bin/env python

from string import *
from gtk import *
import xmlrpclib
import pysga
import sgagtk
import threading

try:
  import sg
except:
  sg=0

def finish_func(params):
    print "Finished!"
#    try:
    trees=params['trees']
    keys=trees.keys()
    print keys
    for i in range(len(keys)):
      print keys[i]
      print trees[keys[i]].get_selection()
#    except:
#      pass

def io_thread(params):
  params['histos']={}
  params['trees']={}
  dbitems=params['dbitems']
  for i in range(len(params['dbs'])):
    dbname=params['dbs'][i]
    labelstring="http://"+params["host"]+":"+params["port"]+params["path"]+\
    "\n Scanning for histograms:\n"+dbname
    params['dblabel'].set_text(labelstring)
    rpc_params={"bootfile":params["fdname"],
                "dbs":[dbname]}
    
    while events_pending():
      mainiteration(block=FALSE)
    histos=params['dbsvr'].DBServer.getHistos(rpc_params)
    histonames=histos['histonames']
#    dbdict=params['histos']
    params['histos'][dbname]=histonames
    if len(histonames)>0:
       tree=GtkTree()
       params['trees'][dbname]=tree
       tree.set_selection_mode(SELECTION_MULTIPLE)
       tree_items=params['dbitems']
       tree_items[dbname].set_subtree(tree)
       tree.show()
       for j in range(len(histonames)):
         item=GtkTreeItem(label=histonames[j])
         tree.add(item)
         item.show()
       tree_items[dbname].expand()

  labelstring="http://"+params["host"]+":"+params["port"]+params["path"]
  params['dblabel'].set_text(labelstring)
  print params['trees'].keys()

def get_histos(params):
  dbitems=params['dbitems']
  for i in range(len(params['dbs'])):
    dbname=params['dbs'][i]
    print dbname
    rpc_params={"bootfile":params["fdname"],
                "dbs":[dbname]}
    histos=params['dbsvr'].DBServer.getHistos(rpc_params)
    histonames=histos['histonames']
    mainiteration(block=FALSE)
    if len(histonames)>0:
       tree=GtkTree()
       tree_items=params['dbitems']
       tree_items[dbname].set_subtree(tree)
       tree.show()
       for j in range(len(histonames)):
         item=GtkTreeItem(label=histonames[j])
         tree.add(item)
         item.show()
       tree_items[dbname].expand()


def connect(params):
  print "Connecting to"
  print "http://"+params["host"]+":"+params["port"]+params["path"]
  params["dbsvr"] = xmlrpclib.Server("http://"+params["host"]+":"+params["port"]+params["path"])
  dbs=params["dbsvr"].DBServer.getDBs(params["fdname"])
  params['dbs']=dbs
  tree=GtkTree()
  params["tree_item"].set_subtree(tree)
  tree.show()

  params['dbitems']={}
  dbitems=params['dbitems']
  for i in range(len(dbs)):
    item=GtkTreeItem(label=dbs[i])
    dbitems[dbs[i]]=item
    tree.add(item)
    item.show()
  return tree

def build_object_page((params,page_box)):
  vbox=GtkVBox()
  page_box.pack_start(vbox)
  vbox.set_homogeneous(FALSE)
  input=params['input']
  params['host']=input['host'].get_text()
  params['path']=input['path'].get_text()
  params['port']=input['port'].get_text()
  params['fdname']=input['fdname'].get_text()

  labelstring="http://"+params["host"]+":"+params["port"]+params["path"]
  dblabel=GtkLabel(labelstring)
  params['dblabel']=dblabel
  vbox.pack_start(dblabel,expand=FALSE,fill=FALSE,padding=5)
  vbox.pack_start(GtkHSeparator(),expand=FALSE,fill=FALSE,padding=5)
  swin=GtkScrolledWindow()
  swin.set_policy(POLICY_AUTOMATIC,POLICY_AUTOMATIC)
  swin.show() 
  vbox.pack_start(swin,padding=5)

  tree=GtkTree()
  swin.add_with_viewport(tree)
  tree.show()

  tree_item=GtkTreeItem(label=params["fdname"])
  params["tree_item"]=tree_item
  tree.append(tree_item)
  tree_item.show()

  connect(params)
  tree_item.expand()

# Threads didn't quite work out...
#  mythread=threading.Thread(target=io_thread,args=[params])
#  print "starting thread"
#  params['threadname']=mythread.getName()
#  mythread.setDaemon(1)
#  mythread.start()
#  mythread.join()
#  print "after thread"

  vbox.show_all()
  idle_add(io_thread,(params))

  return vbox

def init_page((params,page_box)):
  connect_vbox=GtkVBox()
  page_box.pack_start(connect_vbox)
  frontpage=connect_vbox
  table = GtkTable(3, 2, FALSE)
  table.set_col_spacings(10)
  table.set_row_spacings(5) 
  connect_vbox.pack_start(table,expand=TRUE,fill=TRUE,padding=5)
  input=params["input"]
  input['host']=GtkEntry()
  input['path']=GtkEntry()
  input['port']=GtkEntry()
  input['fdname']=GtkEntry()
  
  for i in range(len(input)):
    table.attach(GtkLabel(input.keys()[i]), 0, 1, i, i+1,yoptions=0,xpadding=5,xoptions=0)
    table.attach(input.values()[i], 1, 2,i,i+1,yoptions=0,xpadding=5,xoptions=EXPAND|FILL)

  input['host'].set_text(params["host"])
  input['path'].set_text(params["path"])
  input['port'].set_text(params["port"])
  input['fdname'].set_text(params["fdname"])

  connect_vbox.add(GtkHSeparator())
  hbox=GtkHBox()
  connect_vbox.set_spacing(5)
  connect_vbox.pack_end(hbox,fill=FALSE,expand=FALSE,padding=5)
  connect_vbox.show_all()
  return connect_vbox


def clarens_init():
  params={
#These are compulsory
  "funcs":[init_page,build_object_page],
  "finish":finish_func,

#This is optional
  "labels":["Connection","Objects"],

#Some of the data we want to pass to out page constructor 
  "host":"localhost",
  "port":"80",
  "path":"/cgi-bin/DBServer",
  "fdname":"/home2/myoofd/ORCATEST.boot",
  "dbs":[],
  "dbsvr":0,
  "treepage":0,
  "frontpage":0,
  "tree_item":0,
  "db_label":"",
  "input": {'host': 0,
           'path': 0,
           'port': 0,
           'fdname': 0}
  }

  wizard=sgagtk.SGwizard(params,tabs=TRUE)
  
  
if not sg:
  wizard=sgagtk.SGwizard(params,tabs=TRUE)
  mainloop()
else:
 sg.register_plugin("Clarens remote analysis","Worksheet:",clarens_init)

