#ifndef PYTHON_CONFIG_H
#define PYTHON_CONFIG_H


#include <Python.h>
#include <glib.h>

typedef enum {
     END_CONFIG,
     DIALOG_SEP,
     NOTEBOOK_START,
     NOTEBOOK_END,
     PAGE_SEP,
     FRAME_START,
     FRAME_END,
	DICT_LIST,
	DICT_PATH_LIST,
	DICT_INT,
	DICT_INT_BOUND,
	DICT_DOUBLE,
	DICT_DOUBLE_BOUND,
        DICT_TOGGLE,
        DICT_MENU,
} config_id;


typedef struct _sg_config_info{
	config_id type;
	gint num;
        gpointer data_in;
        gpointer data_out;
        gchar *name;
} sg_config_info;

typedef struct _sg_menu_info
{       gchar **options;
        gpointer init_func;
        gpointer apply_func;
} sg_menu_info;

typedef struct _sg_bound_int_info
{       gfloat min;
        gfloat max;
        gpointer init_func;
        gpointer apply_func;
} sg_bound_int_info;

#ifdef WITH_GNOME
void config_apply(gpointer data, GtkWidget *widget);
#else
void config_apply(GtkWidget *widget, gpointer data);
#endif
void config_ok(gpointer data, GtkWidget *widget);

void python_config_dialog(GtkWidget *widget, gpointer data);
void sg_create_config_dialog(sg_config_info *var_info,
     gpointer apply_callback,gpointer ok_callback);

void sg_set_module_paths(PyObject *dict);

#endif

