/* This is the interface to the python interpreter
   Originally from the now defunct gnocci project.
   C. Steenberg 15 May 2000
*/

#include <gdk/gdk.h>
#include <glib.h>
#include <gtkextra/gtkextra.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include <Python.h>
#include <grammar.h>
#include <node.h>
#include <parsetok.h>
#include <errcode.h>
#include <compile.h>
#include <eval.h>
#include <marshal.h>
#include "../main.h"
#include "python_main.h"

gchar def_safe_modules[][80]={"audioop", "array","binascii", "cmath","errno", 
      "imageop","marshal", "math", "md5", "operator","parser", "regex", "rotor", 
      "select","strop", "struct","time","gtk","_gtk","GDK","GTK","gnome","GNOME","pickle","Numeric","pysga",""};
gchar def_safe_os[][80]={"error", "fstat","listdir", "lstat", "readlink",
      "stat","times", "uname", "getpid", "getppid","getcwd","getuid", "getgid",
      "geteuid","getegid","name","environ","ctermid","getgroups","getlogin",
      "getpgrp","getpid","getppid","strerror","umask","uname","fpathconf","isatty",
      "times","confstr","confstr_names","sysconf","sysconf_names","curdir",
      "pardir","sep","altsep","pathsep","defpath","linesep","path","_get_exports_list","_names",""};
gchar def_safe_sys[][80]={"argv","ps1","ps2", "copyright", "version", "platform","exit",
      "maxint","stderr","stdout","stdin","byteorder","builtin_module_names",
      "executable","exitfunc","getrefcount","getrecursionlimit","maxint","platform",
      "prefix","version_info","path","excepthook","displayhook",""};

module_opts comp_imports[]={
 {"os",SG_MODULE_LOAD_MAIN|SG_MODULE_LOAD_REQ},
 {"sys",SG_MODULE_LOAD_MAIN|SG_MODULE_LOAD_REQ},
 {"Numeric",SG_MODULE_LOAD_SYMBOLS},
 {"pickle",SG_MODULE_LOAD_MAIN|SG_MODULE_LOAD_REQ},
 {"gtk",SG_MODULE_LOAD_MAIN}, /* These two modules are not absolutely required*/
 {"pysga",SG_MODULE_LOAD_SYMBOLS}, /* and may be loaded from non-standard places */
  {NULL,0}};

extern grammar _PyParser_Grammar; /* From Python/graminit.c */
extern pid_t child_pid;

static PyObject *sg_import(PyObject *self, PyObject *args);
gint python_error_report(PyObject *object);
gint sg_load_default_modules2(void);

PyObject *default_paths;

/* Remember to increase the size of save_vars and save_obj when adding to this list*/
gchar *save_vars_names[]={"sg_safe_modules","sg_safe_os","sg_safe_sys","sg_import_modules","sg_canvas_labels_pos",
                          "sg_canvas_labels_width","sg_save_freq","sg_compression_level","sg_module_paths",""};
gint save_vars_flags[SG_OPTIONS_END+1];

gint python_init(gchar *progname)
{   PyObject *module_object, *module_dict, *keys, *functions, *key_name, *object,
             *full, *empty, *items, *string;
    gint i,flag,size;
    gchar temp[200],*name,*homedir; 

    PyObject *av;
    int argc;
    char **argv;


    Py_SetProgramName(progname);
    Py_Initialize();
    import_array();
    sg_report_python_error=TRUE;
    for (i=0;strlen(save_vars_names[i])>0;i++)
      { save_vars[i]=save_vars_names[i];
        save_obj[i]=NULL;
        save_vars_flags[i]=FALSE;
      }
    save_vars[i]=save_vars_names[i]; /* The sentinel */
    SG_IMPORT_MODULES=PyDict_New();
    
    main_o=PyImport_ImportModule("__main__");
    builtin_o=PyImport_AddModule("__builtin__");
    sys_o=PyImport_ImportModule ("sys");
    sys_o=PyImport_AddModule ("sys");    
    os_o=PyImport_ImportModule ("os");
    os_o=PyImport_AddModule ("os");    

    main_dict=PyModule_GetDict(main_o);
    sys_dict=PyModule_GetDict(sys_o);
    os_dict=PyModule_GetDict(os_o);
    config_dict=PyDict_New();    
    builtin_dict=PyModule_GetDict(builtin_o);

    PyDict_SetItemString (main_dict, "os", os_o);
    PyDict_SetItemString (main_dict, "sys", sys_o);


/* sg module init */
    init_sg_python();
    sg_o=PyImport_AddModule("sg");
    sg_dict=PyModule_GetDict(sg_o);
    PyDict_SetItemString (main_dict, "sg", sg_o);  
/* gtk.py requires this*/
    full=PyList_New (1);    
    string=PyString_FromString (progname);
    PyList_SET_ITEM (full, 0, string);
    PyDict_SetItemString (sys_dict, "argv",full);
    default_paths=PyDict_GetItemString (sys_dict, "path");

/* Import compulsory modules, and put their names in the main dict */
    full=PyList_New (1);    
    string=PyString_FromString ("*");
    PyList_SET_ITEM (full, 0, string);

    for (i=0;comp_imports[i].name!=NULL;i++){
     if (comp_imports[i].flags&SG_MODULE_LOAD_REQ){
         module_object=PyImport_ImportModuleEx (comp_imports[i].name, main_dict, sg_dict, full);
         if (!module_object) continue;
         python_error_report(module_object);
   
         if (comp_imports[i].flags&SG_MODULE_LOAD_SYMBOLS){
             g_snprintf(temp,200,"from %s import *",comp_imports[i].name);
             object=PyRun_String (temp, Py_file_input, main_dict, sg_dict);
             python_error_report(object);
         }
         else if (comp_imports[i].flags&SG_MODULE_LOAD_MAIN)
             PyDict_SetItemString (main_dict, comp_imports[i].name, module_object);
     }

      PyDict_SetItemString(SG_IMPORT_MODULES,comp_imports[i].name,
       PyInt_FromLong ((long) comp_imports[i].flags));
    }

/* Enable this to prevent macro virii

    PyDict_SetItemString (main_dict, "__import__", PyDict_GetItemString (sg_dict, "__import__"));
    PyDict_SetItemString (builtin_dict, "__import__", PyDict_GetItemString (sg_dict, "__import__"));*/


   homedir=getenv("HOME");
   rcfile=g_new0(gchar,strlen(homedir)+6);
   g_snprintf(rcfile,200,"%s/.sga",homedir);
   flag=unpickle_file(rcfile, main_dict, sg_dict, save_vars);

   if (flag>0)
       for (i=0;save_vars[i]!=NULL;i++)
           if (save_vars_flags[i]==TRUE)
               save_obj[i]=PyDict_GetItemString (sg_dict, save_vars[i]);
           else save_obj[i]=PyDict_New();

   /* Set up default values when rc file read fails */
   else
   {    /* SG_IMPORT_MODULES is an exception, it is already set up above */
/* Set up the safe modules list */
       if (!save_vars_flags[SG_SAFE_MODULES_N]){
         SG_SAFE_MODULES=PyDict_New();
         for (i=0;strlen(def_safe_modules[i])>0;i++)
           PyDict_SetItemString(SG_SAFE_MODULES,def_safe_modules[i],Py_None);
       }
/* Set up the safe sys methods list */
       if (!save_vars_flags[SG_SAFE_SYS_N]){
         SG_SAFE_SYS=PyDict_New();
         for (i=0;strlen(def_safe_sys[i])>0;i++)
           PyDict_SetItemString(SG_SAFE_SYS, def_safe_sys[i],Py_None);
       }
/* Set up the safe os methods list */
       if (!save_vars_flags[SG_SAFE_OS_N]){
         SG_SAFE_OS=PyDict_New();
         for (i=0;strlen(def_safe_os[i])>0;i++)
          PyDict_SetItemString(SG_SAFE_OS, def_safe_os[i],Py_None);
       }
/* Canvas labels positions */
       if (!save_vars_flags[SG_CANVAS_LABELS_POS_N]){
           SG_CANVAS_LABELS_POS=PyDict_New();
           PyDict_SetItemString(SG_CANVAS_LABELS_POS, "Pos",PyInt_FromLong ((long) sg_canvas_label_pos));
       }
/* Canvas labels width */
       if (!save_vars_flags[SG_CANVAS_LABELS_WIDTH_N]){
           SG_CANVAS_LABELS_WIDTH=PyDict_New();
           PyDict_SetItemString(SG_CANVAS_LABELS_WIDTH, "Width",PyInt_FromLong ((long) sg_canvas_label_width));
       }

       if (!save_vars_flags[SG_SAVE_N]){
           SG_SAVE=PyDict_New();
           PyDict_SetItemString(SG_SAVE, "Int",PyInt_FromLong ((long) sg_autosave_int));
       }

       if (!save_vars_flags[SG_COMPRESS_N]){
           SG_COMPRESS=PyDict_New();
           PyDict_SetItemString(SG_COMPRESS, "Level",PyInt_FromLong ((long) sg_compress_level));
       }
       if (!save_vars_flags[SG_MOD_PATHS_N]){
           int j;
           PyObject *Items;
           SG_MOD_PATHS=PyDict_New();
           for (j=0;j<PyList_GET_SIZE (default_paths);j++)
               PyDict_SetItem(SG_MOD_PATHS, PyList_GetItem (default_paths,j),Py_None);
           if (!PyDict_GetItemString(SG_MOD_PATHS, PYTHON_MODULE_PATH))
               PyDict_SetItemString(SG_MOD_PATHS, PYTHON_MODULE_PATH,Py_None);
           items=PyDict_Keys(SG_MOD_PATHS);
           PyDict_SetItemString (sys_dict, "path", items);
           Py_XDECREF(items);
       }

   }


       /* Put the object references into the local dictionary */
     for (i=0;save_obj[i];i++)
      PyDict_SetItemString (sg_dict, save_vars[i], save_obj[i]);
     sg_canvas_label_pos=(int)PyInt_AsLong(PyDict_GetItemString(SG_CANVAS_LABELS_POS, "Pos"));
     sg_canvas_label_width=(int)PyInt_AsLong(PyDict_GetItemString(SG_CANVAS_LABELS_WIDTH, "Width"));
     sg_autosave_int=(int)PyInt_AsLong(PyDict_GetItemString(SG_SAVE, "Int"));
     sg_compress_level=(int)PyInt_AsLong(PyDict_GetItemString(SG_COMPRESS, "Level"));

     if (PyDict_Size(SG_MOD_PATHS)==0)
         SG_MOD_PATHS=PyDict_GetItemString (sys_dict, "path");
     else
       sg_set_module_paths(SG_MOD_PATHS);
     if (!PyDict_GetItemString(SG_MOD_PATHS, PYTHON_MODULE_PATH))
         PyDict_SetItemString(SG_MOD_PATHS, PYTHON_MODULE_PATH,Py_None);


/* Now remove naughty functions from sys and os modules */
   def_sys_dict= PyDict_New();
   keys=PyDict_Keys(sys_dict);

   for (i=0;i<PyList_GET_SIZE (keys);i++)
     { key_name=PyList_GetItem (keys,i);
       PyDict_SetItem (def_sys_dict, key_name, PyDict_GetItem (sys_dict, key_name));
/*       if (!PyDict_GetItem(SG_SAFE_SYS,key_name))
         PyDict_DelItem (sys_dict, key_name);*/
     }
   Py_XDECREF(keys);
   def_os_dict= PyDict_New();
   keys=PyDict_Keys(os_dict);

   for (i=0;i<PyList_GET_SIZE (keys);i++)
     { key_name=PyList_GetItem (keys,i);
       PyDict_SetItem (def_os_dict, key_name, PyDict_GetItem (os_dict, key_name));
/*       if (!PyDict_GetItem(SG_SAFE_OS,key_name))
         PyDict_DelItem (os_dict, key_name);*/
     }
   Py_XDECREF(keys);
   pickle_file(rcfile, main_dict, sg_dict, save_vars);
   return(1);
}

gint sg_load_default_modules(void){
    PyObject *keys, *items, *key_name, *module_object,*object,*full,*string;
    int i=0;
    long flag;
    gchar *name,temp[200];

    full=PyList_New (1);    
    string=PyString_FromString ("*");
    PyList_SET_ITEM (full, 0, string);

    keys=PyDict_Keys(SG_IMPORT_MODULES);
    items=PyDict_Items(SG_IMPORT_MODULES);
    for (i=0;i<PyList_GET_SIZE (keys);i++)
    { gchar *name;
      key_name=PyList_GetItem (keys,i);
      name=PyString_AsString (key_name);

      module_object=PyImport_ImportModuleEx (name, main_dict, sg_dict, full);
      python_error_report(module_object);
      if (!module_object) continue;

      Py_INCREF(module_object);
      if (comp_imports[i].flags&SG_MODULE_LOAD_SYMBOLS){
          g_snprintf(temp,200,"from %s import *",name);
          object=PyRun_String (temp, Py_file_input, main_dict, sg_dict);
          python_error_report(object);
          if (module_object)
            PyDict_SetItemString (main_dict, name, module_object);
      }
      else if (comp_imports[i].flags&SG_MODULE_LOAD_MAIN){
          PyDict_SetItemString (main_dict, name, module_object);
      }
    }
    Py_XDECREF(full);
}

gint remove_naughty(PyObject *def_dict,PyObject *mod_dict,PyObject *safe_dict)
{ gint i;
  PyObject *keys, *key_name;

/* First, restore default dict */
   keys=PyDict_Keys(def_dict);

   for (i=0;i<PyList_GET_SIZE (keys);i++)
     { key_name=PyList_GetItem (keys,i);
       PyDict_SetItem (mod_dict, key_name, PyDict_GetItem (def_dict, key_name));
       if (!PyDict_GetItem(safe_dict,key_name))
         PyDict_DelItem (mod_dict, key_name);
     }
   return i;
}


gint pickle_file(gchar *fname, PyObject *globals, PyObject *locals, gchar **symbols)
{ gint i=0;
  FILE *fp;
  PyObject *object, *fo;
  gchar temp[200];

  if (!(fp=fopen(fname,"w"))) return FALSE;
  fo=PyFile_FromFile (fp, "pickle_file", "w", NULL);
  PyDict_SetItemString (sg_dict, "pickle_file", fo);
  g_snprintf(temp,200,"pickler=pickle.Pickler(pickle_file)");
  object=PyRun_String (temp, Py_file_input, globals, locals);
  if (python_error_report(object))
     return FALSE;

  for (i=0;strlen(symbols[i])>0;i++)
   { g_snprintf(temp,200,"pickler.dump(%s)",symbols[i]);
     object=PyRun_String (temp, Py_file_input, globals, locals);
     python_error_report(object);
   }
  g_snprintf(temp,200,"del pickle_file,pickler",symbols[i]);  
  object=PyRun_String (temp, Py_file_input, globals, locals);
  if (python_error_report(object))
   return (FALSE);
  fclose(fp);
  return TRUE; 
}

gint unpickle_file(gchar *fname, PyObject *globals, PyObject *locals, gchar **symbols)
{
  gint i=0;
  FILE *fp;
  PyObject *object, *fo;
  gchar temp[200];

  if (!(fp=fopen(fname,"r"))) return FALSE;
  fo=PyFile_FromFile (fp, "pickle_file", "r", NULL);
  PyDict_SetItemString (sg_dict, "pickle_file", fo);
  g_snprintf(temp,200,"unpickler=pickle.Unpickler(pickle_file)");
  object=PyRun_String (temp, Py_file_input, globals, locals);
  if (!object){
      python_error_report_verbose(object,FALSE,"Cannot load preferences - Restoring defaults.\n\n"
                                  "View verbose error log?",1);
      Py_XDECREF(object);
      fclose(fp);
      Py_XDECREF(fo);
 	return 0;
    }

   for (i=0;strlen(symbols[i])>0;i++)
   {  g_snprintf(temp,200,"%s=unpickler.load()",symbols[i]);
      object=PyRun_String (temp, Py_file_input, globals, locals);
      save_vars_flags[i]=FALSE;
      if (!object){
          python_error_report_verbose(object,FALSE,"Cannot load preferences - Restoring defaults.\n\n"
                                  "View verbose error log?",1);
          Py_XDECREF(object);
          fclose(fp);
          Py_XDECREF(fo);
            return 0;
        }
       else
          save_vars_flags[i]=TRUE;
   }

  g_snprintf(temp,200,"del pickle_file,unpickler",symbols[i]);
  object=PyRun_String (temp, Py_file_input, globals, locals);
  
  fclose(fp);
  Py_XDECREF(object);
  Py_XDECREF(fo);
  return i;

}

gint python_error_report(PyObject *object)
{ 
    if (!object)
      { if (sg_report_python_error)
          create_python_term(NULL,NULL);
        PyErr_Print();
        if (Py_FlushLine())
            PyErr_Clear(); 
        return TRUE;
      }
    return FALSE;
}

gint python_error_report_verbose(PyObject *object,gboolean report, gchar *message, gint type){
    if (!object){
        if (report|| sg_accept_dialog(message,type)==YES_CLICKED){
            create_python_term(NULL,NULL);
            PyErr_Print();
        }
        if (Py_FlushLine())
            PyErr_Clear();
        return TRUE;
    }
    return FALSE;
}

