#ifndef PYTHON_INT_H
#define PYTHON_INT_H
#include <Python.h>


typedef struct _module_opts module_opts;	


struct _module_opts
{  gchar *name;
   gint flags; };	

/* Flags for module loading */
enum {SG_MODULE_LOAD_MAIN = 1 << 0,      /* Load module dict into main dictionary */
      SG_MODULE_LOAD_SYMBOLS = 1 << 1,   /* Load module's symbols into main dictionary */
      SG_MODULE_LOAD_REQ = 1 << 2 }; /* This module is required for normal operation of SG */

gint python_init(gchar *progname);
gint pickle_file(gchar *fname, PyObject *globals, PyObject *locals, gchar **symbols);
gint python_error_report(PyObject *object);
gint unpickle_file(gchar *fname, PyObject *globals, PyObject *locals, gchar **symbols);
gint python_error_report_verbose(PyObject *object,gboolean report, gchar *message, gint type);

PyObject *main_dict, *builtin_dict, *sys_dict, *os_dict, *os_o, *def_os_dict,
         *main_o, *builtin_o, *sys_o, *def_sys_dict, *sg_o, *sg_dict,
         *safe_module_path, *config_dict;

enum {
     SG_SAFE_MODULES_N,
     SG_SAFE_OS_N,
     SG_SAFE_SYS_N,
     SG_IMPORT_MODULES_N,
     SG_CANVAS_LABELS_POS_N,
     SG_CANVAS_LABELS_WIDTH_N,
     SG_SAVE_N,
     SG_COMPRESS_N,
     SG_MOD_PATHS_N,
     SG_OPTIONS_END,
};

/* Variables to be saved between sessions */
gchar *save_vars[SG_OPTIONS_END+1], *rcfile;
PyObject *save_obj[SG_OPTIONS_END+1];

         
/* Define your dict object names here. This is just for convenience */
#define SG_SAFE_MODULES save_obj[SG_SAFE_MODULES_N]
#define SG_SAFE_OS save_obj[SG_SAFE_OS_N]
#define SG_SAFE_SYS save_obj[SG_SAFE_SYS_N]
#define SG_IMPORT_MODULES save_obj[SG_IMPORT_MODULES_N]
#define SG_CANVAS_LABELS_POS save_obj[SG_CANVAS_LABELS_POS_N]
#define SG_CANVAS_LABELS_WIDTH save_obj[SG_CANVAS_LABELS_WIDTH_N]
#define SG_SAVE save_obj[SG_SAVE_N]
#define SG_COMPRESS save_obj[SG_COMPRESS_N]
#define SG_MOD_PATHS save_obj[SG_MOD_PATHS_N]

gboolean sg_report_python_error;
#endif

