/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <math.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gdk/gdk.h>
#include "main.h"
#ifdef WITH_BONOBO
#include <bonobo.h>
#include <liboaf/liboaf.h>
#endif
#include "../pixmaps/sg.xpm"
#include <Python.h>
#include "python/python_main.h"
#include <signal.h>
#ifdef WITH_GDK_IMLIB
#include <gdk_imlib.h>
#endif

GdkPixmap *icon_pixmap;
GdkBitmap *icon_mask;

static gchar *worksheet_name = NULL;
static gchar *plot_name = NULL;
int have_pygtk=FALSE;

#ifdef WITH_GNOME
gint 
main_win_restore_session(void)
{
  gchar id[80];
  gint width,height;

  if(!gui_iconlist) return TRUE;

  g_snprintf(id,80,"/" PACKAGE"/main_window/width=400");
  width = gnome_config_get_int(id);

  g_snprintf(id,80,"/" PACKAGE"/main_window/height=400");
  height = gnome_config_get_int(id);

  gtk_window_set_default_size(GTK_WINDOW(main_window),width,height);

  return TRUE;
}



gint 
main_win_save_session(void)
{ 
  gchar id[80];

  if(!gui_iconlist) return TRUE;

  g_snprintf(id,80,"/" PACKAGE"/main_window/width");
  gnome_config_set_int(id,GTK_WIDGET(main_window)->allocation.width);

  g_snprintf(id,80,"/" PACKAGE"/main_window/height");
  gnome_config_set_int(id,GTK_WIDGET(main_window)->allocation.height);

  return TRUE;
}


static gint 
save_my_session(void)
{
 main_win_save_session();
 gnome_config_sync();
 return TRUE;
}

static gint
save_session (GnomeClient *client, gint phase, GnomeSaveStyle save_style,
              gint is_shutdown, GnomeInteractStyle interact_style,
              gint is_fast, gpointer client_data)
{
  gchar** argv;
  guint argc;
  save_my_session();

  return TRUE;
}

#endif

void
main_quit (GtkWidget *widget)
{
#ifdef WITH_GNOME
  save_my_session();
#endif
  sg_project_close();
  child_died();
  gtk_main_quit();
  sg_exiting=TRUE;
}

void
switch_page(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num)
{
  if(page_num == 0) sg_layer_control_destroy();
}

/*
static void
icon_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  if(event->key.type == 15)
    gtk_window_set_title(GTK_WINDOW(main_window), last_project_filename);
  else if(event->key.type == 14)
      sg_project_set_title();
}
*/

GtkWidget *
build_gui(gchar *my_name)
{
 GtkWidget *top_level;
 GtkWidget *vbox1;
 GtkWidget *hbox1;
 GtkWidget *label1;
 GtkWidget *label2;
 GtkWidget *hb;
 GtkWidget *toolbar;
 GtkWidget *menu_bar;

#ifdef WITH_GNOME
 GnomeClient *client;
 GtkWidget *appbar;
#endif 

 /* Build GUI */
#ifdef WITH_GNOME
 top_level=gnome_app_new (PACKAGE, "SciGraphica");
 client = gnome_master_client ();
 gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
                     GTK_SIGNAL_FUNC (save_session), my_name);

 appbar=gnome_appbar_new(TRUE,TRUE,FALSE);
 gnome_app_set_statusbar (GNOME_APP(top_level),appbar);
#else
 top_level=gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_container_border_width(GTK_CONTAINER(top_level),0);
 gtk_window_set_title(GTK_WINDOW(top_level), "SciGraphica");

 gtk_container_border_width(GTK_CONTAINER(top_level),0);
 gtk_widget_set_usize(top_level, 500, 400);
#endif

 gtk_widget_realize(top_level);
 icon_pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL,
                                                gdk_colormap_get_system(),
                                                &icon_mask, NULL, sg_xpm);
                          
 gdk_window_set_icon(top_level->window, NULL, icon_pixmap, icon_mask);            


 gtk_signal_connect (GTK_OBJECT (top_level), "destroy",
		     GTK_SIGNAL_FUNC (main_quit), NULL);

 vbox1 = gtk_vbox_new(FALSE,0);
 
#ifdef WITH_GNOME
 gnome_app_set_contents(GNOME_APP(top_level),vbox1);
#else
 gtk_container_add(GTK_CONTAINER(top_level),vbox1);
#endif 

 menu_bar = sg_project_build_menu(top_level);
 toolbar = sg_project_build_toolbar(top_level);

 gtk_widget_show(vbox1);

 sg_project_build_popups();

 hbox1=gtk_hbox_new(FALSE,0);
 gtk_container_set_border_width(GTK_CONTAINER(hbox1), 5);
 gtk_box_set_spacing(GTK_BOX(hbox1), 5);
 gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, TRUE, 0);
 gtk_widget_show(hbox1);

 gui_notebook = gtk_notebook_new();
 gtk_box_pack_start(GTK_BOX(hbox1),gui_notebook, TRUE, TRUE,0);
 gtk_widget_show(gui_notebook);

 scrollw1=gtk_scrolled_window_new(NULL, NULL);
 gtk_container_border_width(GTK_CONTAINER(scrollw1),0);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollw1),
				GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
 label1 = gtk_label_new("Worksheets");
 gtk_notebook_append_page(GTK_NOTEBOOK(gui_notebook), scrollw1, label1);
 gtk_widget_show(scrollw1);

 scrollw2=gtk_scrolled_window_new(NULL, NULL);
 gtk_container_border_width(GTK_CONTAINER(scrollw2),0);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollw2),
				GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
 label2 = gtk_label_new("Plots");
 gtk_notebook_append_page(GTK_NOTEBOOK(gui_notebook), scrollw2, label2);
 gtk_widget_show(scrollw2);


 iconlist1 = gtk_icon_list_new(48, sg_canvas_label_pos+1);
 gtk_icon_list_set_text_space(GTK_ICON_LIST(iconlist1), sg_canvas_label_width);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollw1),iconlist1);
 gtk_signal_connect(GTK_OBJECT(iconlist1),"select_icon",
                    (GtkSignalFunc) sg_project_open_worksheet, NULL);

 iconlist2 = gtk_icon_list_new(48, sg_canvas_label_pos+1);
 gtk_icon_list_set_text_space(GTK_ICON_LIST(iconlist2), sg_canvas_label_width);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollw2),iconlist2);
 gtk_signal_connect(GTK_OBJECT(iconlist2),"select_icon",
                    (GtkSignalFunc) sg_project_open_plot, NULL);

 gtk_widget_show(iconlist1);
 gtk_widget_show(iconlist2);

 gtk_widget_show(vbox1);
 
 gtk_signal_connect(GTK_OBJECT(top_level), "delete_event",
                    (GtkSignalFunc)sg_menu_exit, NULL);

 gtk_signal_connect(GTK_OBJECT(gui_notebook), "switch_page",
                    (GtkSignalFunc)switch_page, NULL);

 return(top_level);
}

static void
init_global_vars(int *argc, char ***argv)
{

 /* Initialize global variables */

 delimiter = SG_DELIMITER_UNKNOWN;
 skip_lines = 0;
 rename_worksheets = TRUE;
 rename_columns = FALSE;
 precision_mod = TRUE;

 strncpy(comment_string,"#",80);
 strncpy(block_start,"#",80);
 strncpy(custom_delimiter,"&",80);

 begin_line=1;
 end_line=1;
 blocknum=1;
 read_method=0;
 read_all_lines=1;
 use_custom_delim=0;

 sg_canvas_label_pos=0;
 sg_canvas_label_width=100;

 sg_autosave_int=30;
 sg_compress_level=9;
 sg_units=GTK_PLOT_INCHES;

 last_project_path = g_strdup(g_get_current_dir());
 last_project_filename = g_strdup("untitled.sg");
 last_plot_path = g_strdup(g_get_current_dir());
 last_plot_filename = g_strdup("untitled");
 last_worksheet_path = g_strdup(g_get_current_dir());
 last_worksheet_filename = g_strdup("untitled");
 sg_exiting=FALSE;

/* Have these names been changed from the above defaults? */
 project_name_changed=FALSE;
 plot_name_changed=FALSE;
 worksheet_name_changed=FALSE;

 gui_iconlist = TRUE;
 gui_plot = FALSE;
 gui_worksheet = FALSE;

 if (argc && argv) {
      gint i, j, k;

      for (i = 1; i < *argc;) {
          if (strcmp ("--plot", (*argv)[i]) == 0){

              gui_iconlist = FALSE;
              gui_plot = TRUE;

              (*argv)[i] = NULL;

          } else if (strncmp ("--plot=", (*argv)[i], 8) == 0){

              plot_name = (*argv)[i] + 7;

              if (*plot_name == '=')
                plot_name++;
              else if (i + 1 < *argc) {
                  (*argv)[i] = NULL;
                  i += 1;
                  plot_name = (*argv)[i];
              }
              (*argv)[i] = NULL;

              gui_iconlist = FALSE;
              gui_plot = TRUE;

          } else if (strcmp ("--worksheet", (*argv)[i]) == 0){

              gui_iconlist = FALSE;
              gui_worksheet = TRUE;

              (*argv)[i] = NULL;

          } else if (strncmp ("--worksheet=", (*argv)[i], 13) == 0){

              worksheet_name = (*argv)[i] + 12;

              if (*worksheet_name == '=')
                worksheet_name++;
              else if (i + 1 < *argc) {
                  (*argv)[i] = NULL;
                  i += 1;
                  worksheet_name = (*argv)[i];
              }
              (*argv)[i] = NULL;

              gui_iconlist = FALSE;
              gui_worksheet = TRUE;

          }
          i += 1;
      }
      for (i = 1; i < *argc; i++) {
          for (k = i; k < *argc; k++)
            if ((*argv)[k] != NULL)
              break;

          if (k > i) {
              k -= i;
              for (j = i + k; j < *argc; j++)
                (*argv)[j-k] = (*argv)[j];
              *argc -= k;
          }
      }
 }
}

/*
 *  produce a brand new bonobo_scigraphica
 */
#ifdef WITH_BONOBO
static BonoboObject*
bonobo_scigraphica_factory  (BonoboGenericFactory *factory, void *closure)
{
        BonoboControl* control;
        GtkWidget*     shell;

        python_init("Scigraphica"); /* This should always be done before build_gui */

        if(gui_iconlist){
           shell = build_gui("Scigraphica");
           sg_project_build_popups();
        }

        worksheet_menu = gtk_menu_new();
        plot_menu = gtk_menu_new();

        sg_plugins_init();
        sg_worksheet_build_menu(top_level);
        sg_plot_build_menu();

        sg_project_new();

        if(gui_iconlist || gui_worksheet)
           SGworksheet *worksheet;

           worksheet = sg_project_new_worksheet();

           if(gui_worksheet) sg_worksheet_open(worksheet);
        }

        if(gui_plot){
           SGplot *plot;

           plot = sg_project_new_plot_with_layer(SG_PLOT_2D);
           sg_plot_open(plot);
        }

        sg_project_changed(FALSE); 

#ifdef WITH_GNOME
        main_win_restore_session();
#endif

        gtk_widget_show (shell);

        /* create a BonoboControl from a widget */
        control = bonobo_control_new (shell);

        return BONOBO_OBJECT (control);
}

static void
bonobo_scigraphica_factory_init (void)
{
        /* perform initialization once */
        static BonoboGenericFactory *scigraphica_factory = NULL;

        if (scigraphica_factory)
                return;

        /* register ourselves (using OAF) */
        scigraphica_factory =
          bonobo_generic_factory_new (OAFIID_SCIGRAPHICA_FACTORY,
                                      bonobo_scigraphica_factory, NULL);

        /* registration worked? */
        if (!scigraphica_factory)
                g_error ("Registration of Bonobo Scigraphica factory failed");
}
#endif

void mainloop_iterator(gpointer data){
    if (have_pygtk) sg_eval_quiet("gtk._gtk.gtk_main_iteration(0)");
    return;
}

guint python_init_callback(gpointer data){

  gtk_main_iteration_do(FALSE);
#ifdef WITH_GNOME
    if(gui_iconlist) gnome_app_flash(GNOME_APP(main_window), "Loading Python modules...");
#else
/* Do something equivalent for gtk!*/
#endif

sg_load_default_modules();
    return FALSE;
}


int main(int argc, char **argv, char **envp)
{ 
  pid_t pid;
#ifdef WITH_BONOBO
  gchar *basename;
  CORBA_ORB orb;
#endif

/*  
  pid=fork();
  switch (pid)
  { 
    case -1: fprintf(stderr,"Couldn't fork the scigraphica process!\n");
             break;
    case  0: break;
    default: exit(1);
  }
*/

  init_global_vars(&argc, &argv);

#ifdef WITH_BONOBO

  basename = g_strdup(g_basename(argv[0]));

  if(!g_strncmp(basename, "bonobo-scigraphica",
                strlen("bonobo-scigraphica")))
    {
      /* intialize gnome */
      gnome_init_with_popt_table ("bonobo_scigraphica_factory",  "0.0",
                                  argc, argv, oaf_popt_options, 0, NULL);
 
      /*
       * initialize oaf and bonobo
       */
      orb = oaf_init (argc, argv);
      if (!orb)
        g_error ("initializing orb failed");
 
      if (!bonobo_init (orb, NULL, NULL))
        g_error ("initializing Bonobo failed");
 
      /*
       *  initialize ourself
       */
      bonobo_scigraphica_factory_init();

      /*
       *  enter the bonobo main loop
       */
      bonobo_main (); /* released by  gtk_main_quit() */


      g_free(basename);

    }
  else
#endif /* WITH_BONOBO */
    {
      /* conventional sg main */

#ifdef WITH_GNOME
      gnome_init (PACKAGE, VERSION_INFO, argc, argv);

#ifdef WITH_GDK_IMLIB
      gdk_imlib_init();
#endif

#else
      gint i;
      for (i = 1; i < argc; i++)
        if (!strcmp("--version", argv[i]))
          {
            printf("%s\n", VERSION_INFO);
            exit(0);
          }

      gtk_init(&argc,&argv);

#ifdef WITH_GDK_IMLIB
      gdk_imlib_init();
#endif

#endif

      sg_presentation_dialog();

      python_init(argv[0]);

      if(gui_iconlist){
        main_window = build_gui(argv[0]);
        sg_project_build_popups();
      }

      worksheet_menu = gtk_menu_new();
      plot_menu = gtk_menu_new();

      sg_plugins_init();

      sg_worksheet_build_menu();
      sg_plot_build_menu();

      sg_project_new();

      if(gui_iconlist || gui_worksheet){
         SGworksheet *worksheet;

         worksheet = sg_project_new_worksheet();

         if(gui_worksheet) sg_worksheet_open(worksheet);
      }

      if(gui_plot){
         SGplot *plot;

         plot = sg_project_new_plot_with_layer(SG_PLOT_2D);
         sg_plot_open(plot);
      }

      sg_project_changed(FALSE); 

#ifdef WITH_GNOME
      main_win_restore_session();
#endif

      project_changed = FALSE;

      if(gui_iconlist)
        gtk_widget_show(main_window);

/*
      gtk_signal_connect(GTK_OBJECT(main_window), "event",
                         GTK_SIGNAL_FUNC(icon_event), NULL);
*/

      sg_project_rescue_init();
//      sg_load_default_modules();
      gtk_idle_add((GtkFunction)python_init_callback,(gpointer)argv[0]);
      gtk_main();

    }

  g_free(last_plot_path);
  g_free(last_project_path);
  g_free(last_worksheet_path);
  g_free(last_plot_filename);
  g_free(last_project_filename);
  g_free(last_worksheet_filename);

  sg_plugins_free(); 
  return(0);
}
