/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_FILE_H__
#define __SG_FILE_H__

gboolean	sg_worksheet_import		();
gboolean	sg_worksheet_export		();
gboolean	sg_worksheet_file_import_block	();
gboolean	sg_plot_export			();
gboolean	sg_plot_import			();
gboolean	sg_project_export		();
gboolean    	sg_project_export_as            ();

gboolean	sg_project_open			();
gboolean	sg_project_import		();
gboolean	sg_script_import		();
GdkPixmap*	sg_image_import			();

gchar *         xml_get_string                  (gchar *string);
gboolean        sg_check_file_writeable         (gchar *path);

FILE*           sg_fopen                        (gchar *filename, gchar *mode);
gint            sg_fclose                       (FILE *stream);

#endif

