/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"

static GtkWidget *delimiter_item;
static GtkWidget *delimiter_combo;
static GtkWidget *method_combo;
static GtkWidget *delimiter_entry;
static GtkWidget *comment_entry;

static GtkWidget *block_entry;
static GtkWidget *skip_spin;
static GtkWidget *skip_spin2;
static GtkWidget *skip_spin3;

static GtkWidget *rename_columns_item;
static GtkWidget *rename_worksheets_item;
static GtkWidget *precision_item;

static GtkWidget *lines_frame;
static GtkWidget *blocks_frame;

static GtkWidget *endline_item;

static gchar *delimiters[] = {
                              "unknown",
                              "comma(,)",
                              "tab",
                              "space",
                              NULL};

static gchar *methods[] = {
                              "lines",
                              "blocks",
                              NULL};


static gboolean
mw_destroy(GtkWidget *widget)
{
  /* This is needed to get out of gtk_main */
  gtk_main_quit ();
  return FALSE;
}

static void
update_options(GtkWidget *widget, gpointer data)
{ GtkWidget *child;

  use_custom_delim = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(delimiter_item));
  if (use_custom_delim)
  {   gtk_widget_set_sensitive(delimiter_entry,TRUE);
      gtk_widget_set_sensitive(delimiter_combo,FALSE);
  }
  else
  {   gtk_widget_set_sensitive(delimiter_entry,FALSE);
      gtk_widget_set_sensitive(delimiter_combo,TRUE);
  }

  child = GTK_LIST(GTK_COMBO(delimiter_combo)->list)->selection->data;
  delimiter = gtk_list_child_position(GTK_LIST(GTK_COMBO(delimiter_combo)->list), child);

  strncpy(custom_delimiter,gtk_entry_get_text(GTK_ENTRY(delimiter_entry)),80);
  strncpy(comment_string,gtk_entry_get_text(GTK_ENTRY(comment_entry)),80);
  strncpy(block_start,gtk_entry_get_text(GTK_ENTRY(block_entry)),80);

  begin_line = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(skip_spin));
  end_line = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(skip_spin2));
  blocknum = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(skip_spin3));

  rename_columns = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rename_columns_item));

  rename_worksheets = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rename_worksheets_item));

/*
  precision_mod= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(precision_item));
*/
  precision_mod = FALSE;

  child = GTK_LIST(GTK_COMBO(method_combo)->list)->selection->data;
  read_method = gtk_list_child_position(GTK_LIST(GTK_COMBO(method_combo)->list), child);

  read_all_lines = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(endline_item));

  if (read_all_lines)
     gtk_widget_set_sensitive(skip_spin2,FALSE);
  else
     gtk_widget_set_sensitive(skip_spin2,TRUE);

  switch (read_method)
  { case 0:
      gtk_widget_set_sensitive(lines_frame,TRUE);
      gtk_widget_set_sensitive(blocks_frame,FALSE);
      break;
    case 1:
      gtk_widget_set_sensitive(lines_frame,FALSE);
      gtk_widget_set_sensitive(blocks_frame,TRUE);
      break;
  }

}

static void
import_file(GtkWidget *widget, gpointer data)
{ GtkWidget *child;

  update_options(NULL,NULL);
  if (file_path)
  {   sg_worksheet_file_import_block(active_worksheet, file_path);
      g_free(file_path);
      file_path=NULL;
  }

  gtk_widget_destroy(widget);
}

static void
cancel_clicked(GtkWidget *widget, gpointer data)
{ 
  gtk_widget_destroy(widget);
}


static void
init_dialog()
{
  sg_combo_set_items(GTK_COMBO(delimiter_combo), delimiters);
  sg_combo_set_items(GTK_COMBO(method_combo), methods);
    
  gtk_list_select_item(GTK_LIST(GTK_COMBO(delimiter_combo)->list), delimiter);
  gtk_list_select_item(GTK_LIST(GTK_COMBO(method_combo)->list), read_method);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(skip_spin), skip_lines);

  gtk_entry_set_text(GTK_ENTRY(delimiter_entry), custom_delimiter);
  gtk_entry_set_text(GTK_ENTRY(block_entry), block_start);

  if(use_custom_delim)
  {
      gtk_widget_set_sensitive(delimiter_entry,TRUE);
      gtk_widget_set_sensitive(delimiter_combo,FALSE);
  }
  else
  {
      gtk_widget_set_sensitive(delimiter_entry,FALSE);
      gtk_widget_set_sensitive(delimiter_combo,TRUE);
  }


  gtk_entry_set_text(GTK_ENTRY(comment_entry), comment_string);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(rename_columns_item), 
                              rename_columns);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(rename_worksheets_item),
                              rename_worksheets);
/*
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(precision_item),
                              precision_mod);
*/
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(endline_item),
                              read_all_lines);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(delimiter_item),
                              use_custom_delim);

  switch (read_method)
  { case 0:
      gtk_widget_set_sensitive(lines_frame,TRUE);
      gtk_widget_set_sensitive(blocks_frame,FALSE);
      break;
    case 1:
      gtk_widget_set_sensitive(lines_frame,FALSE);
      gtk_widget_set_sensitive(blocks_frame,TRUE);
      break;
  }

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(skip_spin),(gfloat)begin_line);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(skip_spin2),(gfloat)end_line);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(skip_spin3),(gfloat)blocknum);

}


void
sg_import_dialog (gchar *full_path,gchar *file_name)
{
  GtkWidget *window = NULL;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button,*apply_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *comment_label;
  GtkWidget *delimiter_label;
  GtkWidget *method_label;
  GtkWidget *block_label;
  GtkAdjustment *adj,*adj2,*adj3;
  GtkRequisition req;
  gchar name[80];

  file_path=g_strdup(full_path);

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"ASCII import options");

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */
  main_box= gtk_table_new(2, 3, FALSE);

  gtk_container_add (GTK_CONTAINER (window), main_box);

  if (full_path)
      g_snprintf(name,80,"File structure: %s",file_name);
  else
      g_snprintf(name,80,"File structure");
  frame = gtk_frame_new(name);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);

  gtk_table_attach(GTK_TABLE(main_box), frame, 0, 2, 0, 1,
                   GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,10,5);

  table = gtk_table_new(3, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  delimiter_item = gtk_check_item_new_with_label("Use custom:");
  delimiter_combo = gtk_combo_new();
  delimiter_entry = gtk_entry_new();
  comment_entry = gtk_entry_new();
  comment_label=gtk_label_new("Comment (matches any character in string):");
  delimiter_label=gtk_label_new("Delimiter:");
  method_label=gtk_label_new("Read file as:");
  method_combo = gtk_combo_new();

  gtk_widget_size_request(delimiter_entry, &req);
  gtk_widget_set_usize(delimiter_entry, 20, req.height);
  gtk_widget_set_usize(comment_entry, 20, req.height);
  gtk_widget_set_usize(delimiter_combo, req.width/3, req.height);
  gtk_widget_set_usize(method_combo, req.width/3, req.height);

  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(delimiter_combo)->entry), FALSE);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(method_combo)->entry), FALSE);

  gtk_table_attach_defaults(GTK_TABLE(table), delimiter_label, 0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), delimiter_combo, 1, 2, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), delimiter_item, 1, 2, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), delimiter_entry, 2, 3, 2, 3);

  gtk_table_attach_defaults(GTK_TABLE(table), comment_label, 0, 2, 3, 4);
  gtk_table_attach_defaults(GTK_TABLE(table), comment_entry, 2, 3, 3, 4);

  gtk_table_attach_defaults(GTK_TABLE(table), method_label, 0, 1, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), method_combo, 1, 2, 0, 1);

 /* Import as lines */
  lines_frame = gtk_frame_new("Read lines");
  gtk_frame_set_shadow_type (GTK_FRAME (lines_frame), GTK_SHADOW_ETCHED_IN);

  gtk_table_attach(GTK_TABLE(main_box), lines_frame, 0, 1, 1, 2,
                   GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,10,5);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(lines_frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  adj = (GtkAdjustment *)gtk_adjustment_new((gfloat) begin_line, 1., 1e6, 1., 10., 10.);
  skip_spin = gtk_spin_button_new(adj, 0, 0);   
  gtk_widget_set_usize(skip_spin, 40, req.height);

  gtk_entry_set_editable(GTK_ENTRY(skip_spin), TRUE);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Start line"),
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            skip_spin,
                            1, 2, 0, 1);
  endline_item = gtk_check_item_new_with_label("Read all lines");
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            endline_item,
                            0, 2, 1, 2);


  /* End line */
  adj2 = (GtkAdjustment *)gtk_adjustment_new((gfloat) end_line, 1.,1e6, 1., 10., 10.);
  skip_spin2 = gtk_spin_button_new(adj2, 0, 0);
  gtk_widget_set_usize(skip_spin2, 40, req.height);

  gtk_entry_set_editable(GTK_ENTRY(skip_spin2), TRUE);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("End line"),
                            0, 1, 2, 3);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            skip_spin2,
                            1, 2, 2, 3);


 /* Import as blocks */
  blocks_frame = gtk_frame_new("Read blocks");
  gtk_frame_set_shadow_type (GTK_FRAME (blocks_frame), GTK_SHADOW_ETCHED_IN);

  gtk_table_attach(GTK_TABLE(main_box), blocks_frame, 1, 2, 1, 2,
                   GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,10,5);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(blocks_frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  adj3 = (GtkAdjustment *)gtk_adjustment_new((gfloat) blocknum, 1., 1e6, 1., 10., 10.);
  skip_spin3 = gtk_spin_button_new(adj3, 0, 0);
  gtk_widget_set_usize(skip_spin3, 40, req.height);

  gtk_entry_set_editable(GTK_ENTRY(skip_spin3), TRUE);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Block number"),
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            skip_spin3,
                            1, 2, 0, 1);

  block_label=gtk_label_new("Start of block contains:");
  block_entry = gtk_entry_new();
  gtk_widget_set_usize(block_entry, req.width/3, req.height);
  gtk_table_attach_defaults(GTK_TABLE(table),
                            block_label,
                            0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            block_entry,
                            1, 2, 1, 2);



/* Worksheet options */
  frame = gtk_frame_new("Worsheet options");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);

  gtk_table_attach(GTK_TABLE(main_box), frame, 0, 2, 2, 3,
                   GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,10,5);

  table = gtk_table_new(2, 1, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  rename_columns_item = gtk_check_item_new_with_label(
                        "Rename columns if 1st. line contains labels");
  rename_worksheets_item = gtk_check_item_new_with_label(
                        "Rename worksheet to data file name");
/*
  precision_item = gtk_check_item_new_with_label(
                        "Modify decimal number precision on import");
*/

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            rename_columns_item,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            rename_worksheets_item,
                            0, 1, 1, 2);

/*
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            precision_item,
                            0, 1, 2, 3);
*/


  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);

  gtk_table_attach(GTK_TABLE(main_box), action_area, 0, 2, 3, 4,
                  GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,10,5);
  gtk_widget_show (action_area);

#ifdef WITH_GNOME
  if (full_path)
      ok_button = gnome_pixmap_button (gnome_stock_pixmap_widget_new(window, "Open"),"Import");
  else
  {   ok_button = gnome_stock_button ("Button_Ok");
      apply_button=gnome_stock_button ("Button_Apply");
  }
  cancel_button = gnome_stock_button ("Button_Cancel");
#else
  if (full_path)
      ok_button = gtk_button_new_with_label ("Import");
  else
  {   ok_button = gtk_button_new_with_label ("OK");
      apply_button=gtk_button_new_with_label ("Apply");
  }
  cancel_button = gtk_button_new_with_label ("Cancel");
#endif

  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  if (!full_path)
  {  GTK_WIDGET_SET_FLAGS (apply_button, GTK_CAN_DEFAULT);
     gtk_box_pack_start (GTK_BOX (action_area), apply_button, TRUE, TRUE, 0);
     gtk_widget_show (apply_button);
  }

  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);


  /* Show widgets */



  gtk_widget_show_all (window);

  init_dialog();
  update_options(NULL,NULL);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (cancel_clicked),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (delimiter_item), "toggled",
                             GTK_SIGNAL_FUNC (update_options),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (endline_item), "toggled",
                             GTK_SIGNAL_FUNC (update_options),
                             GTK_OBJECT (window));


  gtk_signal_connect_object (GTK_OBJECT (  GTK_COMBO(method_combo)->entry),
                             "changed",GTK_SIGNAL_FUNC (update_options),
                             GTK_OBJECT (window));


  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (import_file),
                             GTK_OBJECT (window));

  if (!full_path)
    gtk_signal_connect_object (GTK_OBJECT (apply_button), "clicked",
                             GTK_SIGNAL_FUNC (update_options),NULL);


}
