/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_LAYER_H__
#define __SG_LAYER_H__

typedef struct _SGlayer SGlayer;
typedef struct _SGtick SGtick;

struct _SGlayer 
{
  gpointer parent;

  gint rescale;

  gint type;

  GtkWidget *real_plot;

  GtkWidget *button;

  GList *datasets;

  GList *left_axis_labels;
  GList *right_axis_labels;
  GList *top_axis_labels;
  GList *bottom_axis_labels;

  /* Automatic symbols */
  gint symbol;
  gint symbol_style;
  gint line_style;
  gint connector;
  GdkColor symbol_color;
  GdkColor line_color;
};

struct _SGtick 
{
  gdouble value;
  gchar *label;
};

SGlayer 	*sg_layer_new			(gint plot_type,
                                                 gdouble width, gdouble height);
void		sg_layer_add_dataset		(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_add_dataset_default	(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_remove_dataset		(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_clear			(SGlayer *layer);
void		sg_layer_button_set_label	(SGlayer *layer, gint label);
void		sg_layer_set_tick_labels	(SGlayer *layer,
                                                 gint axis_pos,
						 gchar *sheet_name,
                                                 gint values_column,
                                                 gint labels_column);

#endif /* __SG_LAYER_H__ */

