/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"

static GtkWidget *left_entry, *top_entry;
static GtkWidget *width_entry, *height_entry;
static GtkWidget *transparent_item; 
static GtkWidget *bg_button;

/* static GtkWidget *legends_item; */ 
static GtkWidget *color_combo; 
static GtkPlot *plot;
static SGlayer *the_layer;

void
sg_layer_dialog_update_plot(GtkWidget *widget)
{
  SGplot *parent;
  GtkColorCombo *combo;
  GdkColor color;
  gchar *color_name;

  plot->x = atof(gtk_entry_get_text(GTK_ENTRY(left_entry)));
  plot->y = atof(gtk_entry_get_text(GTK_ENTRY(top_entry)));
  plot->width = atof(gtk_entry_get_text(GTK_ENTRY(width_entry)));
  plot->height = atof(gtk_entry_get_text(GTK_ENTRY(height_entry)));

  combo = GTK_COLOR_COMBO(color_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(color_combo->style->colormap, &color);
  plot->background = color;

  gtk_plot_set_transparent(GTK_PLOT(plot), 
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(transparent_item)));

/*
  plot->show_legends = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(legends_item));
*/

  parent = (SGplot *)the_layer->parent;
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(parent->real_canvas));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(parent->real_canvas));
}

static void
select_image(GtkWidget *widget, gpointer data)
{
  GdkPixmap *pixmap;

  pixmap = sg_image_import();

  if(pixmap) 
     gtk_plot_set_background_pixmap(GTK_PLOT(the_layer->real_plot), pixmap);
}


static void
init_dialog()
{
  gchar label[100];

  sprintf(label, "%*.*f", 1, 3, plot->x);
  gtk_entry_set_text(GTK_ENTRY(left_entry), label); 
  sprintf(label, "%*.*f", 1, 3, plot->y);
  gtk_entry_set_text(GTK_ENTRY(top_entry), label); 
  sprintf(label, "%*.*f", 1, 3, plot->width);
  gtk_entry_set_text(GTK_ENTRY(width_entry), label); 
  sprintf(label, "%*.*f", 1, 3, plot->height);
  gtk_entry_set_text(GTK_ENTRY(height_entry), label); 

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(transparent_item),
                              gtk_plot_is_transparent(GTK_PLOT(plot))); 

/*
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(legends_item),
                              plot->show_legends); 
*/

  sg_color_combo_init(GTK_COLOR_COMBO(color_combo), GTK_PLOT(plot)->background);
}

GtkWidget *
sg_layer_dialog_new (SGlayer *layer)
{
  GtkWidget *frame;
  GtkWidget *main_box, *main_table;
  GtkWidget *table;
  GtkRequisition req;

  the_layer = layer;
  plot = GTK_PLOT(layer->real_plot);

  /* Create widgets */
  main_box = gtk_hbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 5);

  main_table = gtk_table_new(2,2,FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(main_table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(main_table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(main_table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), main_table, FALSE, FALSE, 0);
/*----------------------------------------------*/
  frame = gtk_frame_new("Position");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 0, 1, 0, 1);

  table=gtk_table_new(4, 3, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Units in % of page size"), 0, 4, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("left offset "), 0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("top offset "), 0, 1, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("width "), 2, 3, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("height "), 2, 3, 2, 3);
  left_entry = gtk_entry_new();
  top_entry = gtk_entry_new();
  width_entry = gtk_entry_new();
  height_entry = gtk_entry_new();

  gtk_widget_size_request(left_entry, &req);
  req.width /= 2;
  gtk_widget_set_usize(left_entry, req.width, req.height);
  gtk_widget_set_usize(top_entry, req.width, req.height);
  gtk_widget_set_usize(width_entry, req.width, req.height);
  gtk_widget_set_usize(height_entry, req.width, req.height);

  gtk_table_attach_defaults(GTK_TABLE(table), left_entry, 1, 2, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), top_entry, 1, 2, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), width_entry, 3, 4, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), height_entry, 3, 4, 2, 3);

  
 /*--------------------------------------*/
  frame = gtk_frame_new("Properties");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 1, 2, 0, 1);

  table=gtk_table_new(3, 3, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  transparent_item = gtk_check_item_new_with_label("transparent");
  gtk_table_attach_defaults(GTK_TABLE(table), transparent_item, 0, 2, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Background"), 0, 1, 1, 2);
  color_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), color_combo, 1, 2, 1, 2);

/*
  legends_item = gtk_check_item_new_with_label("show legends");
  gtk_table_attach_defaults(GTK_TABLE(table), legends_item, 0, 2, 2, 3);
*/
  bg_button = gtk_button_new_with_label("Browse...");

  gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new("Use image"), 0, 1, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), bg_button, 1, 2, 2, 3);
/*--------------------------------------*/
  /* connect signals */
  init_dialog();

  sg_entry_set_numeric(GTK_ENTRY(left_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(top_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(width_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(height_entry), 3);

  gtk_signal_connect (GTK_OBJECT (bg_button),
                      "clicked",
                      GTK_SIGNAL_FUNC (select_image),
                      NULL);

  return main_box;
}
