/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"

static GtkWidget *fg_combo;
static GtkWidget *style_combo; 
static GtkWidget *line_width_spin; 
static GtkWidget *arrow_length_spin; 
static GtkWidget *arrow_width_spin; 
static GtkWidget *arrow_combo; 
static GtkWidget *origin_item, *end_item; 
static GtkPlotCanvas *the_canvas; 

static gboolean
mw_destroy(GtkWidget *widget)
{
  sg_dialog_kill(widget);

  /* This is needed to get out of gtk_main */
  gtk_main_quit ();

  return FALSE;
}

static void
update_line(GtkWidget *widget, gpointer data)
{
  GdkColor color;
  GdkColormap *colormap;
  GtkPlotCanvasLine *line;
  GtkWidget *child;
  gint line_style;
  gint row, col;
  gchar *name;

  line = (GtkPlotCanvasLine *)data;
  colormap = gdk_colormap_get_system();

  row = GTK_COLOR_COMBO(fg_combo)->row;
  col = GTK_COLOR_COMBO(fg_combo)->column;
  name = gtk_color_combo_get_color_at(GTK_COLOR_COMBO(fg_combo), row, col);
  gdk_color_parse(name, &color);
  gdk_color_alloc(colormap, &color);

  line->line.color = color;

  child = GTK_LIST(GTK_COMBO(style_combo)->list)->selection->data;
  line_style = gtk_list_child_position(GTK_LIST(GTK_COMBO(style_combo)->list), child);

  line->line.line_style = line_style;
  line->line.line_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(line_width_spin));

  child = GTK_LIST(GTK_COMBO(arrow_combo)->list)->selection->data;
  line->arrow_style = gtk_list_child_position(GTK_LIST(GTK_COMBO(arrow_combo)->list), child);

  line->arrow_length = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arrow_length_spin));
  line->arrow_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arrow_width_spin));


  line->arrow_mask = 0;
  line->arrow_mask |= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(origin_item));
  line->arrow_mask |= 2 * gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(end_item));

  gtk_plot_canvas_paint(the_canvas);
  gtk_plot_canvas_refresh(the_canvas);
}


void
sg_line_dialog (GtkPlotCanvas *canvas, GtkPlotCanvasLine *line)
{
  GtkWidget *window = NULL;
  GtkWidget *frame;
  GtkWidget *main_box, *main_table;
  GtkWidget *ok_button, *apply_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkAdjustment *adj;

  the_canvas = canvas;

  /* Create modal window (Here you can use any window descendent )*/
  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window)," Line ");

  sg_dialog_new(window);

  /* Set window as modal */
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */
  main_box = gtk_hbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  main_table = gtk_table_new(2, 2,FALSE);
  gtk_box_pack_start (GTK_BOX (main_box), main_table, FALSE, FALSE, 0);
/*----------------------------------------------*/
  frame = gtk_frame_new("Properties");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 1, 2, 0, 1);

  table=gtk_table_new(9, 2, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 10);

  gtk_container_add(GTK_CONTAINER(frame), table);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Color"), 0, 1, 0, 1);
  fg_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), fg_combo, 1, 2, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Line style"), 0, 1, 2, 3);
  style_combo = gtk_combo_new();
  sg_combo_set_items(GTK_COMBO(style_combo), line_styles);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(style_combo)->entry), FALSE);
  gtk_table_attach_defaults(GTK_TABLE(table), style_combo, 1, 2, 2, 3);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Line width"), 0, 1, 3, 4);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 6., 1., 1., 0.);
  line_width_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(line_width_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(line_width_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), line_width_spin, 1, 2, 3, 4);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Arrow style"), 0, 1, 4, 5);
  arrow_combo = gtk_combo_new();
  sg_combo_set_items(GTK_COMBO(arrow_combo), symbol_styles);
  gtk_table_attach_defaults(GTK_TABLE(table), arrow_combo, 1, 2, 4, 5);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Arrow length"), 0, 1, 5, 6);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 40., 1., 1., 0.);
  arrow_length_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(arrow_length_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(arrow_length_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), arrow_length_spin, 1, 2, 5, 6);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Arrow width"), 0, 1, 6, 7);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 40., 1., 1., 0.);
  arrow_width_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(arrow_width_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(arrow_width_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), arrow_width_spin, 1, 2, 6, 7);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Arrow at"), 0, 1, 7, 9);

  origin_item = gtk_check_item_new_with_label("Origin");
  gtk_table_attach_defaults(GTK_TABLE(table), origin_item, 1, 2, 7, 8);

  end_item = gtk_check_item_new_with_label("End");
  gtk_table_attach_defaults(GTK_TABLE(table), end_item, 1, 2, 8, 9);

  /* Action Area */
  action_area = gtk_vbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = gtk_button_new_with_label ("OK");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  apply_button = gtk_button_new_with_label ("Apply");
  gtk_box_pack_start (GTK_BOX (action_area), apply_button, TRUE, TRUE, 0);
  gtk_widget_show (apply_button);

  cancel_button = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* initialize */

  gtk_list_select_item(GTK_LIST(GTK_COMBO(style_combo)->list), 
                       line->line.line_style);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(line_width_spin), 
                            line->line.line_width);

  gtk_list_select_item(GTK_LIST(GTK_COMBO(arrow_combo)->list), 
                       line->arrow_style);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(arrow_length_spin), 
                            line->arrow_length);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(arrow_width_spin), 
                            line->arrow_width);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(origin_item),
			      line->arrow_mask & GTK_PLOT_ARROW_ORIGIN);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(end_item),
			      line->arrow_mask & GTK_PLOT_ARROW_END);

  sg_color_combo_init(GTK_COLOR_COMBO(fg_combo), line->line.color); 

  /* connect signals */

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  gtk_signal_connect (GTK_OBJECT (apply_button), "clicked",
                      GTK_SIGNAL_FUNC (update_line), line);

  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (update_line), line);

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(window));

  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(window));

  /* Show widgets */
  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

}
