/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <math.h>
#include "../pixmaps/button_ok.xpm"
#include "../pixmaps/warning.xpm"
#include "../pixmaps/error.xpm"
#include "../pixmaps/sorry.xpm"
#include "main.h"
#include <string.h>

static GtkWidget *append_spin;
static gint the_orientation;
static gint return_value;
static GtkPlotCanvasChild *select_rect=NULL;
static gint select_int=-1;
static gchar *return_text;

static gboolean
mw_destroy(GtkWidget *widget)
{
  sg_dialog_kill(widget);

  /* This is needed to get out of gtk_main */
  gtk_main_quit ();

  return FALSE;
}

static gboolean
ok_clicked(GtkWidget *widget)
{
  return_value = YES_CLICKED;

  gtk_widget_destroy(widget);
  return FALSE;
}

static gboolean
no_clicked(GtkWidget *widget)
{
  return_value = NO_CLICKED;

  gtk_widget_destroy(widget);
  return FALSE;
}

static gboolean
cancel_clicked(GtkWidget *widget)
{
  return_value = CANCEL_CLICKED;

  gtk_widget_destroy(widget);
  return FALSE;
}

static gboolean
store_text(GtkWidget *widget, gpointer data)
{
  return_text = g_strdup(gtk_entry_get_text(GTK_ENTRY(data)));

  return FALSE;
}


static void
update_worksheet(GtkWidget *widget, gpointer data)
{
  GtkSheet *sheet;
  gint n;

  sheet = GTK_SHEET(active_worksheet->sheet);

  n = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(append_spin));

  if(the_orientation == GTK_ORIENTATION_HORIZONTAL)
    sg_worksheet_add_columns(active_worksheet, n);
  else
    sg_worksheet_add_rows(active_worksheet, n);

  gtk_widget_destroy(widget);
}


void
sg_append_dialog (SGworksheet *worksheet, gint orientation)
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkAdjustment *adj;
  GtkRequisition req;
  gchar text[100],*msg;
  gint retval;

#ifdef WITH_GNOME
  GtkWidget *dialog;

  if (orientation == GTK_ORIENTATION_HORIZONTAL)
      msg=strdup("Append columns");
  else
      msg=strdup("Append rows");

  dialog=gnome_dialog_new (msg,
                           GNOME_STOCK_BUTTON_OK,
                           GNOME_STOCK_BUTTON_CANCEL,
                           NULL);

  main_box = GNOME_DIALOG(dialog)->vbox;
#else
  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  sg_dialog_new(window);

  if (orientation == GTK_ORIENTATION_HORIZONTAL)
    gtk_window_set_title (GTK_WINDOW(window),"Append columns");
  else
    gtk_window_set_title (GTK_WINDOW(window),"Append rows");

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);
#endif

  the_orientation = orientation;
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 10000., 1., 0., 0.); 
  append_spin = gtk_spin_button_new(adj, 0, 0);   
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(append_spin), TRUE);

  gtk_widget_size_request(append_spin, &req);
  gtk_widget_set_usize(append_spin, req.width, req.height);

  if(orientation == GTK_ORIENTATION_HORIZONTAL)
    sprintf(text, "Number of columns");
  else
    sprintf(text, "Number of rows");

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(text),
                            0, 2, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), append_spin, 0, 2, 1, 2);

  /* Action Area */
#ifndef WITH_GNOME
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = gtk_button_new_with_label ("OK");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label ("Cancel");
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (update_worksheet),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(append_spin), 1);

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();
#else
  gtk_widget_show_all (main_box);
  retval=gnome_dialog_run(GNOME_DIALOG(dialog));
  if (retval==0) 
  {
    GtkSheet *sheet;
    gint n;

    sheet = GTK_SHEET(active_worksheet->sheet);

    n = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(append_spin));

    if(the_orientation == GTK_ORIENTATION_HORIZONTAL)
      sg_worksheet_add_columns(active_worksheet, n);
    else
      sg_worksheet_add_rows(active_worksheet, n);
   }
  gtk_widget_destroy(GTK_WIDGET(dialog));
  g_free(msg);
#endif
  return;
}

gchar *
sg_text_dialog (gchar *msg, gint type)
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *ok_button;
  GtkWidget *action_area;
  GtkWidget *bbox1, *bbox2;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  GtkWidget *entry;

  return_text = NULL;
  colormap = gdk_colormap_get_system();

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  sg_dialog_new(window);

  switch(type){
    case 0:
      gtk_window_set_title (GTK_WINDOW(window),"Error");
      break;
    case 1:
      gtk_window_set_title (GTK_WINDOW(window),"Warning");
      break;
    case 2:
      gtk_window_set_title (GTK_WINDOW(window),"Sorry");
      break;
  }

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  switch(type){
   case 0:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   error_xpm);
    break;
   case 1:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   warning_xpm);
    break;
   case 2:
   default:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   sorry_xpm);
    break;
  }

  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            tpixmap,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(msg),
                            1, 2, 0, 1);

  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            entry,
                            0, 2, 1, 2);

  /* Action Area */
  gtk_box_pack_start (GTK_BOX (main_box), gtk_hseparator_new(), FALSE, TRUE, 0);

  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 button_ok_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);

  ok_button = gtk_button_new ();
  bbox1 = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(ok_button), bbox1);
  
  bbox2 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(bbox1), bbox2, TRUE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(bbox2), tpixmap, FALSE, FALSE, 0);
  gtk_box_pack_end(GTK_BOX(bbox2), gtk_label_new("Accept"), FALSE, FALSE, 2);
  
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show_all (ok_button);

  /* connect signals */
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (store_text), entry);

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

  return return_text;
}


#ifndef WITH_GNOME

void
sg_message_dialog (gchar *msg, gint type)
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *ok_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  sg_dialog_new(window);

  switch(type){
    case 0:
      gtk_window_set_title (GTK_WINDOW(window),"Error");
      break;
    case 1:
      gtk_window_set_title (GTK_WINDOW(window),"Warning");
      break;
    case 2:
      gtk_window_set_title (GTK_WINDOW(window),"Sorry");
      break;
  }

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  switch(type){
   case 0:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   error_xpm);
    break;
   case 1:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   warning_xpm);
    break;
   case 2:
   default:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   sorry_xpm);
    break;
  }

  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            tpixmap,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(msg),
                            1, 2, 0, 1);

  /* Action Area */
  gtk_box_pack_start (GTK_BOX (main_box), gtk_hseparator_new(), FALSE, TRUE, 0);

  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = gtk_button_new_with_label ("Accept");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

  return;
}

gint
sg_accept_dialog (gchar *msg, gint type)
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *ok_button, *no_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  return_value = FALSE;
  colormap = gdk_colormap_get_system();

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  sg_dialog_new(window);

  gtk_window_set_title (GTK_WINDOW(window),"Warning");

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 warning_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            tpixmap,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(msg),
                            1, 2, 0, 1);

  /* Action Area */
  gtk_box_pack_start (GTK_BOX (main_box), gtk_hseparator_new(), FALSE, TRUE, 0);

  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = gtk_button_new_with_label ("Yes");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  no_button = gtk_button_new_with_label ("No");
  GTK_WIDGET_SET_FLAGS (no_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), no_button, TRUE, TRUE, 0);
  gtk_widget_show (no_button);

  if(type == 0) {
    cancel_button = gtk_button_new_with_label ("Cancel");
    GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
    gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
    gtk_widget_show (cancel_button);
  }

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (ok_clicked),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (no_button), "clicked",
                             GTK_SIGNAL_FUNC (no_clicked),
                             GTK_OBJECT (window));

  if(type == 0) {
    gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                               GTK_SIGNAL_FUNC (cancel_clicked),
                               GTK_OBJECT (window));
  }

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

  return return_value;
}

#else

gint 
sg_accept_dialog (gchar *msg, gint type)
{ 
  GtkWidget *dialog;
  gint retval;

  if(type == 1)
    dialog=gnome_message_box_new (msg, GNOME_MESSAGE_BOX_WARNING,
                                  GNOME_STOCK_BUTTON_YES,
                                  GNOME_STOCK_BUTTON_NO,
                                  NULL);
  else
    dialog=gnome_message_box_new (msg, GNOME_MESSAGE_BOX_WARNING,
                                  GNOME_STOCK_BUTTON_YES,
                                  GNOME_STOCK_BUTTON_NO,
                                  GNOME_STOCK_BUTTON_CANCEL,
                                  NULL);
  if (main_window)
   gtk_window_set_transient_for(&GNOME_DIALOG(dialog)->window,&GNOME_APP(main_window)->parent_object);
  retval = gnome_dialog_run(GNOME_DIALOG(dialog));
  
  if (retval==0) return TRUE;
  if (retval==1) return FALSE;  
  return retval;
}

GtkWidget *
sg_accept_dialog_loop (gchar *msg, gint type)
{ 
  GtkWidget *dialog;

  if(type == 1)
    dialog=gnome_message_box_new (msg, GNOME_MESSAGE_BOX_WARNING,
                                  GNOME_STOCK_BUTTON_YES,
                                  GNOME_STOCK_BUTTON_NO,
                                  NULL);
  else
    dialog=gnome_message_box_new (msg, GNOME_MESSAGE_BOX_WARNING,
                                  GNOME_STOCK_BUTTON_YES,
                                  GNOME_STOCK_BUTTON_NO,
                                  GNOME_STOCK_BUTTON_CANCEL,
                                  NULL);
  if (main_window)
   gtk_window_set_transient_for(&GNOME_DIALOG(dialog)->window,&GNOME_APP(main_window)->parent_object);
  return dialog;
}


void sg_message_dialog (gchar *msg, gint type)
{ gchar *type_g;
  GtkWidget *dialog;
  switch (type)
  {
    case 0: 
      type_g=strdup(GNOME_MESSAGE_BOX_ERROR);
      break;
    case 1: 
      type_g=strdup(GNOME_MESSAGE_BOX_WARNING);
      break;
    case 2: 
      type_g=strdup(GNOME_MESSAGE_BOX_INFO);
      break;
  }
  dialog=gnome_message_box_new (msg, type_g,
                                GNOME_STOCK_BUTTON_OK,
                                NULL);
  if (main_window)
    gtk_window_set_transient_for(&GNOME_DIALOG(dialog)->window,&GNOME_APP(main_window)->parent_object);
  gnome_dialog_run(GNOME_DIALOG(dialog));

  g_free(type_g);
  return;
}

GtkWidget * 
sg_message_dialog_loop (gchar *msg, gint type)
{ gchar *type_g;
  GtkWidget *dialog;
  switch (type)
  {
    case 0: 
      type_g=strdup(GNOME_MESSAGE_BOX_ERROR);
      break;
    case 1: 
      type_g=strdup(GNOME_MESSAGE_BOX_WARNING);
      break;
    case 2: 
      type_g=strdup(GNOME_MESSAGE_BOX_INFO);
      break;
  }

  dialog=gnome_message_box_new (msg, type_g,
                                GNOME_STOCK_BUTTON_OK,
                                NULL);
  if (main_window)
    gtk_window_set_transient_for(&GNOME_DIALOG(dialog)->window,&GNOME_APP(main_window)->parent_object);
  return dialog;
}


#endif

