/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sg_dataset.h"
#include "sg_layer.h"

#ifndef __SG_PLOT_H__
#define __SG_PLOT_H__

enum {
	SG_PLOT_2D,
	SG_PLOT_3D,
	SG_PLOT_POLAR,
};

enum{
     SG_TOOL_ARROW,
     SG_TOOL_ZOOM,
     SG_TOOL_POINTER,
     SG_TOOL_MARKERS,
     SG_TOOL_DND_POINT,
     SG_TOOL_LINE,
     SG_TOOL_LINE_ARROW,
     SG_TOOL_RECTANGLE,
     SG_TOOL_ELLIPSE,
     SG_TOOL_TEXT,
};

enum{
     SG_RESCALE_NONE,
     SG_RESCALE_AUTO
};


#define SG_DPI 75.0

enum{SG_UNIT_PT,
     SG_UNIT_MM,
     SG_UNIT_CM,
     SG_UNIT_IN,
     SG_UNIT_PIXEL
};


typedef struct _SGplot SGplot;

struct _SGplot 
{
  gchar *name;
  gint x, y, width, height;
  
  gint orientation;
  gint page_size;
  gint page_width, page_height;

  gint page_units;

  gboolean is_mapped;

  gdouble scale;

  gint tool;

  SGlayer *active_layer;

  GtkWidget *real_canvas;

  GtkWidget *sw;
  GtkWidget *canvas_box;
  GtkWidget *window;
  GtkWidget *toolbox;
  GtkWidget *label;
  GtkWidget *hruler;
  GtkWidget *vruler;

  GtkIconList *iconlist;
  GtkIconListItem *icon;

  gint nlayers;
  GList *layers;

};

SGplot 	*sg_plot_new			(gchar *name);
SGplot 	*sg_plot_new_with_layer		(gint plot_type,
                                         gchar *name);

void		 sg_plot_open		(SGplot *plot); 
void		 sg_plot_hide		(SGplot *plot); 
gint 		 sg_plot_rename		(SGplot *plot,
					 gchar *name); 
void		 sg_plot_set_size	(SGplot *plot,
                                         gint page_size,
					 gint width, gint height,
                                         gint orientation);
SGplot	 	*sg_plot_get_from_canvas	(GtkWidget *canvas);
void		 sg_plot_rescale		(SGplot *plot, gdouble scale); 
void		 sg_plot_clear			(SGplot *plot); 
void		 sg_plot_remove			(SGplot *plot); 
void		 sg_plot_fit_page		(SGplot *plot);
void		 sg_plot_fit_page_h		(SGplot *plot);
void		 sg_plot_fit_page_v		(SGplot *plot);
void		 sg_plot_add_layer 		(SGplot *plot, SGlayer *layer,
						 gdouble x, gdouble y);
void		 sg_plot_move_layer 		(SGplot *plot, SGlayer *layer,
						 gdouble x, gdouble y);
void		 sg_plot_resize_layer 		(SGplot *plot, SGlayer *layer,
						 gdouble width, gdouble height);
void		 sg_plot_remove_layer 		(SGplot *plot, SGlayer *layer);
void		 sg_plot_set_active_layer 	(SGplot *plot, SGlayer *layer);
void		 sg_plot_put_pixmap 	(SGplot *plot, GdkPixmap *pixmap);

#endif /* __SG_PLOT_H__ */

