/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>

#include "main.h"

SGplotfile*
sg_plot_file_new (SGplot *plot, gchar *filename)
{
  SGplotfile *file;

  if(!filename) return NULL;
  if(!plot) return NULL;

  file = g_new(SGplotfile, 1);
  file->filename = g_strdup(filename); 
  file->plot = plot;

  file->save_plot = NULL;
  file->save_layer = NULL;
  file->save_dataset = NULL;
  file->save_axis = NULL;

  file->set_line_style = NULL;
  file->set_symbol_style = NULL;
  file->put_text = NULL;

  return file;
}

void
sg_plot_file_export (SGplotfile *file)
{  
  file->save_plot(file);
}
