/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PROJECT_H__
#define __SG_PROJECT_H__

void	sg_project_new				();
void	sg_project_init				();
void	sg_project_set_title			();
void	sg_project_changed			(gboolean changed);
SGworksheet 	*sg_project_new_worksheet	();
SGplot 		*sg_project_new_plot		();
SGplot 		*sg_project_new_plot_with_layer	(gint type);
void 	sg_project_remove_worksheet		(SGworksheet *worksheet);
void 	sg_project_remove_plot			(SGplot *plot);
gint 	sg_project_rename_worksheet		(SGworksheet *worksheet,
						 gchar *name);
gint 	sg_project_rename_plot			(SGplot *plot,
						 gchar *name);
void 	sg_project_add_function			(SGdataset *function);
void 	sg_project_close			();
void	sg_project_open_plot			(GtkWidget *widget,
                     				 GtkIconListItem *item,
						 GdkEvent *event,
                     				 gpointer data);
void	sg_project_open_worksheet		(GtkWidget *widget,
                     				 GtkIconListItem *item, 
						 GdkEvent *event,
                     				 gpointer data);
SGworksheet *sg_project_get_worksheet		(gchar *name);
SGplot 	*sg_project_get_plot			(gchar *name);
void 	sg_project_refresh_datasets		(SGworksheet *worksheet);
void 	sg_menu_exit				(GtkWidget *widget, 
						 gpointer data);
void	sg_project_rescue_init			(void);
SGplugin 	*sg_project_new_plugin		(gchar *name, 
						 gchar *python_name,
						 gchar *group);
#endif

