/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"
#include "sg_menu.h"
#include "../pixmaps/pixmaps.h"
#include "python/python_main.h"

static char *popup_items[]={
                "Open",
                "Rename",
                "Remove",
};

static void sg_menu_new_project				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_plot				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_plot_3d				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_plot_polar			(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_worksheet			(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_function                        (GtkWidget *widget,
                                                         gpointer data);
static void sg_menu_open				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_import				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_save				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_save_as				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_load_script                         (GtkWidget *widget,
                                                         gpointer data);
static void sg_menu_preferences				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_doc					(GtkWidget *widget,
							 gpointer data);
static void sg_menu_example				(GtkWidget *widget,
							 gpointer data);

void
sg_worksheet_popup_show(GtkIconListItem *item, GdkEventButton *event)
{
    active_icon = item;

    gtk_menu_popup(GTK_MENU(worksheet_popup), NULL, NULL, NULL, NULL,
                   event->button, event->time);
}

void
sg_plot_popup_show(GtkIconListItem *item, GdkEventButton *event)
{
    active_icon = item;

    gtk_menu_popup(GTK_MENU(plot_popup), NULL, NULL, NULL, NULL,
                   event->button, event->time);
}


static void
plot_popup_activated(GtkWidget *widget, gpointer data)
{
 gchar *item;
 GtkIconList *iconlist;
 SGplot *plot;

 item = (gchar *)data;
 iconlist = GTK_ICON_LIST(iconlist2);

 plot =  (SGplot *) gtk_icon_list_get_link(active_icon);

 if(strcmp(item,"Open")==0)
   sg_plot_open(plot);

 if(strcmp(item,"Remove")==0){
   gint veto;
   gchar text[100]; 
   
   sprintf(text,"Remove %s ?", plot->name);

   veto = sg_accept_dialog(text, 1);
   if(veto != YES_CLICKED) return;

   sg_project_remove_plot(plot);
 }

 if(strcmp(item,"Rename")==0)
   gtk_icon_list_set_active_icon(iconlist, active_icon);

}

static void
worksheet_popup_activated(GtkWidget *widget, gpointer data)
{
 gchar *item;
 GtkIconList *iconlist;
 SGworksheet *worksheet;

 item = (gchar *)data;
 iconlist = GTK_ICON_LIST(iconlist1);

 worksheet = (SGworksheet *) gtk_icon_list_get_link(active_icon);

 if(strcmp(item,"Open")==0)
   sg_worksheet_open(worksheet);

 if(strcmp(item,"Remove")==0){
   gint veto;
   gchar text[100];

   sprintf(text,"Remove %s ?", worksheet->name);

   veto = sg_accept_dialog(text, 1);
   if(veto != YES_CLICKED) return;

   sg_project_remove_worksheet(worksheet);
 }

 if(strcmp(item,"Rename")==0)
   gtk_icon_list_set_active_icon(iconlist, active_icon);

}


void
sg_project_build_popups()
{
        GtkWidget *item;
        int i;

        worksheet_popup = gtk_menu_new();

        for (i=0; i < (sizeof(popup_items)/sizeof(popup_items[0])) ; i++){
                item=gtk_menu_item_new_with_label(popup_items[i]);
                gtk_signal_connect(GTK_OBJECT(item),"activate",
                                   (GtkSignalFunc) worksheet_popup_activated,
                                   popup_items[i]);
                gtk_widget_show(item);
                gtk_menu_append(GTK_MENU(worksheet_popup),item);
        }

        plot_popup = gtk_menu_new();

        for (i=0; i < (sizeof(popup_items)/sizeof(popup_items[0])) ; i++){
                item=gtk_menu_item_new_with_label(popup_items[i]);
                gtk_signal_connect(GTK_OBJECT(item),"activate",
                                   (GtkSignalFunc) plot_popup_activated,
                                   popup_items[i]);
                gtk_widget_show(item);
                gtk_menu_append(GTK_MENU(plot_popup),item);
        }

}

GtkWidget *
sg_project_build_toolbar(GtkWidget *top_level)
{
  GnomeUIInfo main_toolbar[] =
  {
    GNOMEUIINFO_ITEM("New", "Create new project", sg_menu_new_project,
                     new_xpm),
    GNOMEUIINFO_ITEM("Open", "Open project", sg_menu_open,
                     open_xpm),
    GNOMEUIINFO_ITEM("Save", "Save project", sg_menu_save,
                     save_xpm),
    GNOMEUIINFO_SEPARATOR,

    GNOMEUIINFO_ITEM("Sheet", "Create new worksheet", sg_menu_new_worksheet, 
                      new_sheet_xpm),
    GNOMEUIINFO_ITEM("2D", "Create new plot", sg_menu_new_plot, 
                      new_2d_xpm),
    GNOMEUIINFO_ITEM("3D", "Create new 3D plot", sg_menu_new_plot_3d,
                      new_3d_xpm),
    GNOMEUIINFO_ITEM("Polar", "Create new polar plot", sg_menu_new_plot_polar, 
                      new_polar_xpm),
    GNOMEUIINFO_ITEM("Function", "Create new function", sg_menu_new_function, 
                      new_function_xpm),
    GNOMEUIINFO_END
  };
#ifdef WITH_GNOME
  gnome_app_create_toolbar(GNOME_APP(top_level), main_toolbar);
#else
  sg_ui_create_toolbar(GTK_BIN(top_level)->child, main_toolbar);
#endif
  return NULL;
}

static GnomeUIInfo new_menu[] = {
  {GNOME_APP_UI_ITEM, "P_roject",
   "Create new project",
   sg_menu_new_project, NULL,
   NULL, GNOME_APP_PIXMAP_DATA, new_small_xpm, 'r', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_Worksheet",
   "Create new worksheet",
   sg_menu_new_worksheet, NULL,
   NULL, GNOME_APP_PIXMAP_DATA, sheet_small_xpm, 'w', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "2D _Plot",
   "Create new plot",
   sg_menu_new_plot, NULL,
   NULL, GNOME_APP_PIXMAP_DATA, new_2d_small_xpm, 'p', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "3_D Plot",
   "Create new 3D plot",
   sg_menu_new_plot_3d, NULL,
   NULL, GNOME_APP_PIXMAP_DATA, new_3d_small_xpm, 'd', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "Po_lar Plot",
   "Create new polar plot",
   sg_menu_new_plot_polar, NULL,
   NULL, GNOME_APP_PIXMAP_DATA, new_polar_small_xpm, 'l', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_Function",
   "Create new function",
   sg_menu_new_function, NULL,
   NULL, GNOME_APP_PIXMAP_DATA, function_small_xpm, 'f', GDK_CONTROL_MASK},

   GNOMEUIINFO_END
 };

static GnomeUIInfo gnome_file_menu[] = {
   {GNOME_APP_UI_SUBTREE, "_New", "New",
    new_menu, "New",
    NULL, GNOME_APP_PIXMAP_DATA, new_small_xpm, 0, GDK_CONTROL_MASK},

   GNOMEUIINFO_ITEM("_Open", "Open file", sg_menu_open,
                    open_small_xpm),
   GNOMEUIINFO_ITEM("_Import", "Import file", sg_menu_import,
                    open_small_xpm),
   GNOMEUIINFO_ITEM("_Save", "Save file", sg_menu_save,
                    save_small_xpm),
   GNOMEUIINFO_ITEM("Save _As...", "Save As", sg_menu_save_as,
                    save_as_small_xpm),

   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM("E_xit", "Exit program", sg_menu_exit,
                    exit_small_xpm),
   GNOMEUIINFO_END
};

static GnomeUIInfo gnome_edit_menu[] = {
   GNOMEUIINFO_ITEM("Preferences", "Configure user preferences",
                    general_config_dialog,
                    preferences_small_xpm),
   GNOMEUIINFO_END
};

static GnomeUIInfo gnome_win_menu[] = {
    GNOMEUIINFO_ITEM("Python _terminal", "Open Python terminal window",
                     create_python_term, python_small_xpm),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM("_Configure", "Configure modules",
                     python_config_dialog, preferences_small_xpm),
    GNOMEUIINFO_END
 };



static GnomeUIInfo gnome_docs_menu[] = {
  {GNOME_APP_UI_ITEM, "_Introduction",
   "Introduction",
   sg_menu_doc, "Introduction.html",
   NULL, GNOME_APP_PIXMAP_DATA, book_small_xpm, 'i', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_Tutorial",
   "Tutorial",
   sg_menu_doc, "Tutorial.html",
   NULL, GNOME_APP_PIXMAP_DATA, book_small_xpm, 't', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_User's Guide",
   "User's Guide",
   sg_menu_doc, "UserGuide.html",
   NULL, GNOME_APP_PIXMAP_DATA, book_small_xpm, 'g', GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_FAQ",
   "FAQ",
   sg_menu_doc, "FAQ.html",
   NULL, GNOME_APP_PIXMAP_DATA, book_small_xpm, 'f', GDK_CONTROL_MASK},

   GNOMEUIINFO_END
 };

static GnomeUIInfo gnome_examples_menu[] = {
  {GNOME_APP_UI_ITEM, "_simpletest",
   "simpletest",
   sg_menu_example, "simpletest.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_ticks",
   "ticks",
   sg_menu_example, "ticks.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_multicolumn",
   "multicolumn",
   sg_menu_example, "multicolumn.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "t_rigonometric",
   "trigonometric",
   sg_menu_example, "trigonometric.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_vectors",
   "vectors",
   sg_menu_example, "vectors.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_3d",
   "3d",
   sg_menu_example, "3d.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_polar",
   "polar",
   sg_menu_example, "polar.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

  {GNOME_APP_UI_ITEM, "_image",
   "Image",
   sg_menu_example, "image.sg",
   NULL, GNOME_APP_PIXMAP_DATA, sg_small_xpm, 0, GDK_CONTROL_MASK},

   GNOMEUIINFO_END
 };


GnomeUIInfo gnome_help_menu[] = {
    GNOMEUIINFO_HELP("scigraphica"),
#ifndef WITH_GNOME
    {GNOME_APP_UI_SUBTREE, "_Documentation", "Documentation",
     gnome_docs_menu, "Documentation",
     NULL, GNOME_APP_PIXMAP_DATA, book_small_xpm, 'd', GDK_CONTROL_MASK},
#endif
    {GNOME_APP_UI_SUBTREE, "_Examples", "Examples",
     gnome_examples_menu, "Examples",
     NULL, GNOME_APP_PIXMAP_DATA, exec_small_xpm, 'e', GDK_CONTROL_MASK},

    GNOMEUIINFO_SEPARATOR,

    {GNOME_APP_UI_ITEM,
    "_About", "About SciGraphica",
    sg_about_dialog, NULL, NULL,
    GNOME_APP_PIXMAP_DATA, about_small_xpm,
    0, 0, NULL},

    GNOMEUIINFO_END
};

static GnomeUIInfo gnome_main_menu[] = {
   GNOMEUIINFO_SUBTREE("_File", gnome_file_menu),
   GNOMEUIINFO_SUBTREE("_Edit", gnome_edit_menu),
   GNOMEUIINFO_SUBTREE("_Script", gnome_win_menu),
   GNOMEUIINFO_SUBTREE("_Help", gnome_help_menu),

   GNOMEUIINFO_END
 };

GtkWidget *
sg_project_build_menu(GtkWidget *app)
{
#ifdef WITH_GNOME
  gnome_app_create_menus(GNOME_APP(app), gnome_main_menu);
#else
  sg_ui_create_menus(GTK_BIN(app)->child, gnome_main_menu);
#endif
  
  return NULL;
}

void
sg_menu_exit(GtkWidget *widget, gpointer data)
{
  sg_dialogs_destroy();

  if(project_changed){
    gchar label[255];
    g_snprintf(label, 255, "Save project \"%s\" before leaving?", last_project_filename);
    switch( sg_accept_dialog(label, 0) ) {
      case YES_CLICKED:
        sg_menu_save(widget, data);
      case NO_CLICKED:
        break;
      case CANCEL_CLICKED:
        return;
    }
  }
  pickle_file(rcfile, main_dict, sg_dict, save_vars);
  main_quit(widget);
}

static void
sg_menu_new_plot(GtkWidget *widget, gpointer data)
{
  sg_project_new_plot_with_layer(SG_PLOT_2D);
}

static void
sg_menu_new_plot_3d(GtkWidget *widget, gpointer data)
{
  sg_project_new_plot_with_layer(SG_PLOT_3D);
}

static void
sg_menu_new_plot_polar(GtkWidget *widget, gpointer data)
{
  sg_project_new_plot_with_layer(SG_PLOT_POLAR);
}

static void
sg_menu_new_worksheet(GtkWidget *widget, gpointer data)
{
  sg_project_new_worksheet();
}

static void
sg_menu_new_function(GtkWidget *widget, gpointer data)
{
  sg_function_dialog_new();
}

static void
sg_menu_new_project(GtkWidget *widget, gpointer data)
{
  if(project_changed){
    gchar label[80];
    g_snprintf(label, 80, "Save project \"%s\" ?", last_project_filename);
    switch ( sg_accept_dialog(label, 0) ){
      case YES_CLICKED:
         sg_menu_save(widget, data);
         break;
      case NO_CLICKED:
         break;
      case CANCEL_CLICKED:
         return;
    }
  }

  sg_project_close();
  sg_project_new();
  sg_project_new_worksheet();
  sg_project_changed(FALSE);
}

static void
sg_menu_open(GtkWidget *widget, gpointer data)
{
/*
  if(project_changed){
    gchar label[80];
    g_snprintf(label, 80, "Save project \"%s\" ?", last_project_filename);
    switch ( sg_accept_dialog(label, 0) ){
      case YES_CLICKED:
         sg_menu_save(widget, data);
         break;
      case NO_CLICKED:
         break;
      case CANCEL_CLICKED:
         return;
    }
  }
*/

  sg_project_open();
}

static void
sg_menu_import(GtkWidget *widget, gpointer data)
{
  sg_project_import();
}


static void
sg_menu_save(GtkWidget *widget, gpointer data)
{
  sg_project_export();
}

static void
sg_menu_save_as(GtkWidget *widget, gpointer data)
{
  sg_project_export_as();
}

static void
sg_menu_load_script(GtkWidget *widget, gpointer data)
{
  sg_script_import();
}

static void
sg_menu_doc(GtkWidget *widget, gpointer data)
{
 gchar path[250];
 gchar command[250];

 if ( getenv("SG_ROOT") )
    g_snprintf(path, 250, "%s/share/gnome/help/scigraphica/C/%s", getenv("SG_ROOT"), (gchar*)data);
 else
    g_snprintf(path, 250, SG_ROOT "/share/gnome/help/scigraphica/C/%s", (gchar*)data);

 if ( getenv("SG_DOCVIEWER") )
    {gchar string[250];
     g_snprintf(string, 250, "%s &", getenv("SG_DOCVIEWER"));
     g_snprintf(command, 250, string, path, path);
    }
 else
    g_snprintf(command, 250, SG_DOCVIEWER " &", path, path);

 system(command);
}

static void
sg_menu_example(GtkWidget *widget, gpointer data)
{
 gchar path[250];

 if(project_changed){
   g_snprintf(path, 250, "Save project \"%s\" ?", last_project_filename);
   switch ( sg_accept_dialog(path, 0) ){
     case YES_CLICKED:
        sg_menu_save(widget, data);
       break;
     case NO_CLICKED:
       break;
     case CANCEL_CLICKED:
       return;
   }
 }

 if ( getenv("SG_ROOT") )
    g_snprintf(path, 250, "%s/share/scigraphica/examples/%s", getenv("SG_ROOT"), (gchar*)data);
 else
    g_snprintf(path, 250, SG_ROOT "/share/scigraphica/examples/%s", (gchar*)data);

 sg_project_close();
 sg_project_new();
 sg_project_file_import_xml(path, NULL, NULL);
 sg_project_changed(FALSE);
}
