/*
rnd2.c - random number generator based on 16 byte seed
Version 1.3.0
Copyright (C) 1999-2005  dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/*
Usage:
   	void rnd(unsigned char *sd);
*/

/*
Called by:
	unsigned int rndpwr(int bits,
		unsigned char *sd);
*/

/*
initialize the seed with:
   	unsigned char *sd;
   	sd = (unsigned char *) rndinit();
*/

/*
rnd2.c replaces rnd.s for non-Intel platforms
To compile on non-Intel platforms:

	make -f nonintel.mak

rnd2.c is 20x slower than rnd.s
Run parallel test between Intel and non-Intel
platforms using same seed.  Verify that generated
data is identical.
*/

#define SEEDLEN 16
#define HALFLEN 8
#define BYTESIZE 8

int rnd(sd)
unsigned char *sd;
   {
   int i,j,k;
   unsigned char sd2[SEEDLEN+16];
   unsigned char *p,*q,*r;
   p = sd;
   q = sd2;
   r = p + SEEDLEN;
   k = 0;
   while (p < r)
      {
      j = (*p++ << 1) | k;
      k = (j >> BYTESIZE) & 1;
      *q++ = (unsigned char) j & 255;
      }
   p = sd + HALFLEN;
   q = sd;
   r = p + HALFLEN;
   k = 0;
   while (p < r)
      {
      j = *p + *q++ + k;
      k = (j >> BYTESIZE) & 1;
      *p++ = (unsigned char) j & 255;
      }
   p = sd;
   q = sd2;
   r = p + SEEDLEN;
   k = 0;
   while (p < r)
      {
      j = *p + *q++ + k;
      k = (j >> BYTESIZE) & 1;
      *p++ = (unsigned char) j & 255;
      }
   p = (unsigned char *) sd + 15;
   i = (int) *p >> 7;
   return(i);
   } /* rnd */
