/*
rndnum2.c - random number generator
	generates random number with normal distribution
	from 0 to 2^32 - 1
Version 1.3.0
Copyright (C) 1999-2005  dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/*
Usage:
    	unsigned int i;
    	i = rndnum(unsigned int lim, unsigned char *sd);
    	where lim is 1 to 2^32 - 1
*/

/*
Subroutine calls:
    	unsigned int i;
	i = rndpwr(int bits, unsigned char *sd);
*/

#include <math.h>
#define MODBITS 32

unsigned int rndnum(lim,sd)
unsigned int lim;
unsigned char *sd;
	{
	unsigned int rslt,pwr;
	double dblfact,dbllim,modulus,dblrslt;
	unsigned int rndpwr();
	dbllim = (double) lim;
	modulus = pow(2.0,32.0);
	pwr = rndpwr(MODBITS,sd);
	dblfact  = (double) pwr;
	dblfact *= dbllim;
	dblfact /= modulus;
	dblrslt  = floor(dblfact); 
	rslt = (unsigned int) dblrslt; 
	return(rslt);
	} /* rndnum */
