/* c1i_top.c Version 0.3.2. Class I Icosahedron */
/* Top Triangle */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor */
/*       Boston, MA  02110-1301, USA */

/*									*/
/*      C1I_TOP: class I icosahedron, top triangle                      */
/*									*/

#include "strlen.h"

void c1i_top(xwfmt *xw)
   {
   int x,y,z;
   int exx1,wyy1,zee1;
   int exx2,wyy2,zee2;
   int row;
   int trunc;
   int node,nodefrom,nodeto;
   int rowlmt;
   int xlmt;
   double dblx,dbly,dblz;
   double x1,y1,z1;
   double halffreq;
   double root;
   double phi,theta;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *xlstptr;
   int *ylstptr;
   int *zlstptr;
   double *philstptr;
   double *thetalstptr;
   rowlmt = xw->freq + 1;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   philstptr   = xw->philst;
   thetalstptr = xw->thetalst;
   xlstptr     = xw->xlst;
   ylstptr     = xw->ylst;
   zlstptr     = xw->zlst;
   halffreq = (double) xw->freq * 0.5;
   node = xw->totvtx = 0;
   for (row=0;row<rowlmt;row++)
      {
      trunc = row % 3;
      xlmt = row + 1;
      for (x=0;x<xlmt;x++)
         {
         y = row - x;
         z = xw->freq - x - y;
         dblx = (double) x;
         dbly = (double) y;
         dblz = (double) z;
         x1 = dblx * xw->sin72;
         y1 = dbly + (dblx * xw->cos72);
         z1 = halffreq + (dblz * xw->oneovertau);
	 /* cotangent = x/y */
         if (y1 == 0.0)
            {
            if (x1 == 0.0) phi = 0.0;
            else
               {
               phi = xw->rad90;
               } /* atan2 err */
            } /* if divide by zero */
         else phi = atan2(x1,y1);
         root  = sqrt((x1 * x1) + (y1 * y1));
         theta = atan2(root,z1);
         if (x < row)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
                  *vtxtoptr++   = node + 1;
                  xw->totvtx++;
	          } /* if trunc == 1 */
	       } /* if buckyball */
	    else
	       {
               *vtxfromptr++ = node;
               *vtxtoptr++   = node + 1;
               xw->totvtx++;
	       } /* else not buckyball */
            } /* if x < row */
         if (row < xw->freq)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 1;
                  xw->totvtx++;
	          } /* if trunc == 1 */
	       else if (trunc == 2)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 2;
                  xw->totvtx++;
	          } /* if trunc == 2 */
	       } /* if buckyball */
	    else
	       {
	       *vtxfromptr++ = node;
	       *vtxfromptr++ = node;
	       *vtxtoptr++   = node + row + 1;
	       *vtxtoptr++   = node + row + 2;
	       xw->totvtx   += 2;
	       } /* else not buckyball */
            } /* if x < row */
         *philstptr++   = phi;
         *thetalstptr++ = theta;
         *xlstptr++ = x;
         *ylstptr++ = y;
         *zlstptr++ = z;
	 trunc = ++trunc % 3;
         node++;
         } /* for each x */
      } /* for each row */
   xw->totnode = node;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   printf("Polar triangles\n");
   while (vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      phi1   = *(xw->philst+nodefrom);
      theta1 = *(xw->thetalst+nodefrom);
      phi2   = *(xw->philst+nodeto);
      theta2 = *(xw->thetalst+nodeto);
      exx1   = *(xw->xlst+nodefrom);
      wyy1   = *(xw->ylst+nodefrom);
      zee1   = *(xw->zlst+nodefrom);
      exx2   = *(xw->xlst+nodeto);
      wyy2   = *(xw->ylst+nodeto);
      zee2   = *(xw->zlst+nodeto);
      /* northern hemisphere */
      putlen(xw,nodefrom,nodeto,
         exx1,wyy1,zee1,exx2,wyy2,zee2,
         phi1,theta1,phi2,theta2);
      if (xw->spheresw)
         {
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad216,theta1,
            phi2+xw->rad216,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad288,theta1,
            phi2+xw->rad288,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad36,xw->rad180-theta1,
            phi2+xw->rad36,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad108,xw->rad180-theta1,
            phi2+xw->rad108,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad180,xw->rad180-theta1,
            phi2+xw->rad180,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad252,xw->rad180-theta1,
            phi2+xw->rad252,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,exx2,wyy2,zee2,
            phi1+xw->rad324,xw->rad180-theta1,
            phi2+xw->rad324,xw->rad180-theta2);
         } /* if entire sphere */
      } /* for each node */
   } /* c1i_top */
