#!/usr/bin/make

# strlen.mak Version 0.3.2. Compile strlen.c.
# Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

# Xdome is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# Xdome is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	51 Franklin St, Fifth Floor
# 	Boston, MA  02110-1301, USA

OBJ=strlen.o \
	domemain.o \
	bld.o \
	calc_c1.o \
	calc_c1i.o \
	c1i_top.o \
	c1i_side.o \
	calc_c1o.o \
	c1o_top.o \
	calc_c1t.o \
	c1t_top.o \
	c1t_side.o \
	calc_c2.o \
	calc_c2i.o \
	c2i_top.o \
	c2i_side.o \
	c2i_ne.o \
	c2i_se.o \
	c2i_nw.o \
	c2i_sw.o \
	calc_c2o.o \
	c2o_top.o \
	c2o_side.o \
	c2o_east.o \
	c2o_west.o \
	calc_c2t.o \
	c2t_top.o \
	c2t_side.o \
	c2t_east.o \
	c2t_west.o \
	putlen.o \
	putstat.o \
	putstx.o \
	about.o \
	shwparm.o

CC=gcc

CFLAGS=-c -Wall -O6

LDFLAGS=-L. -lstrlen -lm

all:		$(OBJ) libstrlen.a strlen strlen.mak

strlen:		$(OBJ)
	$(CC) -Wall -O6 strlen.o -o strlen $(LDFLAGS)

libstrlen.a:		$(OBJ)
	rm -f libstrlen.a
	ar r libstrlen.a $(OBJ)

strlen.o:		strlen.c
	$(CC) $(CFLAGS) strlen.c

putstx.o:		putstx.c
	$(CC) $(CFLAGS) putstx.c

about.o:		about.c
	$(CC) $(CFLAGS) about.c

shwparm.o:		shwparm.c
	$(CC) $(CFLAGS) shwparm.c

domemain.o:		domemain.c
	$(CC) $(CFLAGS) domemain.c

bld.o:			bld.c
	$(CC) $(CFLAGS) bld.c

calc_c1.o:		calc_c1.c
	$(CC) $(CFLAGS) calc_c1.c

calc_c1i.o:		calc_c1i.c
	$(CC) $(CFLAGS) calc_c1i.c

c1i_top.o:		c1i_top.c
	$(CC) $(CFLAGS) c1i_top.c

c1i_side.o:		c1i_side.c
	$(CC) $(CFLAGS) c1i_side.c

calc_c1o.o:		calc_c1o.c
	$(CC) $(CFLAGS) calc_c1o.c

c1o_top.o:		c1o_top.c
	$(CC) $(CFLAGS) c1o_top.c

calc_c1t.o:		calc_c1t.c
	$(CC) $(CFLAGS) calc_c1t.c

c1t_top.o:		c1t_top.c
	$(CC) $(CFLAGS) c1t_top.c

c1t_side.o:		c1t_side.c
	$(CC) $(CFLAGS) c1t_side.c

calc_c2.o:		calc_c2.c
	$(CC) $(CFLAGS) calc_c2.c

calc_c2i.o:		calc_c2i.c
	$(CC) $(CFLAGS) calc_c2i.c

c2i_top.o:		c2i_top.c
	$(CC) $(CFLAGS) c2i_top.c

c2i_side.o:		c2i_side.c
	$(CC) $(CFLAGS) c2i_side.c

c2i_ne.o:		c2i_ne.c
	$(CC) $(CFLAGS) c2i_ne.c

c2i_se.o:		c2i_se.c
	$(CC) $(CFLAGS) c2i_se.c

c2i_nw.o:		c2i_nw.c
	$(CC) $(CFLAGS) c2i_nw.c

c2i_sw.o:		c2i_sw.c
	$(CC) $(CFLAGS) c2i_sw.c

calc_c2o.o:		calc_c2o.c
	$(CC) $(CFLAGS) calc_c2o.c

c2o_top.o:		c2o_top.c
	$(CC) $(CFLAGS) c2o_top.c

c2o_side.o:		c2o_side.c
	$(CC) $(CFLAGS) c2o_side.c

c2o_east.o:		c2o_east.c
	$(CC) $(CFLAGS) c2o_east.c

c2o_west.o:		c2o_west.c
	$(CC) $(CFLAGS) c2o_west.c

calc_c2t.o:		calc_c2t.c
	$(CC) $(CFLAGS) calc_c2t.c

c2t_top.o:		c2t_top.c
	$(CC) $(CFLAGS) c2t_top.c

c2t_side.o:		c2t_side.c
	$(CC) $(CFLAGS) c2t_side.c

c2t_east.o:		c2t_east.c
	$(CC) $(CFLAGS) c2t_east.c

c2t_west.o:		c2t_west.c
	$(CC) $(CFLAGS) c2t_west.c

putlen.o:		putlen.c
	$(CC) $(CFLAGS) putlen.c

putstat.o:		putstat.c
	$(CC) $(CFLAGS) putstat.c

clean:
	rm -f strlen libstrlen.a $(OBJ)
