/* bld.c Version 0.3.2. build dome on screen */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

void bld(xwfmt *xw)
   {
   int i;
   int foregr;
   double *phifromptr;
   double *thetafromptr;
   double *phitoptr;
   double *thetatoptr;
   double phi1,phi2;
   double theta1,theta2;
   double rotphi1,rotphi2;
   double exx1,wyy1,zee1;
   double exx2,wyy2,zee2;

   while (xw->runflg)
      {
      XClearWindow(xw->dpy,xw->w);
      shwmenu(xw);
      phifromptr   = (double *) xw->phifrom;
      thetafromptr = (double *) xw->thetafrom;
      phitoptr     = (double *) xw->phito;
      thetatoptr   = (double *) xw->thetato;
      i = xw->totstr;
      while (i--)
         {
	 phi1   = *phifromptr++;
	 theta1 = *thetafromptr++;
	 phi2   = *phitoptr++;
	 theta2 = *thetatoptr++;
	 if (phi1 < 0.0 || phi1 > 360.0)
	    {
	    fprintf(stderr,"vertex %d\n",
	       xw->totstr - i);
	    fprintf(stderr,"bld: invalid "
	       "phi1 %f\n",
	       phi1);
	    vfyfree(xw);
	    exit(1);
	    } /* if invalid */
	 if (theta1 < 0.0 || theta1 > 180.0)
	    {
	    fprintf(stderr,"vertex %d\n",
	       xw->totstr - i);
	    fprintf(stderr,"bld: invalid "
	       "theta1 %f\n",
	       theta1);
	    vfyfree(xw);
	    exit(1);
	    } /* if invalid */
	 if (phi2 < 0.0 || phi2 > 360.0)
	    {
	    fprintf(stderr,"vertex %d\n",
	       xw->totstr - i);
	    fprintf(stderr,"bld: invalid "
	       "phi2 %f\n",
	       phi2);
	    vfyfree(xw);
	    exit(1);
	    } /* if invalid */
	 if (theta2 < 0.0 || theta2 > 180.0)
	    {
	    fprintf(stderr,"vertex %d\n",
	       xw->totstr - i);
	    fprintf(stderr,"bld: invalid "
	       "theta2 %f\n",
	       theta2);
	    vfyfree(xw);
	    exit(1);
	    } /* if invalid */
	 rotphi1 = phi1 + xw->hrot;
	 if (rotphi1 >= 360.0)
	    rotphi1 -= 360.0;
	 rotphi2 = phi2 + xw->hrot;
	 if (rotphi2 >= 360.0)
	    rotphi2 -= 360.0;
	 if (xw->ecc == 1.0)
	    {
	    exx1 = sin(theta1 * xw->d2r)
	       * cos(rotphi1 * xw->d2r);
	    wyy1 = sin(theta1 * xw->d2r)
	       * sin(rotphi1 * xw->d2r);
	    zee1 = cos(theta1 * xw->d2r);
	    exx2 = sin(theta2 * xw->d2r)
	       * cos(rotphi2 * xw->d2r);
	    wyy2 = sin(theta2 * xw->d2r)
	       * sin(rotphi2 * xw->d2r);
	    zee2 = cos(theta2 * xw->d2r);
	    } /* if no eccentricity */
	 else if (xw->ecc < 1.0)
	    {
	    exx1 = sin(theta1 * xw->d2r)
	       * cos(rotphi1 * xw->d2r)
	       * xw->ecc;
	    wyy1 = sin(theta1 * xw->d2r)
	       * sin(rotphi1 * xw->d2r);
	    zee1 = cos(theta1 * xw->d2r)
	       * xw->ecc;
	    exx2 = sin(theta2 * xw->d2r)
	       * cos(rotphi2 * xw->d2r)
	       * xw->ecc;
	    wyy2 = sin(theta2 * xw->d2r)
	       * sin(rotphi2 * xw->d2r);
	    zee2 = cos(theta2 * xw->d2r)
	       * xw->ecc;
	    } /* if horizontal eccentricity */
	 else /* if (xw->ecc > 1.0) */
	    {
	    exx1 = sin(theta1 * xw->d2r)
	       * cos(rotphi1 * xw->d2r)
	       / xw->ecc;
	    wyy1 = sin(theta1 * xw->d2r)
	       * sin(rotphi1 * xw->d2r)
	       / xw->ecc;
	    zee1 = cos(theta1 * xw->d2r);
	    exx2 = sin(theta2 * xw->d2r)
	       * cos(rotphi2 * xw->d2r)
	       / xw->ecc;
	    wyy2 = sin(theta2 * xw->d2r)
	       * sin(rotphi2 * xw->d2r)
	       / xw->ecc;
	    zee2 = cos(theta2 * xw->d2r);
	    } /* if vertical eccentricity */
         foregr = 0;
	 if (xw->view == FRONT)
	    {
	    if (rotphi1 <= 108.0
	       && rotphi2 <= 108.0)
	       foregr = 1;
	    /* 270 - 18 = 252 */
	    else if (rotphi1 >= 252.0
	       && rotphi2 >= 252.0)
	       foregr = 1;
	    else if (rotphi1 < 90.0
	       && rotphi2 > 270.0)
	       foregr = 1;
	    else if (rotphi2 < 90.0
	       && rotphi1 > 270.0)
	       foregr = 1;
	    else
	       foregr = 0;
	    } /* if front view */
	 else if (xw->view == TOP)
	    {
	    if (theta1 <= 90.0
	       && theta2 <= 90.0)
	       foregr = 1;
	    else
	       foregr = 0;
	    } /* if top view */
	 if (foregr)
	    {
            drawspin(xw,
	       exx1, wyy1, zee1,
	       exx2, wyy2, zee2);
	    } /* if foreground */
         } /* for each vertex in dome */
      getkey(xw);
      } /* for each rotation */
   }  /* bld */
