#!/usr/bin/make

# spin.mak Version 0.3.2. Compile spin.c.
# Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

# Xdome is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# Xdome is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	51 Franklin St, Fifth Floor
# 	Boston, MA  02110-1301, USA

# Make sure that the Debian font package xfonts-base
# is installed on your system.  Or have the equivalent
# of xfonts-base installed.

# Debian font
XFONT=\"7x13\"

# uncomment if you want the dome window in
# the upper left of your virtual desktop
# UPPERLEFT=-D UPPERLEFT

OBJ=spin.o \
	vfyinit.o \
	vfyfree.o \
	initx.o \
	spinmenu.o \
	parse.o \
	getspec.o \
	getpolar.o \
	getphi.o \
	bldspin.o \
	rotate.o \
	drawspin.o \
	getkey.o \
	getln.o \
	getbyte.o

CC=gcc

CFLAGS=-c -Wall -O6 -I. \
	-I/usr/X11R6/include/X11 \
        -DFONT=$(XFONT) \
	$(UPPERLEFT)

LDFLAGS=-L/usr/X11R6/lib -lX11 -lm

XXXCFLAGS=-c -Wall -O6 -I. \
	-I../xdome \
        -DFONT=$(XFONT) \
	$(UPPERLEFT)

XXXLDFLAGS=-L/usr/X11R6/lib -lX11 \
	-L../xdome -lxdome -lm

all:		$(OBJ) spin

spin:			$(OBJ)
	$(CC) -Wall -O6 $(OBJ) -o spin $(LDFLAGS)

spin.o:			spin.c
	$(CC) $(CFLAGS) spin.c

vfyinit.o:		vfyinit.c
	$(CC) $(CFLAGS) vfyinit.c

vfyfree.o:		vfyfree.c
	$(CC) $(CFLAGS) vfyfree.c

initx.o:		initx.c
	$(CC) $(CFLAGS) initx.c

spinmenu.o:		spinmenu.c
	$(CC) $(CFLAGS) spinmenu.c

parse.o:		parse.c
	$(CC) $(CFLAGS) parse.c

getspec.o:		getspec.c
	$(CC) $(CFLAGS) getspec.c

getpolar.o:		getpolar.c
	$(CC) $(CFLAGS) getpolar.c

getphi.o:		getphi.c
	$(CC) $(CFLAGS) getphi.c

bldspin.o:		bldspin.c
	$(CC) $(CFLAGS) bldspin.c

rotate.o:		rotate.c
	$(CC) $(CFLAGS) rotate.c

drawspin.o:		drawspin.c
	$(CC) $(CFLAGS) drawspin.c

getkey.o:		getkey.c
	$(CC) $(CFLAGS) getkey.c

getln.o:		getln.c
	$(CC) $(CFLAGS) getln.c

getbyte.o:		getbyte.c
	$(CC) $(CFLAGS) getbyte.c

clean:
	rm -f spin $(OBJ)
