/* vfyinit.c Version 0.3.2. initialize global variables */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      VFYINIT: Initialize global variables                            */
/*									*/

#include "verify.h"

void vfyinit(xwfmt *xw)
   {
   xw->phifrom = (double *) malloc(MAXSTR * sizeof(double));
   if (xw->phifrom == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating phifrom\n");
      exit(1);
      } /* out of mem */
   xw->thetafrom = (double *) malloc(MAXSTR * sizeof(double));
   if (xw->thetafrom == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating thetafrom\n");
      exit(1);
      } /* out of mem */
   xw->phito = (double *) malloc(MAXSTR * sizeof(double));
   if (xw->phito == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating phito\n");
      exit(1);
      } /* out of mem */
   xw->thetato = (double *) malloc(MAXSTR * sizeof(double));
   if (xw->thetato == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating thetato\n");
      exit(1);
      } /* out of mem */
   xw->class    = CLASS_I;
   xw->dometype = ICOSA;
   xw->freq     = 3;
   xw->bball    = 0;
   xw->ecc      = 1.0;
   xw->shift    = 0;
   xw->view     = FRONT;
   xw->spin = xw->hrot = xw->vrot = 0.0;
   xw->wtfact   = 0;
   xw->runflg   = 1;
   xw->d2r = M_PI / 180.0;
   xw->r2d = 180.0 / M_PI;
   xw->totstr = 0;
   } /* vfyinit */
