/* c1i_back_top.c Version 0.3.2. Class I Icosahedron */
/* Back View, Top Triangle */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C1I_BACK_TOP: class I icosahedron, back view                    */
/*                     top triangle                                     */
/*									*/

#include "xdome.h"

void c1i_back_top(xwfmt *xw)
   {
   int x,y,z;
   int row;
   int trunc;
   int node;
   int nodefrom;
   int nodeto;
   int rowlmt;
   int xlmt;
   double dblx,dbly,dblz;
   double x1,y1,z1;
   double halffreq;
   double root;
   double phi,theta;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   double leftmidphi;
   double rghttophi;
   double northmidphi;
   double southmidphi;
   double *philstptr;
   double *thetalstptr;
   halffreq    = (double) xw->freq * 0.5;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   topfromptr  = (int *) xw->topfrom;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   philstptr   = (double *) xw->philst;
   thetalstptr = (double *) xw->thetalst;
   xw->tottri = node = xw->totvtx = 0;
   rowlmt      = xw->freq + 1;
   for (row=0;row<rowlmt;row++)
      {
      trunc = row % 3;
      xlmt = row + 1;
      for (x=0;x<xlmt;x++)
         {
         y = row - x;
         z = xw->freq - x - y;
         dblx = (double) x;
         dbly = (double) y;
         dblz = (double) z;
         x1 = dblx * xw->sin72;
         y1 = dbly + (dblx * xw->cos72);
         z1 = halffreq + (dblz * xw->oneovertau);
         /* cotangent = x/y */
         if (y1 == 0.0)
            {
            if (x1 == 0.0) phi = 0.0;
            else
               {
               phi = xw->rad90;
               } /* atan2 err */
            } /* if divide by zero */
         else phi = atan2(x1,y1);
         root  = sqrt((x1 * x1) + (y1 * y1));
         theta = atan2(root,z1);
         if (x < row)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
                  *vtxtoptr++   = node + 1;
                  xw->totvtx++;
                  *bbmidptr++   = node + row + 2;
	          } /* if trunc == 1 */
	       } /* if buckyball */
            } /* if x < row */
         if (row < xw->freq)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
		  /* northwest and southeast */
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 1;
                  xw->totvtx++;
		  /* buckyball mid point */
                  *bbmidptr++ = node - 1;
	          } /* if trunc == 1 */
	       else if (trunc == 2)
	          {
		  /* northeast and southwest */
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 2;
                  xw->totvtx++;
                  *bbmidptr++    = node + row + 1;
	          } /* if trunc == 2 */
	       } /* if buckyball */
	    else     /* not buckyball */
	       {
	       if (x < row)
		  {
	          /* upside down triangle */
                  *topfromptr++  = node + row + 2;
                  *lefttoptr++   = node;
                  *rghttoptr++   = node + 1;
                  xw->tottri++;
		  } /* if x < row */
	       /* right side up triangle */
               *topfromptr++  = node;
               *lefttoptr++   = node + row + 1;
               *rghttoptr++   = node + row + 2;
               xw->tottri++;
	       } /* not buckyball */
            } /* if row < xw->freq */
         *philstptr++   = phi;
         *thetalstptr++ = theta;
	 trunc = ++trunc % 3;
         node++;
         } /* for each x in row */
      } /* for each row */
   xw->totnode = node;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   vtxendptr   = (int *) xw->vtxfrom      + xw->totvtx;
   topfromptr  = (int *) xw->topfrom;
   topfromend  = (int *) xw->topfrom      + xw->tottri;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      phi1        = *(xw->philst+topfromvtx)  + xw->rad72;
      phi2        = *(xw->philst+lefttovtx)   + xw->rad72;
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philst+rghttovtx)   + xw->rad72;
      northmidphi = (leftmidphi + rghttophi) * 0.5;
      phi1        = *(xw->philst+topfromvtx)  + xw->rad36;
      phi2        = *(xw->philst+lefttovtx)   + xw->rad36;
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philst+rghttovtx)   + xw->rad36;
      southmidphi = (leftmidphi + rghttophi) * 0.5;

      /* base strut */
      phi1     = *(xw->philst  +basefrom);
      theta1   = *(xw->thetalst+basefrom);
      phi2     = *(xw->philst  +baseto);
      theta2   = *(xw->thetalst+baseto);
      /* northern hemisphere */
      drawchord(xw,phi1,theta1,
         phi2,theta2);
      drawchord(xw,-phi1,theta1,
         -phi2,theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,-phi1-xw->rad72,theta1,
            -phi2-xw->rad72,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1-xw->rad36,xw->rad180-theta1,
         phi2-xw->rad36,xw->rad180-theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,xw->rad180-theta1,
            phi2+xw->rad36,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad36,xw->rad180-theta1,
            -phi2-xw->rad36,xw->rad180-theta2);
	 } /* else foreground */
      /* left strut */
      phi1     = *(xw->philst  +topfromvtx);
      theta1   = *(xw->thetalst+topfromvtx);
      phi2     = *(xw->philst  +lefttovtx);
      theta2   = *(xw->thetalst+lefttovtx);
      /* northern hemisphere */
      drawchord(xw,phi1,theta1,
         phi2,theta2);
      drawchord(xw,-phi1,theta1,
         -phi2,theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,-phi1-xw->rad72,theta1,
            -phi2-xw->rad72,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1-xw->rad36,xw->rad180-theta1,
         phi2-xw->rad36,xw->rad180-theta2);
      drawchord(xw,phi1+xw->rad36,xw->rad180-theta1,
         phi2+xw->rad36,xw->rad180-theta2);
      drawchord(xw,-phi1-xw->rad36,xw->rad180-theta1,
         -phi2-xw->rad36,xw->rad180-theta2);
      /* right strut */
      phi1     = *(xw->philst  +topfromvtx);
      theta1   = *(xw->thetalst+topfromvtx);
      phi2     = *(xw->philst  +rghttovtx);
      theta2   = *(xw->thetalst+rghttovtx);
      /* northern hemisphere */
      drawchord(xw,phi1,theta1,
         phi2,theta2);
      drawchord(xw,-phi1,theta1,
         -phi2,theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,-phi1-xw->rad72,theta1,
            -phi2-xw->rad72,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1-xw->rad36,xw->rad180-theta1,
         phi2-xw->rad36,xw->rad180-theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,xw->rad180-theta1,
            phi2+xw->rad36,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad36,xw->rad180-theta1,
            -phi2-xw->rad36,xw->rad180-theta2);
	 } /* else foreground */
      } /* for each triangle */
   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom    = *vtxfromptr++;
      nodeto      = *vtxtoptr++;
      bbmidvtx    = *bbmidptr++;
      northmidphi = *(xw->philst+bbmidvtx) + xw->rad72;
      southmidphi = *(xw->philst+bbmidvtx) + xw->rad36;

      phi1     = *(xw->philst  +nodefrom);
      theta1   = *(xw->thetalst+nodefrom);
      phi2     = *(xw->philst  +nodeto);
      theta2   = *(xw->thetalst+nodeto);
      /* northern hemisphere */
      drawchord(xw,phi1,theta1,
         phi2,theta2);
      drawchord(xw,-phi1,theta1,
         -phi2,theta2);
      if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,-phi1-xw->rad72,theta1,
            -phi2-xw->rad72,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1-xw->rad36,xw->rad180-theta1,
         phi2-xw->rad36,xw->rad180-theta2);
      if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,xw->rad180-theta1,
            phi2+xw->rad36,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad36,xw->rad180-theta1,
            -phi2-xw->rad36,xw->rad180-theta2);
	 } /* else foreground */
      } /* for each buckyball strut */
   } /* c1i_back_top */
