/* c2o_top_east.c Version 0.3.2. Class II Octahedron */
/* Top View, East Side Triangle */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2O_TOP_SIDE_EAST: class II octahedron, top view                */
/*                     east side triangle                               */
/*									*/

#include "xdome.h"

void c2o_top_east(xwfmt *xw)
   {
   int nodefrom,nodeto;
   double phi,theta;
   double newphi,newtheta;
   double phi1,theta1,phi2,theta2;
   double phimed,thetamed;
   double diff;
   double prod1,prod2,prod3;
   double dvsr,quotient;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   double *philstptr;
   double *thetalstptr;
   double *phiendptr;
   double *philowptr;
   double *thetalowptr;
   philstptr   = xw->philst;
   phiendptr   = xw->philst + xw->totnode;
   thetalstptr = xw->thetalst;
   philowptr   = xw->philow;
   thetalowptr = xw->thetalow;
   phimed      = xw->rad45;
   thetamed    = xw->rad45;
   while (philstptr < phiendptr)
      {
      phi   = (*philstptr++) - xw->rad90;
      theta = (*thetalstptr++);
      diff = phimed - phi;
      prod1 = cos(thetamed+thetamed) * cos(theta);
      prod2 = sin(thetamed+thetamed)
         * sin(theta) * cos(diff);
      newtheta = acos(prod1+prod2);
      prod3 = sin(theta) * sin(diff);
      dvsr = sin(newtheta);
      if (dvsr == 0.0)   /* should never happen */
         {
         printf("Divide by zero\n");
         exit(1);
         } /* divide by zero */
      quotient = prod3 / dvsr;
      newphi = asin(quotient) + xw->rad45;
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      } /* for each node in philst */
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   while (vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      phi1   = *(xw->philow+nodefrom);
      theta1 = *(xw->thetalow+nodefrom);
      phi2   = *(xw->philow+nodeto);
      theta2 = *(xw->thetalow+nodeto);
      if (theta1 <= xw->rad90)
         {
         drawchord(xw,phi1,theta1,phi2,theta2);
         drawchord(xw,phi1+xw->rad90,theta1,
            phi2+xw->rad90,theta2);
         drawchord(xw,phi1+xw->rad180,theta1,
            phi2+xw->rad180,theta2);
         drawchord(xw,-phi1,theta1,-phi2,theta2);
         } /* if northern hemisphere */
      } /* for each node */
   } /* c2o_top_east */
