/* c2t_front_west.c Version 0.3.2. Class II Tetrahedron */
/* Front View, West Side Triangle */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2T_FRONT_WEST: class II tetrahedron, front view                */
/*                      west side triangle                              */
/*									*/

#include "xdome.h"

void c2t_front_west(xwfmt *xw)
   {
   double phi,theta;
   double newphi,newtheta;
   double phimed,thetamed;
   double diff;
   double prod1,prod2,prod3; 
   double dvsr,quotient;
   int *vtxfromptr;
   int *vtxtoptr;
   double *philstptr;
   double *thetalstptr;
   double *philowptr;
   double *thetalowptr;
   double *phiendptr;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   philstptr   = xw->philst;
   phiendptr   = xw->philst + xw->totnode;
   thetalstptr = xw->thetalst;
   philowptr   = xw->philow;
   thetalowptr = xw->thetalow;
   /* phimed and thetamed x=3 y=3 z=0 */
   phimed   = xw->rad60;
   thetamed = acos(sqrt(3.0) / 3.0);
   while (philstptr < phiendptr)
      {
      phi   = (*philstptr++) + xw->rad120;
      theta = *thetalstptr++;
      diff = phimed - phi;
      prod1 = cos(thetamed + thetamed) * cos(theta);     
      prod2 = sin(thetamed + thetamed)                   
         * sin(theta) * cos(diff);                      
      newtheta = acos(prod1 + prod2);
      prod3 = sin(theta) * sin(diff);
      dvsr = sin(newtheta);
      if (dvsr == 0.0)
         {
         quotient = 1.0;
         } /* divide by zero */
      else quotient = prod3 / dvsr;
      if (quotient > 1.0) quotient = 1.0;
      else if (quotient < -1.0) quotient = -1.0;
      newphi = asin(quotient);
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      } /* for each vertex */
   c2t_front_fg(xw);
   } /* c2t_front_west */
