/* domeinit.c Version 0.3.2. initialize global variables */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      DOMEINIT: Initialize global variables                           */
/*									*/

#include "xdome.h"

void domeinit(xwfmt *xw)
   {
   int *vtxfromptr;
   int *vtxfromend;
   int *vtxtoptr;
   int *vtxtoend;
   double *p,*q;
   xw->vtxfrom = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->vtxfrom == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating vtxfrom\n");
      exit(1);
      } /* out of mem */
   vtxfromptr = (int *) xw->vtxfrom;
   vtxfromend = (int *) xw->vtxfrom + TOTSTRUTS;
   while (vtxfromptr < vtxfromend)
      *vtxfromptr++ = -999999.9;  /* invalid node */
   xw->vtxto   = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->vtxto == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating vtxto\n");
      exit(1);
      } /* out of mem */
   vtxtoptr = (int *) xw->vtxto;
   vtxtoend = (int *) xw->vtxto + TOTSTRUTS;
   while (vtxtoptr < vtxtoend)
      *vtxtoptr++ = -999999.9;  /* invalid node */
   xw->topfrom = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->topfrom == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating topfrom\n");
      exit(1);
      } /* out of mem */
   xw->leftto = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->leftto == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating leftto\n");
      exit(1);
      } /* out of mem */
   xw->rghtto = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->rghtto == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating rghtto\n");
      exit(1);
      } /* out of mem */
   xw->bbmidpt = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->bbmidpt == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating bbmidpt\n");
      exit(1);
      } /* out of mem */
   xw->philst   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->philst == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating philst\n");
      exit(1);
      } /* out of mem */
   p = (double *) xw->philst;
   q = (double *) xw->philst + TOTNODES;
   while (p < q)
      *p++ = -999999.9;  /* invalid value */
   xw->thetalst   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->thetalst == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating thetalst\n");
      exit(1);
      } /* out of mem */
   p = (double *) xw->thetalst;
   q = (double *) xw->thetalst + TOTNODES;
   while (p < q)
      *p++ = -999999.9;  /* invalid value */
   xw->philow   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->philow == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating philow\n");
      exit(1);
      } /* out of mem */
   xw->thetalow   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->thetalow == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating thetalow\n");
      exit(1);
      } /* out of mem */
   xw->byplst   = (unsigned char *) malloc(TOTNODES);
   if (xw->byplst == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
         "allocating byplst\n");
      exit(1);
      } /* out of mem */
   xw->class    = CLASS_I;
   xw->dometype = ICOSA;
   xw->freq     = 3;
   xw->bball    = 0;
   xw->ecc      = 1.0;
   xw->shift    = 0;
   xw->view     = FRONT;
   xw->spin = xw->hrot = xw->vrot = 0.0;
   xw->wtfact   = xw->pause  = 0;
   xw->runflg   = xw->drawsw = 1;
   xw->tau = (sqrt(5.0) + 1.0) * 0.5;
   xw->oneovertau = 1.0 / xw->tau;
   xw->d2r = M_PI / 180.0;
   xw->r2d = 180.0 / M_PI;
   xw->rad12 = 12.0 * xw->d2r;
   xw->rad18 = 18.0 * xw->d2r;
   xw->rad36 = 36.0 * xw->d2r;
   xw->rad45 = 45.0 * xw->d2r;
   xw->rad54 = 54.0 * xw->d2r;
   xw->rad60 = 60.0 * xw->d2r;
   xw->rad72 = 72.0 * xw->d2r;
   xw->rad90 = 90.0 * xw->d2r;
   xw->rad108 = 108.0 * xw->d2r;
   xw->rad120 = 120.0 * xw->d2r;
   xw->rad144 = 144.0 * xw->d2r;
   xw->rad180 = 180.0 * xw->d2r;
   xw->rad216 = 216.0 * xw->d2r;
   xw->rad240 = 240.0 * xw->d2r;
   xw->rad288 = 288.0 * xw->d2r;
   xw->sin72 = sin(72.0 * xw->d2r);
   xw->cos36 = cos(36.0 * xw->d2r);
   xw->cos72 = cos(72.0 * xw->d2r);
   xw->tottri = xw->totvtx =
      xw->totnode = xw->totstr = 0;
   } /* domeinit */
