/*
xdome.c Version 0.3.2. Geodesic Dome for X Windows
Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/***********************************************

The mathematics for xdome is based on

Hugh Kenner, 1923-2003
Geodesic Math and How To Use It
Berkeley: University of California Press, 1976
Reprinted in October, 2003.
ISBN: 0-520-23931-8.   Paperback.

***********************************************/

#include "xdome.h"

int main()
   {
   xwfmt *xw;
   xw = (xwfmt *) malloc(sizeof(xwfmt) + 16);
   if (xw == NULL)
      {
      fprintf(stderr,"xdome: out of memory "
	 "allocating xw\n");
      exit(1);
      } /* out of mem */
   initx(xw,"xdome");
   domeinit(xw);
   while (xw->runflg)
      {
      XClearWindow(xw->dpy,xw->w);
      bld(xw);
      if (xw->runflg)
	 {
	 getkey(xw);
         } /* if still running */
      } /* for each dome */
   XDestroyWindow(xw->dpy,xw->w);
   XCloseDisplay(xw->dpy);
   domefree(xw);
   return(0);
   } /* main */
