/* 

   average.c - Average records output by report.exe 
   This module is part of average.exe
                  
   Language = Microsoft C version 4.0

   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1

	Notes:

   This program reads stdin, averages the values in the records,
   and writes the output to stdout.

   All records are assumed to have the same number of fields that the
   first record has, all entries are separated by commas.  Fields are
   assumed to be type long.

   If the "t" option is present, the first field is assumed to be a
   time stamp and is not passed through.  The n option gives the number of
   record to average, e.g. -n5 means average 5 records.
 

*/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char fbuf[1024];
int time_opt=0;
int nfield=0;
int nrecord=0;
int avg_record=0;
long array[100];


char * 
next_field(s)
char *s;
{
	while ((*s!='\0') && (*s != ',')) s++;
	if (*s=='\0') return(NULL);
	else return(s+1);
}


void
dump_it()
{
int i,j;
long tmpl;

	if (time_opt) {
		printf("%lu,",array[0]);
		i=1;
		}
	else i=0;

	for (j=i;j<nfield-1;j++) {
		tmpl = (array[j]*10) / (nrecord);
		if ((tmpl % 10)>=5) tmpl = (tmpl/10)+1;
		else tmpl=tmpl/10;
		printf("%lu,",tmpl);
		array[j]=0;
		}

	tmpl = (array[nfield-1]*10) / (nrecord);
	if ((tmpl % 10)>=5) tmpl = (tmpl/10)+1;
	else tmpl=tmpl/10;
	printf("%lu\n",tmpl );
	array[nfield-1]=0;
	nrecord=0;

	}
	
	


int
main(argc,argv)
int argc;
char *argv[];
{

int i;
char *s;

	for(i=0;i<100;i++) array[i]=0;

	/* get options */

	if (argc<2) {
		fprintf(stderr,"Usage: average -nnum [-t]\n");
		fprintf(stderr,"       t = first field is timestamp\n"); 
		fprintf(stderr,"       num specifies number of records to average\n");
		return(1);
		}

	for (i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-t") == 0)
			time_opt = 1;
		if (strncmp(argv[i], "-n", 2) == 0)
			avg_record = atoi(argv[i] + 2);
		}
	
	if (avg_record==0) {
		fprintf(stderr,"Must specify -n option\n");
		return(1);
		}


/* read data till done */

	nrecord=0;	/* number of records in this iteration */

	while(1) { 

		/* process data */

		if (gets(fbuf)==NULL) {
			if (nrecord>0) dump_it();
			break;
			}
		nfield=0;

		s=fbuf;
		if ( time_opt) {
			if (nrecord==0) 
				array[0]=atol(s);
			s=next_field(s);
			nfield++;
			}

		while (s!=NULL) {
			array[nfield++]+=atol(s);
			s=next_field(s);
			}

		if (++nrecord==avg_record) dump_it();

		}

		return(0);
	}
