/* repraw.c - format raw log repords for display.
   This module is part of report.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1
*/
/* repraw - raw record dump */
#define LINT_ARGS
#include "monfile.h"
#include <stdio.h>
#include <memory.h>
#include <ctype.h>
#include <time.h>
struct CIRCUIT_RECORD crec;
struct DIGI_RECORD drec;
struct FREQ_RECORD frec;
struct TIME_RECORD trec;
struct ID_RECORD irec;
struct FREQ_RECORD t_frec;

extern char sel_types[0];
extern FILE *fin,*fout;
extern char sel_call[11];
extern int sel_flag;
extern unsigned long recnum;

char fbuf[257];

long first_timestamp=0;
long last_timestamp=0; 

char *getrec(buf,size,file)
char *buf;
int size;
FILE *file;
{
char test[2];
char tbuf[30];

	while (1) {
		if (fgets(buf,size,file)==NULL) return(NULL);
		recnum++;
		test[1]='\0';
		test[0]=toupper(buf[0]);		
		if (test[0]=='T') {
			if (first_timestamp==0) 
				sscanf(fbuf+2,"%lu",&first_timestamp);
			sscanf(fbuf+2,"%lu",&last_timestamp);
			}

		if (strpbrk(sel_types,test)!=NULL) {
			if (! sel_flag) break;
			if (buf[0]!='C') break;
			strncpy(tbuf,buf,30);
			if (strcmp(strtok(tbuf+2,","),sel_call)==0) break;
			if (strcmp(strtok(NULL,","),sel_call)==0) break;
			}
		}

	return(buf);
}

void
report_raw(flag)
int flag;		/* set if only totals are desired */
{
int tmp;
unsigned long tmpl;
float tmpf;
char otype;
	
     otype='\0';
     first_timestamp=0;
     memset((char *)&t_frec,'\0',sizeof(t_frec));
     while(1) {
	if (getrec(fbuf,256,fin)==NULL) break;
	switch (fbuf[0]) {
	case TIME_TYPE:
		if (flag) break;
		tmp=sscanf(fbuf+2,"%lu",&trec.time_stamp);	
		if (tmp==1) {
			fprintf(fout,"\nTime Stamp %s\n",ctime(&trec.time_stamp));
			}
		else fprintf(stderr,"*** bad Time rec, number %lu ***\n",recnum);
		break;

	case FREQ_TYPE:
		tmp=sscanf(fbuf+2,"%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
			&frec.t_packets,
			&frec.t_bytes,
			&frec.u_packets,
			&frec.u_bytes,
			&frec.l32,
			&frec.l64,
			&frec.l128,
			&frec.l256,
			&frec.g256,
			&frec.dcd_on_ticks,
			&frec.dcd_off_ticks);

		if (tmp!=11) {
			fprintf(stderr,"*** bad Freq rec, number %lu ***\n",recnum); 
			break;
			}
		t_frec.t_packets+=frec.t_packets;
		t_frec.t_bytes+=frec.t_bytes;
		t_frec.u_packets+=frec.u_packets;
		t_frec.u_bytes+=frec.u_bytes;
		t_frec.l32+=frec.l32;
		t_frec.l64+=frec.l64;
		t_frec.l128+=frec.l128;
		t_frec.l256+=frec.l256;
		t_frec.g256+=frec.g256;
		t_frec.dcd_on_ticks+=frec.dcd_on_ticks;
		t_frec.dcd_off_ticks+=frec.dcd_off_ticks;

		if (flag) break;	/* totals only */

		tmpf= frec.l32+frec.l64+frec.l128+frec.l256+frec.g256;
		if (tmpf==0.0) tmpf=1.0;
		if (otype!=FREQ_TYPE) {
/*
			fprintf(fout,
"F Total    Total    Unique   Unique   %%DCD   %%<32  <64   <128  <256  >256\n");
			fprintf(fout,
"  Packets  Bytes    Packets  Bytes     ON \n"); 
*/
			fprintf(fout,
"F Total    Total    Unique   Unique   %%<32  <64   <128  <256  >256\n");
			fprintf(fout,
"  Packets  Bytes    Packets  Bytes \n"); 
			}
/*
		fprintf(fout,"  %-7lu  %-7lu  %-7lu  %-7lu  %-7.1f%-6.1f%-6.1f%-6.1f%-6.1f%-6.1f\n",
			frec.t_packets,
			frec.t_bytes,
			frec.u_packets,
			frec.u_bytes,
			(float) ((float) frec.dcd_on_ticks /	
			  (float) (frec.dcd_on_ticks+frec.dcd_off_ticks)) * 100.0,

			100.0 * (((float) frec.l32)/tmpf),
			100.0 * (((float) frec.l64)/tmpf),
			100.0 * (((float) frec.l128)/tmpf),
			100.0 * (((float) frec.l256)/tmpf),
			100.0 * (((float) frec.g256)/tmpf)
			);
*/
		fprintf(fout,"  %-7lu  %-7lu  %-7lu  %-7lu  %-6.1f%-6.1f%-6.1f%-6.1f%-6.1f\n",
			frec.t_packets,
			frec.t_bytes,
			frec.u_packets,
			frec.u_bytes,
			100.0 * (((float) frec.l32)/tmpf),
			100.0 * (((float) frec.l64)/tmpf),
			100.0 * (((float) frec.l128)/tmpf),
			100.0 * (((float) frec.l256)/tmpf),
			100.0 * (((float) frec.g256)/tmpf)
			);

		break;


	case DIGI_TYPE:
		tmp = sscanf(fbuf+2,"%[^,],%lu,%lu",drec.call,&drec.t_packets,
			&drec.t_bytes);
		if (tmp!=3) {
			fprintf(stderr,"*** bad Digi rec, number %lu ***\n",recnum); 
			break;
			}
		if (flag) break;
		if (otype!=DIGI_TYPE) 
			fprintf(fout,"\nD Call        Total Packets   Total Bytes\n");

		fprintf(fout,"  %-10s  %-9lu       %-9lu\n",
			drec.call,
			drec.t_packets,
			drec.t_bytes);     
		break;

	case CIRCUIT_TYPE:
		tmp = sscanf(fbuf+2,
"%[^,],%[^,],%u,%u,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,\
%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
		crec.to,		
		crec.from,		
		&crec.digis,		
		&crec.pid,
		&crec.u_dpackets,	
		&crec.nd_dpackets,	
		&crec.t_dpackets,	
		&crec.nd_packets,	
		&crec.t_packets,	
		&crec.u_dbytes,		
		&crec.nd_dbytes,	
		&crec.t_dbytes,		
		&crec.nd_bytes,		
		&crec.t_bytes,		
		&crec.c_time,		
		&crec.sabm,
		&crec.ua,
		&crec.disc,
		&crec.dm,
		&crec.rej,
		&crec.rr,
		&crec.rnr,
		&crec.i,
		&crec.ui,
		&crec.frmr,
		&crec.poll,
		&crec.final,
		&crec.l32,	
		&crec.l64,	
		&crec.l128,
		&crec.l256,
		&crec.g256);

		if (tmp!=32) {
			fprintf(stderr,"*** bad Circuit rec, number %lu ***\n",recnum); 
			break;
			}
		/*n* total */

		if (flag) break;
		
		fprintf(fout,"%-10s > %-10s  ",crec.from, crec.to);
			fprintf(fout,
		"------- I frames --------  ------ All frames -------\n");
			fprintf(fout,
"             %-10lu  Total    NotDigi  Unique   Total    NotDigi  \n",recnum);
			fprintf(fout,
"                         Packets  Packets  Packets  Packets  Packets\n");
			fprintf(fout,
"                         Bytes    Bytes    Bytes    Bytes    Bytes\n\n");
		fprintf(fout,"                         %-7lu  %-7lu  %-7lu  %-7lu  %-7lu\n",
			crec.t_dpackets,crec.nd_dpackets,crec.u_dpackets,
			crec.t_packets,crec.nd_packets);
		fprintf(fout,"                         %-7lu  %-7lu  %-7lu  %-7lu  %-7lu\n\n",
			crec.t_dbytes,crec.nd_dbytes,crec.u_dbytes,
			crec.t_bytes,crec.nd_bytes);
		fprintf(fout,
"                         sabm     ua       disc     dm       rej      rr\n");
		fprintf(fout,"                         %-7lu  %-7lu  %-7lu  %-7lu  %-7lu  %-7lu\n\n",
			crec.sabm,crec.ua,crec.disc,crec.dm,crec.rej,crec.rr);
		fprintf(fout,
"                         rnr      i        ui       frmr    poll      final\n");
		fprintf(fout,"                         %-7lu  %-7lu  %-7lu  %-7lu  %-7lu  %-7lu\n\n",
			crec.rnr,crec.i,crec.ui,crec.frmr,crec.poll,crec.final);
		fprintf(fout,    
"                         ndigi    <32      <64      <128    <256      >256\n");
		fprintf(fout,"                         %-7u  %-7lu  %-7lu  %-7lu  %-7lu  %-7lu\n\n",
			crec.digis,crec.l32,crec.l64,crec.l128,crec.l256,crec.g256);
		break;



		}
	otype = fbuf[0];
  }

	if (strchr(sel_types,'T')!=NULL) {
		fprintf(fout,"Totals:  Start time %24.24s\n",ctime(&first_timestamp));
		fprintf(fout,"         End time   %24.24s\n",ctime(&last_timestamp));
		tmpl=last_timestamp-first_timestamp;
		fprintf(fout,"         %lu hr  %lu min\n", tmpl/3600l,
			(tmpl % 3600l)/60l);
		}

	tmpf= t_frec.l32+t_frec.l64+t_frec.l128+t_frec.l256+t_frec.g256;

		if ((strchr(sel_types,'F')!=NULL) && (tmpf !=0.0 )){
/*
			fprintf(fout,
"F Total    Total    Unique   Unique   %%DCD   %%<32  <64   <128  <256  >256\n");
			fprintf(fout,
"  Packets  Bytes    Packets  Bytes     ON \n"); 
*/
			fprintf(fout,
"F Total    Total    Unique   Unique   %%<32  <64   <128  <256  >256\n");
			fprintf(fout,
"  Packets  Bytes    Packets  Bytes \n"); 
/*
		fprintf(fout,"  %-7lu  %-7lu  %-7lu  %-7lu  %-7.1f%-6.1f%-6.1f%-6.1f%-6.1f%-6.1f\n",
			t_frec.t_packets,
			t_frec.t_bytes,
			t_frec.u_packets,
			t_frec.u_bytes,
			(float) ((float) t_frec.dcd_on_ticks /	
			  (float) (t_frec.dcd_on_ticks+t_frec.dcd_off_ticks)) * 100.0,

			100.0 * (((float) t_frec.l32)/tmpf),
			100.0 * (((float) t_frec.l64)/tmpf),
			100.0 * (((float) t_frec.l128)/tmpf),
			100.0 * (((float) t_frec.l256)/tmpf),
			100.0 * (((float) t_frec.g256)/tmpf)
			);
*/
		fprintf(fout,"  %-7lu  %-7lu  %-7lu  %-7lu  %-6.1f%-6.1f%-6.1f%-6.1f%-6.1f\n",
			t_frec.t_packets,
			t_frec.t_bytes,
			t_frec.u_packets,
			t_frec.u_bytes,
			100.0 * (((float) t_frec.l32)/tmpf),
			100.0 * (((float) t_frec.l64)/tmpf),
			100.0 * (((float) t_frec.l128)/tmpf),
			100.0 * (((float) t_frec.l256)/tmpf),
			100.0 * (((float) t_frec.g256)/tmpf)
			);
		}

}
			
